% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.r
\name{logistic_cluster_univariate}
\alias{logistic_cluster_univariate}
\title{Univariate Logistic Regression with cluster}
\usage{
logistic_cluster_univariate(
  data,
  y_names,
  x_names,
  cluster,
  twobytwo = TRUE,
  formula = "(y ~ x)",
  collapse = FALSE,
  ref_label = "1",
  digits = 2
)
}
\arguments{
\item{data}{A dataframe including all the variables needed in all the models}

\item{y_names}{Vector. Name(s) of response variable(s)}

\item{x_names}{Vector. Name(s) of predictor variable(s)}

\item{cluster}{Character. Name of the clustering variable.}

\item{twobytwo}{Logical. Either to include the two by two table for each
variable. Default is \code{TRUE}.}

\item{formula}{Formula for logistic regression to customize. Default is
\code{(y ~ x)}.}

\item{collapse}{\code{"NULL"}, \code{"OR"}, \code{"CI"}. Collapse columns in
one column. \code{"OR"} collapses OR, Upper and Lower CI. \code{"CI"}
collapses Upper and Lower CI.}

\item{ref_label}{Character. Set the label for reference estimate.}

\item{digits}{Numeric. Number of digits to display.}
}
\value{
The returned value is a list of length \code{y_names}, which consists
  of a dataframe having the univariate logistic regressions of the
  \code{x_names}.
}
\description{
A function used to generate multiple result table for univariate logistic
regression model with \code{y ~ x} using a cluster variable. For each
specified \code{y_names}, a result table is computed, including all
\code{x_names} variables. Compute robust variance using sandwich
}
