/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.text.DecimalFormat;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;

public class JniInChIInputAdapter
extends JniInchiInput {
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
    private static final String FLAG_CHAR = IS_WINDOWS ? "/" : "-";
    public static final String FIVE_SECOND_TIMEOUT = FLAG_CHAR + "W5";

    public JniInChIInputAdapter(String options) throws JniInchiException {
        this.options = options == null ? "" : JniInChIInputAdapter.checkOptions(options);
    }

    public JniInChIInputAdapter(List<INCHI_OPTION> options) throws JniInchiException {
        this.options = options == null ? "" : JniInChIInputAdapter.checkOptions(options);
    }

    private static boolean isTimeoutOptions(String op) {
        if (op == null || op.length() < 2) {
            return false;
        }
        int pos = 0;
        int len = op.length();
        if (op.charAt(pos) == 'W') {
            ++pos;
        }
        while (pos < len && Character.isDigit(op.charAt(pos))) {
            ++pos;
        }
        if (pos < len && (op.charAt(pos) == '.' || op.charAt(pos) == ',')) {
            ++pos;
        }
        while (pos < len && Character.isDigit(op.charAt(pos))) {
            ++pos;
        }
        return pos == len;
    }

    private static boolean isSubSecondTimeout(String op) {
        return op.indexOf(46) >= 0 || op.indexOf(44) >= 0;
    }

    private static String checkOptions(String ops) throws JniInchiException {
        if (ops == null) {
            throw new IllegalArgumentException("Null options");
        }
        StringBuilder sbOptions = new StringBuilder();
        boolean hasUserSpecifiedTimeout = false;
        StringTokenizer tok = new StringTokenizer(ops);
        while (tok.hasMoreTokens()) {
            INCHI_OPTION option;
            String op = tok.nextToken();
            if (op.startsWith("-") || op.startsWith("/")) {
                op = op.substring(1);
            }
            if ((option = INCHI_OPTION.valueOfIgnoreCase(op)) != null) {
                sbOptions.append(FLAG_CHAR).append(option.name());
                if (!tok.hasMoreTokens()) continue;
                sbOptions.append(" ");
                continue;
            }
            if (JniInChIInputAdapter.isTimeoutOptions(op)) {
                if (JniInChIInputAdapter.isSubSecondTimeout(op)) {
                    Double time = Double.parseDouble(op.substring(1));
                    DecimalFormat format = new DecimalFormat("#.##");
                    sbOptions.append(FLAG_CHAR).append('W').append(format.format(time));
                } else {
                    sbOptions.append(FLAG_CHAR).append(op);
                }
                hasUserSpecifiedTimeout = true;
                if (!tok.hasMoreTokens()) continue;
                sbOptions.append(" ");
                continue;
            }
            if ("15T".equals(op)) {
                sbOptions.append(FLAG_CHAR).append("15T");
                if (!tok.hasMoreTokens()) continue;
                sbOptions.append(" ");
                continue;
            }
            if ("KET".equals(op)) {
                sbOptions.append(FLAG_CHAR).append("KET");
                if (!tok.hasMoreTokens()) continue;
                sbOptions.append(" ");
                continue;
            }
            throw new JniInchiException("Unrecognised InChI option");
        }
        if (!hasUserSpecifiedTimeout) {
            if (sbOptions.length() > 0) {
                sbOptions.append(' ');
            }
            sbOptions.append(FIVE_SECOND_TIMEOUT);
        }
        return sbOptions.toString();
    }

    private static String checkOptions(List<INCHI_OPTION> ops) throws JniInchiException {
        if (ops == null) {
            throw new IllegalArgumentException("Null options");
        }
        StringBuilder sbOptions = new StringBuilder();
        for (INCHI_OPTION op : ops) {
            sbOptions.append(FLAG_CHAR).append(op.name()).append(" ");
        }
        if (sbOptions.length() > 0) {
            sbOptions.append(' ');
        }
        sbOptions.append(FIVE_SECOND_TIMEOUT);
        return sbOptions.toString();
    }
}

