/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.StandardSubstructureSets;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.smarts.SmartsPattern;

public class SubstructureFingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private List<Key> keys = new ArrayList<Key>();

    public SubstructureFingerprinter(String[] smarts) {
        this.setSmarts(smarts);
    }

    public SubstructureFingerprinter() {
        try {
            this.setSmarts(StandardSubstructureSets.getFunctionalGroupSMARTS());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load SMARTS patterns", ex);
        }
    }

    private void setSmarts(String[] smarts) {
        this.keys.clear();
        for (String key : smarts) {
            QueryAtomContainer qmol = new QueryAtomContainer(null);
            SmartsPattern ptrn = null;
            ptrn = SmartsPattern.create(key);
            ptrn.setPrepare(false);
            this.keys.add(new Key(key, ptrn));
        }
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        if (this.keys.isEmpty()) {
            throw new CDKException("No substructures were defined");
        }
        SmartsPattern.prepare(atomContainer);
        BitSet fingerPrint = new BitSet(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get((int)i).pattern.matches(atomContainer)) continue;
            fingerPrint.set(i, true);
        }
        return new BitSetFingerprint(fingerPrint);
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer atomContainer) throws CDKException {
        if (this.keys.isEmpty()) {
            throw new CDKException("No substructures were defined");
        }
        SmartsPattern.prepare(atomContainer);
        final TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (int i = 0; i < this.keys.size(); ++i) {
            Pattern ptrn = this.keys.get((int)i).pattern;
            map.put(i, ptrn.matchAll(atomContainer).countUnique());
        }
        final int length = this.keys.size();
        final int size = map.size();
        final int[] hash = new int[size];
        final int[] count = new int[size];
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int h;
            hash[n] = h = ((Integer)iterator.next()).intValue();
            count[n++] = (Integer)map.get(h);
        }
        return new ICountFingerprint(){

            @Override
            public long size() {
                return length;
            }

            @Override
            public int numOfPopulatedbins() {
                return size;
            }

            @Override
            public int getCount(int index) {
                return count[index];
            }

            @Override
            public int getHash(int index) {
                return hash[index];
            }

            @Override
            public void merge(ICountFingerprint fp) {
            }

            @Override
            public void setBehaveAsBitFingerprint(boolean behaveAsBitFingerprint) {
            }

            @Override
            public boolean hasHash(int hash2) {
                return map.containsKey(hash2);
            }

            @Override
            public int getCountForHash(int hash2) {
                return (Integer)map.get(hash2);
            }
        };
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return this.keys.size();
    }

    public String getSubstructure(int bitIndex) {
        return this.keys.get((int)bitIndex).smarts;
    }

    private static final class Key {
        final String smarts;
        final Pattern pattern;

        public Key(String smarts, Pattern pattern) {
            this.smarts = smarts;
            this.pattern = pattern;
        }
    }
}

