/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.IPretty;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;

public final class IntBranchingTrace
implements IntBranchingDecision {
    private AbstractIntBranchingStrategy branching;
    private Object branchingObject;
    private int branchIndex;
    private int branchingValue = Integer.MAX_VALUE;

    public IntBranchingTrace() {
    }

    private IntBranchingTrace(AbstractIntBranchingStrategy branching, Object branchingObject, int branchIndex, int branchingValue) {
        this.branching = branching;
        this.branchingObject = branchingObject;
        this.branchIndex = branchIndex;
        this.branchingValue = branchingValue;
    }

    public final AbstractIntBranchingStrategy getBranching() {
        return this.branching;
    }

    public final void setBranching(AbstractIntBranchingStrategy branching) {
        this.branching = branching;
    }

    @Override
    public final int getBranchIndex() {
        return this.branchIndex;
    }

    public final void setBranchIndex(int branchIndex) {
        this.branchIndex = branchIndex;
    }

    public final void incrementBranchIndex() {
        ++this.branchIndex;
    }

    @Override
    public final int getBranchingValue() {
        return this.branchingValue;
    }

    @Override
    public final void setBranchingValue(int branchingValue) {
        this.branchingValue = branchingValue;
    }

    @Override
    public final Object getBranchingObject() {
        return this.branchingObject;
    }

    @Override
    public final IntDomainVar getBranchingIntVar() {
        return (IntDomainVar)this.branchingObject;
    }

    @Override
    public final SetVar getBranchingSetVar() {
        return (SetVar)this.branchingObject;
    }

    @Override
    public final RealVar getBranchingRealVar() {
        return (RealVar)this.branchingObject;
    }

    public final void setBranchingObject(Object branchingObject) {
        this.branchingObject = branchingObject;
    }

    public void clear() {
        this.branchIndex = 0;
        this.branchingObject = null;
        this.branching = null;
        this.branchingValue = Integer.MAX_VALUE;
    }

    public IntBranchingTrace copy() {
        return new IntBranchingTrace(this.branching, this.branchingObject, this.branchIndex, this.branchingValue);
    }

    @Override
    public final void setIntVal() throws ContradictionException {
        ((IntVar)this.branchingObject).setVal(this.branchingValue);
    }

    @Override
    public final void remIntVal() throws ContradictionException {
        ((IntDomainVar)this.branchingObject).remVal(this.branchingValue);
    }

    @Override
    public final void setValInSet() throws ContradictionException {
        ((SetVar)this.branchingObject).setValIn(this.branchingValue);
    }

    @Override
    public final void setValOutSet() throws ContradictionException {
        ((SetVar)this.branchingObject).setValOut(this.branchingValue);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        if (this.branchingObject instanceof IPretty) {
            b.append(((IPretty)this.branchingObject).pretty());
        } else {
            b.append(this.branchingObject);
        }
        if (this.branchingValue != Integer.MAX_VALUE) {
            b.append(" value=").append(this.branchingValue);
        }
        b.append(" branch ").append(this.branchIndex);
        return new String(b);
    }
}

