/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.test;

import com.garmin.fit.Decode;
import com.garmin.fit.Fit;
import com.garmin.fit.test.Tests;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class TestTool {
    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.printf("FIT Test Tool %d.%d.%d.%d\n", 1, 0, 16, 10);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d")) {
                Fit.debug = true;
                continue;
            }
            String string = stringArray[i];
            arrayList.add(string);
        }
        if (arrayList.size() == 0) {
            TestTool.printUsage();
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = arrayList.toArray();
            System.out.println("Input file: " + (String)objectArray[i]);
            try {
                if (!Decode.checkIntegrity(new FileInputStream((String)objectArray[i]))) {
                    throw new RuntimeException("FIT file integrity failure.");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            Tests tests = new Tests();
            System.out.println("Running FIT file verification tests...");
            if (tests.run((String)objectArray[i])) {
                System.out.println("Passed FIT file verification.");
                continue;
            }
            System.out.println("Failed FIT file verification.");
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar FitTestTool.jar <INPUT FILE> <INPUT FILE>");
        System.out.println("      -d Enable debug output.");
    }
}

