/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Decode;
import com.garmin.fit.FileEncoder;
import com.garmin.fit.Fit;
import com.garmin.fit.csv.CSVReader;
import com.garmin.fit.csv.MesgCSVWriter;
import com.garmin.fit.csv.MesgDataCSVWriter;
import com.garmin.fit.csv.MesgFilter;
import com.garmin.fit.test.Tests;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class CSVTool {
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        int n2 = 0;
        System.out.printf("FIT CSV Tool - Protocol %d.%d Profile %.2f %s\n", 1, 0, 16.1, "Release");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-b")) {
                if (stringArray.length - i < 3) {
                    CSVTool.printUsage();
                    return;
                }
                bl = true;
                string = stringArray[i + 1];
                string2 = stringArray[i + 2];
                i += 2;
            } else if (stringArray[i].equals("-c")) {
                if (stringArray.length - i < 3) {
                    CSVTool.printUsage();
                    return;
                }
                bl2 = true;
                string = stringArray[i + 1];
                string2 = stringArray[i + 2];
                i += 2;
            } else if (stringArray[i].equals("-t")) {
                bl3 = true;
            } else if (stringArray[i].equals("-d")) {
                Fit.debug = true;
                bl3 = true;
            } else if (stringArray[i].equals("-i")) {
                bl4 = true;
            } else if (stringArray[i].equals("--defn")) {
                n = 2;
            } else if (stringArray[i].equals("--data")) {
                n2 = 2;
            } else if (stringArray[i].charAt(0) != '-') {
                if (n > 0) {
                    arrayList = new ArrayList<String>(Arrays.asList(stringArray[i].toLowerCase().split(",")));
                } else if (n2 > 0) {
                    arrayList2 = new ArrayList<String>(Arrays.asList(stringArray[i].toLowerCase().split(",")));
                } else {
                    string = stringArray[i];
                    if (string.endsWith(".fit")) {
                        bl = true;
                        string2 = string.substring(0, string.length() - 4) + ".csv";
                    } else if (string.endsWith(".csv")) {
                        bl2 = true;
                        string2 = string.substring(0, string.length() - 4) + ".fit";
                    }
                }
            } else if (stringArray[i].equals("-s")) {
                bl5 = true;
            } else if (stringArray[i].equals("-se")) {
                bl5 = true;
                bl6 = true;
            }
            if (n > 0 && --n == 0 && arrayList.isEmpty()) {
                System.out.println("No mesg definitions defined for --defn option.  Use 'none' if no definitions are desired.");
                return;
            }
            if (n2 <= 0 || --n2 != 0 || !arrayList2.isEmpty()) continue;
            System.out.println("No data messages defined for --data option.  Use 'none' if no data is desired.");
            return;
        }
        if (bl) {
            Object object;
            if (string2.length() >= 4 && string2.substring(string2.length() - 4, string2.length()).compareTo(".csv") == 0) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            if (bl4) {
                try {
                    if (!Decode.checkIntegrity(new FileInputStream(string))) {
                        throw new RuntimeException("FIT file integrity failure.");
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            if (bl3) {
                object = new Tests();
                System.out.println("Running FIT verification tests...");
                if (((Tests)object).run(string)) {
                    System.out.println("Passed FIT verification.");
                } else {
                    System.out.println("Failed FIT verification.");
                }
            }
            try {
                object = new Decode();
                MesgCSVWriter mesgCSVWriter = new MesgCSVWriter(string2 + ".csv");
                FileInputStream fileInputStream = new FileInputStream(string);
                if (bl5) {
                    ((Decode)object).showInvalidValues();
                }
                MesgFilter mesgFilter = new MesgFilter();
                mesgFilter.setMesgDefinitionsToOutput(arrayList);
                mesgFilter.setDataMessagesToOutput(arrayList2);
                MesgDataCSVWriter mesgDataCSVWriter = new MesgDataCSVWriter(string2 + "_data.csv");
                if (bl6) {
                    mesgCSVWriter.showInvalidsAsEmptyCells();
                    mesgDataCSVWriter.showInvalidsAsEmptyCells();
                }
                mesgFilter.addListener(mesgCSVWriter);
                mesgFilter.addListener(mesgCSVWriter);
                mesgFilter.addListener(mesgDataCSVWriter);
                ((Decode)object).addListener(mesgFilter);
                ((Decode)object).addListener(mesgFilter);
                while (fileInputStream.available() > 0) {
                    ((Decode)object).read(fileInputStream);
                    ((Decode)object).nextFile();
                }
                mesgCSVWriter.close();
                mesgDataCSVWriter.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            System.out.printf("FIT binary file %s decoded to %s*.csv files.\n", string, string2);
        } else if (bl2) {
            try {
                FileEncoder fileEncoder = new FileEncoder(new File(string2));
                if (!CSVReader.read(new FileInputStream(string), fileEncoder, fileEncoder)) {
                    throw new RuntimeException("FIT encoding error.");
                }
                fileEncoder.close();
                System.out.printf("%s encoded into FIT binary file %s.\n", string, string2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            CSVTool.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar FitCSVTool.jar <options> <file>");
        System.out.println("      -b <FIT FILE> <CSV FILE>  FIT binary to CSV.");
        System.out.println("      -c <CSV FILE> <FIT FILE>  CSV to FIT binary.");
        System.out.println("      -t Enable file verification tests.");
        System.out.println("      -d Enable debug output.");
        System.out.println("      -i Check integrity of FIT file before decoding.");
        System.out.println("      -s Show invalid fields in the CSV file.");
        System.out.println("      -se Show invalid fields in the CSV file as empty cells.");
        System.out.println("      --defn <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          definitions output to CSV. Use 'none' for no definitions");
        System.out.println("          When this option is used only the message definitions");
        System.out.println("          in the comma separated list will be written to the CSV.");
        System.out.println("          eg. --defn file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
        System.out.println("      --data <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          data output to CSV. Use 'none' for no definitions.");
        System.out.println("          When this option is used only the data");
        System.out.println("          in the comma separated list will be written to the csv.");
        System.out.println("          eg. --data file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
    }
}

