### R code from vignette source 'adivGuide.Rnw'

###################################################
### code chunk number 1: adivGuide.Rnw:65-69
###################################################
owidth <- getOption("width")
options("width"=80)
ow <- getOption("warn")
options("warn"=-1)


###################################################
### code chunk number 2: adivGuide.Rnw:645-646 (eval = FALSE)
###################################################
## install.packages("adiv")


###################################################
### code chunk number 3: adivGuide.Rnw:650-651
###################################################
library(adiv)


###################################################
### code chunk number 4: adivGuide.Rnw:656-659 (eval = FALSE)
###################################################
## install.packages("ape")
## install.packages("phylobase")
## install.packages("ade4")


###################################################
### code chunk number 5: adivGuide.Rnw:663-666
###################################################
library(ape)
library(phylobase)
library(ade4)


###################################################
### code chunk number 6: adivGuide.Rnw:680-681
###################################################
data(batcomm)


###################################################
### code chunk number 7: adivGuide.Rnw:684-687
###################################################
batab <- batcomm$ab
rownames(batab)
rownames(batab) <- c("rainforest","cacao plantations","oldfields","cornfields")


###################################################
### code chunk number 8: adivGuide.Rnw:692-694
###################################################
plot(divparam(batab, q=seq(0, 3, le=50)), pch=1:4, col=1:4, 
    axisLABEL = "Species diversity")


###################################################
### code chunk number 9: adivGuide.Rnw:713-715
###################################################
plot(eveparam(batab, q=seq(0, 3, le=50)), pch=1:4, col=1:4, 
    axisLABEL = "Species evenness")


###################################################
### code chunk number 10: adivGuide.Rnw:740-741
###################################################
dotchart(sort(unlist(batcomm$ab[1,])), font=3, main="Rainforest", xlab="Abundance")


###################################################
### code chunk number 11: adivGuide.Rnw:748-749
###################################################
dotchart(sort(unlist(batcomm$ab[2,])), font=3, main="Cacao plantations", xlab="Abundance")


###################################################
### code chunk number 12: adivGuide.Rnw:756-757
###################################################
dotchart(sort(unlist(batcomm$ab[3,])), font=3, main="Oldfields", xlab="Abundance")


###################################################
### code chunk number 13: adivGuide.Rnw:764-765
###################################################
dotchart(sort(unlist(batcomm$ab[4,])), font=3, main="Cornfieds", xlab="Abundance")


###################################################
### code chunk number 14: adivGuide.Rnw:781-786
###################################################
phy <- read.tree(text=batcomm$tre) # Bat phylogenetic tree 
ab <- batab[, phy$tip.label] 
# Species in the abundance table are ordered as in the phylogenetic tree 
plot(evodivparam(phy, ab, q=seq(0, 3, le=50)), pch=1:4, col=1:4) 
# Resulting diversity profiles 


###################################################
### code chunk number 15: adivGuide.Rnw:804-808
###################################################
par(mfrow=c(1,2)) 
barplot(QE(ab, as.dist(cophenetic(phy)))$diversity) 
barplot(Rentropy(ab, as.dist(cophenetic(phy)))$diversity)
par(mfrow=c(1,1))


###################################################
### code chunk number 16: adivGuide.Rnw:819-821
###################################################
bat.4d <- phylo4d(phy, log(t(ab)+1))
barp4d(bat.4d, center = FALSE, scale = FALSE, tip.cex = 0.75, data.xlim = c(0, 5))


###################################################
### code chunk number 17: adivGuide.Rnw:837-841
###################################################
ori <- cbind.data.frame(distinctTree(phy, c("ED", "ES")), 
    distinctUltra(phy, c("Qb", "2Hb")))
bat.4d <- phylo4d(phy, ori)
barp4d(bat.4d, center = FALSE, scale = FALSE)


###################################################
### code chunk number 18: adivGuide.Rnw:849-855
###################################################
pa <- ab; pa[ab>0] <- 1 # Matrix of the presence/absence of the species in the four habitats
dphy <- cophenetic(phy) # Matrix of phylogenetic distances between species
# P-value of the test with abundance data:
rtestEqRS(ab, as.dist(dphy), nrep=999)$pvalue 
# P-value of the test with presence/absence data:
rtestEqRS(pa, as.dist(dphy), nrep=999)$pvalue # P-value of the test	


###################################################
### code chunk number 19: adivGuide.Rnw:864-865
###################################################
evodiss(phy, ab, "Chord")


###################################################
### code chunk number 20: adivGuide.Rnw:870-871
###################################################
plot(abgevodivparam(phy, ab, q=seq(0, 3, le=50)))


###################################################
### code chunk number 21: adivGuide.Rnw:879-882
###################################################
evoca <- evoCA(phy, pa, scannf=FALSE, nf=2) # Two axes are here retained.
# % of inertia (eigenvalues) expressed by each axis:
evoca$eig/sum(evoca$eig) 


###################################################
### code chunk number 22: adivGuide.Rnw:887-890
###################################################
plot(evoca$li[, 1], evoca$li[, 2], xlab = "Axis1", ylab="Axis2", col="red", pch=19, asp=1)
abline(h=0, col="grey"); abline(v=0, col="grey") 
text(evoca$li[, 1], evoca$li[, 2], rownames(evoca$li), pos = c(2,2,4,2), offset=0.2)


###################################################
### code chunk number 23: adivGuide.Rnw:898-902
###################################################
kept <- rownames(inertia.dudi(evoca, col=TRUE)$col.abs)[apply(inertia.dudi(evoca, 
    col=TRUE)$col.abs, 1, max)>5]
keptc <- kept[-10] # graphical improvements to avoid the labels superimpose
keptc[9] <- paste(kept[9:10], collapse="\n")


###################################################
### code chunk number 24: adivGuide.Rnw:906-912
###################################################
plot(evoca$co[, 1], evoca$co[, 2], xlab = "Axis1", ylab="Axis2", col="grey", asp = 1)
abline(h=0, col="grey"); abline(v=0, col="grey") 
points(evoca$co[kept, 1], evoca$co[kept, 2], col ="red", pch = 19)
positions <- c(2,2,2,4,1,2,4,3,1,3)
text(evoca$co[kept[-10], 1], evoca$co[kept[-10], 2], gsub("_", " ", keptc), 
    pos = positions, offset = 0.75, font=3)


###################################################
### code chunk number 25: adivGuide.Rnw:925-931
###################################################
# phylogenetic tree with some of the tip labels colored
tipcolors <- rep(1, 34)
tipcolors[phy$tip.label %in% kept] <- "red"
tipcolors[phy$tip.label== "Bauerus_dubiaquercus"] <- "violet"
tipcolors[phy$tip.label%in%c("Myotis_keaysi", "Hylonycteris_underwoodi",  "Lichonycteris_obscura")] <- "blue"
plot(phy, show.node.label=TRUE, tip.color=tipcolors, cex=0.75)


###################################################
### code chunk number 26: adivGuide.Rnw:941-943
###################################################
bat.4d <- phylo4d(phy, evoca$co[phy$tip.label, ])
dotp4d(bat.4d, center = FALSE, scale = FALSE)


###################################################
### code chunk number 27: adivGuide.Rnw:951-952 (eval = FALSE)
###################################################
## plot(evoca)


