/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;
import java.util.HashSet;

public class SsfCalendarizationEx
implements ISsf {
    public final double[] weights;
    public final HashSet<Integer> starts = new HashSet();
    public final HashSet<Integer> ends = new HashSet();
    public final HashSet<Integer> astarts = new HashSet();
    public final HashSet<Integer> aends = new HashSet();
    private int curpos = -1;
    private int curtype = -1;
    private int apos = -1;
    private int aggtype = -1;
    private static final int LAST = 1;
    private static final int FIRST = 2;
    private static final int DEF = 0;

    private int posType(int pos) {
        if (this.curpos == pos) {
            return this.curtype;
        }
        this.curpos = pos;
        this.curtype = this.starts.contains(pos) ? 2 : (this.ends.contains(pos) ? 1 : 0);
        return this.curtype;
    }

    private int aggType(int pos) {
        if (this.apos == pos) {
            return this.aggtype;
        }
        this.apos = pos;
        this.aggtype = this.astarts.contains(pos) ? 2 : (this.aends.contains(pos) ? 1 : 0);
        return this.aggtype;
    }

    public SsfCalendarizationEx(int[] starts, int[] astarts, double[] w) {
        int cur;
        int i;
        this.weights = w;
        for (i = 0; i < starts.length; ++i) {
            cur = starts[i];
            this.starts.add(cur);
            if (cur <= 0) continue;
            this.ends.add(cur - 1);
        }
        for (i = 0; i < astarts.length; ++i) {
            cur = astarts[i];
            this.astarts.add(cur);
            if (cur <= 0) continue;
            this.aends.add(cur - 1);
        }
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        b.set(2, 0, 1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(2, 2, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 1;
    }

    @Override
    public int getStateDim() {
        return 3;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        int postype = this.posType(pos);
        if (postype != 2) {
            lm.column(0).addAY(-1.0, k);
        }
        double a = this.weight(pos);
        lm.column(2).addAY(-a, k);
    }

    private double mweight(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * m;
    }

    private double mweight2(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * this.weights[pos] * m;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.set(2, 2, 1.0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        pi0.set(2, 2, 1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 2);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        int atype;
        tr.set(2, 2, 1.0);
        int postype = this.posType(pos);
        if (postype != 1) {
            tr.set(0, 2, this.weight(pos));
            if (postype != 2) {
                tr.set(0, 0, 1.0);
            }
        }
        if ((atype = this.aggType(pos)) != 1) {
            tr.set(1, 2, this.weight(pos));
            if (atype != 2) {
                tr.set(1, 1, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlockIterator columns = vm.columns();
        DataBlock column = columns.getData();
        do {
            this.TX(pos, column);
        } while (columns.next());
        DataBlockIterator rows = vm.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int postype = this.posType(pos);
        double s = this.mweight(pos, x.get(2));
        if (postype == 1) {
            x.set(0, 0.0);
        } else if (postype == 2) {
            x.set(0, s);
        } else {
            x.add(0, s);
        }
        int atype = this.aggType(pos);
        if (atype == 1) {
            x.set(1, 0.0);
        } else if (atype == 2) {
            x.set(1, s);
        } else {
            x.add(1, s);
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(2, 2, this.mweight2(pos, d));
        int postype = this.posType(pos);
        if (postype != 2) {
            double w = this.mweight(pos, d);
            vm.add(0, 0, d);
            vm.add(0, 2, w);
            vm.add(2, 0, w);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    private double weight(int pos) {
        return this.weights == null ? 1.0 : this.weights[pos];
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(2, this.mweight(pos, d));
        int postype = this.posType(pos);
        if (postype != 2) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        int postype = this.posType(pos);
        if (postype == 1) {
            x.set(0, 0.0);
        } else if (postype == 2) {
            x.add(2, this.mweight(pos, x.get(0)));
            x.set(0, 0.0);
        } else {
            x.add(2, this.mweight(pos, x.get(0)));
        }
        int atype = this.aggType(pos);
        if (atype == 1) {
            x.set(1, 0.0);
        } else if (postype == 2) {
            x.add(2, this.mweight(pos, x.get(1)));
            x.set(1, 0.0);
        } else {
            x.add(2, this.mweight(pos, x.get(1)));
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        int postype = this.posType(pos);
        if (postype == 2) {
            z.set(0, 0.0);
        } else {
            z.set(0, 1.0);
        }
        z.set(2, this.weight(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.product(m.row(2), this.weight(pos));
        int postype = this.posType(pos);
        if (postype != 2) {
            x.add(m.row(0));
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        int postype = this.posType(pos);
        if (postype == 2) {
            return this.mweight2(pos, vm.get(2, 2));
        }
        double r = vm.get(0, 0);
        r += this.mweight(pos, 2.0 * vm.get(2, 0));
        return r += this.mweight2(pos, vm.get(2, 2));
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        int postype = this.posType(pos);
        double r = postype == 2 ? 0.0 : x.get(0);
        return r + this.mweight(pos, x.get(2));
    }
}

