/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Splitter;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.myrrix.common.LangUtils;
import net.myrrix.common.OneWayMigrator;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.InvertedFilenameFilter;
import net.myrrix.common.iterator.FileLineIterable;
import net.myrrix.common.math.MatrixUtils;
import net.myrrix.online.generation.ByLastModifiedComparator;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InputFilesReader {
    private static final Logger log = LoggerFactory.getLogger(InputFilesReader.class);
    private static final Splitter COMMA = Splitter.on(',').trimResults();
    private static final float ZERO_THRESHOLD = Float.parseFloat(System.getProperty("model.decay.zeroThreshold", "0.0001"));

    private InputFilesReader() {
    }

    static void readInputFiles(FastByIDMap<FastIDSet> knownItemIDs, FastByIDMap<FastByIDFloatMap> rbyRow, FastByIDMap<FastByIDFloatMap> rbyColumn, FastIDSet itemTagIDs, FastIDSet userTagIDs, File inputDir) throws IOException {
        File[] inputFiles;
        PatternFilenameFilter csvFilter = new PatternFilenameFilter(".+\\.csv(\\.(zip|gz))?");
        File[] otherFiles = inputDir.listFiles(new InvertedFilenameFilter(csvFilter));
        if (otherFiles != null) {
            for (File otherFile : otherFiles) {
                log.info("Skipping file {}", (Object)otherFile.getName());
            }
        }
        if ((inputFiles = inputDir.listFiles(csvFilter)) == null) {
            log.info("No input files in {}", (Object)inputDir);
            return;
        }
        Arrays.sort(inputFiles, ByLastModifiedComparator.INSTANCE);
        OneWayMigrator hash = new OneWayMigrator();
        int lines = 0;
        int badLines = 0;
        for (File inputFile : inputFiles) {
            log.info("Reading {}", (Object)inputFile);
            for (String line : new FileLineIterable(inputFile)) {
                float value;
                long itemID;
                boolean itemIsTag;
                long userID;
                boolean userIsTag;
                if (badLines > 100) {
                    throw new IOException("Too many bad lines; aborting");
                }
                ++lines;
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                Iterator<String> it = COMMA.split(line).iterator();
                try {
                    String valueToken;
                    String userIDString = it.next();
                    userIsTag = userIDString.startsWith("\"");
                    userID = userIsTag ? hash.toLongID(userIDString.substring(1, userIDString.length() - 1)) : Long.parseLong(userIDString);
                    String itemIDString = it.next();
                    itemIsTag = itemIDString.startsWith("\"");
                    itemID = itemIsTag ? hash.toLongID(itemIDString.substring(1, itemIDString.length() - 1)) : Long.parseLong(itemIDString);
                    value = it.hasNext() ? ((valueToken = it.next()).isEmpty() ? Float.NaN : LangUtils.parseFloat(valueToken)) : 1.0f;
                }
                catch (NoSuchElementException ignored) {
                    log.warn("Ignoring line with too few columns: '{}'", (Object)line);
                    ++badLines;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    if (lines == 1) {
                        log.info("Ignoring header line: '{}'", (Object)line);
                        continue;
                    }
                    log.warn("Ignoring unparseable line: '{}'", (Object)line);
                    ++badLines;
                    continue;
                }
                if (userIsTag && itemIsTag) {
                    log.warn("Two tags not allowed: '{}'", (Object)line);
                    ++badLines;
                    continue;
                }
                if (userIsTag) {
                    itemTagIDs.add(userID);
                }
                if (itemIsTag) {
                    userTagIDs.add(itemID);
                }
                if (Float.isNaN(value)) {
                    MatrixUtils.remove(userID, itemID, rbyRow, rbyColumn);
                } else {
                    MatrixUtils.addTo(userID, itemID, value, rbyRow, rbyColumn);
                }
                if (knownItemIDs != null) {
                    FastIDSet itemIDs = knownItemIDs.get(userID);
                    if (Float.isNaN(value)) {
                        if (itemIDs != null) {
                            itemIDs.remove(itemID);
                            if (itemIDs.isEmpty()) {
                                knownItemIDs.remove(userID);
                            }
                        }
                    } else {
                        if (itemIDs == null) {
                            itemIDs = new FastIDSet();
                            knownItemIDs.put(userID, itemIDs);
                        }
                        itemIDs.add(itemID);
                    }
                }
                if (lines % 1000000 != 0) continue;
                log.info("Finished {} lines", (Object)lines);
            }
        }
        log.info("Pruning near-zero entries");
        InputFilesReader.removeSmall(rbyRow);
        InputFilesReader.removeSmall(rbyColumn);
    }

    private static void removeSmall(FastByIDMap<FastByIDFloatMap> matrix) {
        for (FastByIDMap.MapEntry<FastByIDFloatMap> entry : matrix.entrySet()) {
            Iterator<FastByIDFloatMap.MapEntry> it = entry.getValue().entrySet().iterator();
            while (it.hasNext()) {
                FastByIDFloatMap.MapEntry entry2 = it.next();
                if (!(FastMath.abs(entry2.getValue()) < ZERO_THRESHOLD)) continue;
                it.remove();
            }
        }
    }
}

