/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.util.TreeMap;
import java.util.Vector;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.BrowserNodeFactory;
import org.rosuda.JGR.browser.DataFrameNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.JGR.browser.EnvironmentNode;
import org.rosuda.JGR.browser.FactorNode;
import org.rosuda.JGR.browser.FunctionNode;
import org.rosuda.JGR.browser.LmNode;
import org.rosuda.JGR.browser.MatrixNode;
import org.rosuda.JGR.browser.NumericNode;

public class BrowserController {
    public static int MAX_CHILDREN = 1000;
    protected static boolean initialized = false;
    protected static TreeMap factories = new TreeMap();
    protected static BrowserNodeFactory defaultFactory = new DefaultBrowserNode();

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            BrowserController.setFactory("numeric", new NumericNode());
            BrowserController.setFactory("integer", new NumericNode());
            BrowserController.setFactory("factor", new FactorNode());
            BrowserController.setFactory("character", new FactorNode());
            BrowserController.setFactory("logical", new FactorNode());
            BrowserController.setFactory("data.frame", new DataFrameNode());
            BrowserController.setFactory("matrix", new MatrixNode());
            BrowserController.setFactory("environment", new EnvironmentNode());
            BrowserController.setFactory("function", new FunctionNode());
            BrowserController.setFactory("list", new DefaultBrowserNode());
            BrowserController.setFactory("lm", new LmNode());
            BrowserController.setFactory("glm", new LmNode());
        }
    }

    public static BrowserNode createNode(BrowserNode parent, String rName, String rClass) {
        BrowserController.initialize();
        BrowserNodeFactory fact = (BrowserNodeFactory)factories.get(rClass);
        if (fact == null) {
            return defaultFactory.generate(parent, rName, rClass);
        }
        return fact.generate(parent, rName, rClass);
    }

    public static void setFactory(String className, BrowserNodeFactory factory) {
        BrowserController.initialize();
        factories.put(className, factory);
    }

    public static Vector getClasses() {
        BrowserController.initialize();
        Vector res = new Vector();
        res.addAll(factories.keySet());
        return res;
    }

    public void setDefaultFactory(BrowserNodeFactory factory) {
        BrowserController.initialize();
        defaultFactory = factory;
    }
}

