/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class FactorSubsetPane
extends JPanel {
    private String dataset;
    private JComboBox factorComboBox;
    private JLabel factorLabel;
    private JList factorValueList;
    private JScrollPane factorValueScrollPane;

    public FactorSubsetPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.factorLabel = new JLabel();
        this.factorComboBox = new JComboBox();
        this.factorValueScrollPane = new JScrollPane();
        this.factorValueList = new JList();
        this.factorLabel.setText("Factor:");
        this.factorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FactorSubsetPane.this.factorComboBoxActionPerformed(evt);
            }
        });
        this.factorValueScrollPane.setViewportView(this.factorValueList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.factorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.factorValueScrollPane, -1, 175, Short.MAX_VALUE).addComponent(this.factorComboBox, 0, 175, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.factorLabel).addComponent(this.factorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.factorValueScrollPane, -1, 111, Short.MAX_VALUE)));
    }

    private void factorComboBoxActionPerformed(ActionEvent evt) {
        this.refreshFactorValueList();
    }

    public JComboBox getFactorComboBox() {
        return this.factorComboBox;
    }

    public void setFactorComboBox(JComboBox factorComboBox) {
        this.factorComboBox = factorComboBox;
    }

    public JLabel getFactorLabel() {
        return this.factorLabel;
    }

    public void setFactorLabel(JLabel factorLabel) {
        this.factorLabel = factorLabel;
    }

    public JList getFactorValueList() {
        return this.factorValueList;
    }

    public void setFactorValueList(JList factorValueList) {
        this.factorValueList = factorValueList;
    }

    public JScrollPane getFactorValueScrollPane() {
        return this.factorValueScrollPane;
    }

    public void setFactorValueScrollPane(JScrollPane factorValueScrollPane) {
        this.factorValueScrollPane = factorValueScrollPane;
    }

    public String getSelectedFactor() {
        return GUIUtils.getSelectedItem(this.getFactorComboBox());
    }

    public Object[] getSelectedFactorValues() {
        return GUIUtils.getSelectedValues(this.getFactorValueList());
    }

    public void refreshValidity() {
        this.factorLabel.setEnabled(this.factorComboBox.getItemCount() > 0);
        this.factorComboBox.setEnabled(this.factorComboBox.getItemCount() > 0);
        this.factorValueList.setEnabled(this.factorValueList.getModel().getSize() > 0);
    }

    public void refreshFactorComboBox() {
        if (this.getDataset() == null) {
            return;
        }
        Object selectedFactor = this.getFactorComboBox().getSelectedItem();
        Vector datasetFactors = null;
        try {
            datasetFactors = RUtils.factors(this.dataset);
        }
        catch (REngineException ex) {
            Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (datasetFactors != null) {
            this.factorComboBox.setModel(new DefaultComboBoxModel(datasetFactors));
            if (this.factorComboBox.getItemCount() > 0) {
                if (selectedFactor != null) {
                    this.factorComboBox.setSelectedItem(selectedFactor);
                } else {
                    this.factorComboBox.setSelectedIndex(0);
                }
            }
        } else {
            this.factorComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshFactorValueList() {
        if (this.getDataset() == null) {
            return;
        }
        if (this.factorComboBox.getItemCount() > 0 && this.factorComboBox.getSelectedIndex() != -1) {
            String column = this.getSelectedFactor();
            String cmd = "unique(" + this.getDataset() + "$" + column + ")";
            Vector uniqueValues = null;
            int[] selectedIndices = this.getFactorValueList().getSelectedIndices();
            try {
                uniqueValues = RUtils.evalAsVector(cmd);
                if (uniqueValues != null) {
                    this.factorValueList.setListData(uniqueValues);
                } else {
                    this.factorValueList.removeAll();
                }
                if (selectedIndices != null) {
                    this.factorValueList.setSelectedIndices(selectedIndices);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(FactorSubsetPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.factorValueList.setModel(new DefaultListModel());
        }
        this.refreshValidity();
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        String prevDataset = this.dataset;
        this.dataset = dataset;
        this.refreshFactorComboBox();
        this.refreshFactorValueList();
    }
}

