/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RegisterTargetsRequestMarshaller
implements Marshaller<Request<RegisterTargetsRequest>, RegisterTargetsRequest> {
    public Request<RegisterTargetsRequest> marshall(RegisterTargetsRequest registerTargetsRequest) {
        List<TargetDescription> targetsList;
        if (registerTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTargetsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RegisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerTargetsRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)registerTargetsRequest.getTargetGroupArn()));
        }
        if ((targetsList = registerTargetsRequest.getTargets()) != null) {
            if (targetsList.isEmpty()) {
                request.addParameter("Targets", "");
            } else {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue.getId() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString((String)targetsListValue.getId()));
                    }
                    if (targetsListValue.getPort() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger((Integer)targetsListValue.getPort()));
                    }
                    if (targetsListValue.getAvailabilityZone() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringUtils.fromString((String)targetsListValue.getAvailabilityZone()));
                    }
                    ++targetsListIndex;
                }
            }
        }
        return request;
    }
}

