/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.EnvironmentPlatform;
import java.util.List;

@SdkInternalApi
public class EnvironmentPlatformMarshaller {
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<List> LANGUAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languages").build();
    private static final EnvironmentPlatformMarshaller instance = new EnvironmentPlatformMarshaller();

    public static EnvironmentPlatformMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnvironmentPlatform environmentPlatform, ProtocolMarshaller protocolMarshaller) {
        if (environmentPlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)environmentPlatform.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(environmentPlatform.getLanguages(), LANGUAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

