/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.splitcriteria;

import com.github.javacliparser.FloatOption;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.ObjectRepository;
import moa.core.Utils;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class InfoGainSplitCriterion
extends AbstractOptionHandler
implements SplitCriterion {
    private static final long serialVersionUID = 1L;
    public FloatOption minBranchFracOption = new FloatOption("minBranchFrac", 'f', "Minimum fraction of weight required down at least two branches.", 0.01, 0.0, 0.5);

    @Override
    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        if (InfoGainSplitCriterion.numSubsetsGreaterThanFrac(postSplitDists, this.minBranchFracOption.getValue()) < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        return InfoGainSplitCriterion.computeEntropy(preSplitDist) - InfoGainSplitCriterion.computeEntropy(postSplitDists);
    }

    @Override
    public double getRangeOfMerit(double[] preSplitDist) {
        int numClasses = preSplitDist.length > 2 ? preSplitDist.length : 2;
        return Utils.log2(numClasses);
    }

    public static double computeEntropy(double[] dist) {
        double entropy = 0.0;
        double sum = 0.0;
        for (double d : dist) {
            if (!(d > 0.0)) continue;
            entropy -= d * Utils.log2(d);
            sum += d;
        }
        return sum > 0.0 ? (entropy + sum * Utils.log2(sum)) / sum : 0.0;
    }

    public static double computeEntropy(double[][] dists) {
        double totalWeight = 0.0;
        double[] distWeights = new double[dists.length];
        for (int i = 0; i < dists.length; ++i) {
            distWeights[i] = Utils.sum(dists[i]);
            totalWeight += distWeights[i];
        }
        double entropy = 0.0;
        for (int i = 0; i < dists.length; ++i) {
            entropy += distWeights[i] * InfoGainSplitCriterion.computeEntropy(dists[i]);
        }
        return entropy / totalWeight;
    }

    public static int numSubsetsGreaterThanFrac(double[][] distributions, double minFrac) {
        double totalWeight = 0.0;
        double[] distSums = new double[distributions.length];
        for (int i = 0; i < distSums.length; ++i) {
            for (int j = 0; j < distributions[i].length; ++j) {
                int n = i;
                distSums[n] = distSums[n] + distributions[i][j];
            }
            totalWeight += distSums[i];
        }
        int numGreater = 0;
        for (double d : distSums) {
            double frac = d / totalWeight;
            if (!(frac > minFrac)) continue;
            ++numGreater;
        }
        return numGreater;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

