/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import com.google.common.collect.MapMaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import loci.common.BZip2Handle;
import loci.common.GZipHandle;
import loci.common.IRandomAccess;
import loci.common.NIOFileHandle;
import loci.common.URLHandle;
import loci.common.ZipHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Location {
    private static final Logger LOGGER = LoggerFactory.getLogger(Location.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static ThreadLocal<HashMap<String, Object>> idMap = new ThreadLocal<HashMap<String, Object>>(){

        @Override
        protected HashMap<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static volatile boolean cacheListings = false;
    private static volatile long cacheNanos = 3600000000000L;
    private static final Map<String, ListingsResult> fileListings = new MapMaker().makeMap();
    private boolean isURL = true;
    private URL url;
    private File file;

    public Location(String pathname) {
        LOGGER.trace("Location({})", (Object)pathname);
        if (pathname.contains("://")) {
            try {
                this.url = new URL(Location.getMappedId(pathname));
            }
            catch (MalformedURLException e) {
                LOGGER.trace("Location is not a URL", (Throwable)e);
                this.isURL = false;
            }
        } else {
            LOGGER.trace("Location is not a URL");
            this.isURL = false;
        }
        if (!this.isURL) {
            this.file = new File(Location.getMappedId(pathname));
        }
    }

    public Location(File file) {
        LOGGER.trace("Location({})", (Object)file);
        this.isURL = false;
        this.file = file;
    }

    public Location(String parent, String child) {
        this(parent + File.separator + child);
    }

    public Location(Location parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public static void reset() {
        cacheListings = false;
        cacheNanos = 3600000000000L;
        fileListings.clear();
        Location.getIdMap().clear();
    }

    public static void cacheDirectoryListings(boolean cache) {
        cacheListings = cache;
    }

    public static void setCacheDirectoryTimeout(double sec) {
        cacheNanos = (long)(sec * 1000.0 * 1000.0 * 1000.0);
    }

    public static void clearDirectoryListingsCache() {
        fileListings.clear();
    }

    public static void cleanStaleCacheEntries() {
        long t = System.nanoTime() - cacheNanos;
        Iterator<ListingsResult> cacheValues = fileListings.values().iterator();
        while (cacheValues.hasNext()) {
            if (cacheValues.next().time >= t) continue;
            cacheValues.remove();
        }
    }

    public static void mapId(String id, String filename) {
        if (id == null) {
            return;
        }
        if (filename == null) {
            Location.getIdMap().remove(id);
        } else {
            Location.getIdMap().put(id, filename);
        }
        LOGGER.debug("Location.mapId: {} -> {}", (Object)id, (Object)filename);
    }

    public static void mapFile(String id, IRandomAccess ira) {
        if (id == null) {
            return;
        }
        if (ira == null) {
            Location.getIdMap().remove(id);
        } else {
            Location.getIdMap().put(id, ira);
        }
        LOGGER.debug("Location.mapFile: {} -> {}", (Object)id, (Object)ira);
    }

    public static String getMappedId(String id) {
        if (Location.getIdMap() == null) {
            return id;
        }
        String filename = null;
        if (id != null && Location.getIdMap().get(id) instanceof String) {
            filename = (String)Location.getIdMap().get(id);
        }
        return filename == null ? id : filename;
    }

    public static IRandomAccess getMappedFile(String id) {
        if (Location.getIdMap() == null) {
            return null;
        }
        IRandomAccess ira = null;
        if (id != null && Location.getIdMap().get(id) instanceof IRandomAccess) {
            ira = (IRandomAccess)Location.getIdMap().get(id);
        }
        return ira;
    }

    public static HashMap<String, Object> getIdMap() {
        return idMap.get();
    }

    public static void setIdMap(HashMap<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null");
        }
        idMap.set(map);
    }

    public static IRandomAccess getHandle(String id) throws IOException {
        return Location.getHandle(id, false);
    }

    public static IRandomAccess getHandle(String id, boolean writable) throws IOException {
        return Location.getHandle(id, writable, true);
    }

    public static IRandomAccess getHandle(String id, boolean writable, boolean allowArchiveHandles) throws IOException {
        return Location.getHandle(id, writable, allowArchiveHandles, 0);
    }

    public static IRandomAccess getHandle(String id, boolean writable, boolean allowArchiveHandles, int bufferSize) throws IOException {
        LOGGER.trace("getHandle(id = {}, writable = {})", (Object)id, (Object)writable);
        IRandomAccess handle = Location.getMappedFile(id);
        if (handle == null) {
            LOGGER.trace("no handle was mapped for this ID");
            String mapId = Location.getMappedId(id);
            handle = id.startsWith("http://") || id.startsWith("https://") ? new URLHandle(mapId) : (allowArchiveHandles && ZipHandle.isZipFile(mapId) ? new ZipHandle(mapId) : (allowArchiveHandles && GZipHandle.isGZipFile(mapId) ? new GZipHandle(mapId) : (allowArchiveHandles && BZip2Handle.isBZip2File(mapId) ? new BZip2Handle(mapId) : (bufferSize > 0 ? new NIOFileHandle(new File(mapId), writable ? "rw" : "r", bufferSize) : new NIOFileHandle(mapId, writable ? "rw" : "r")))));
        }
        LOGGER.trace("Location.getHandle: {} -> {}", (Object)id, (Object)handle);
        return handle;
    }

    public static void checkValidId(String id) throws IOException {
        if (Location.getMappedFile(id) != null) {
            return;
        }
        Location.getHandle(id).close();
    }

    public String[] list(boolean noHiddenFiles) {
        ArrayList<String> files;
        String[] result;
        String key;
        block15: {
            LOGGER.trace("list({})", (Object)noHiddenFiles);
            key = this.getAbsolutePath() + Boolean.toString(noHiddenFiles);
            result = null;
            if (cacheListings) {
                Location.cleanStaleCacheEntries();
                ListingsResult listingsResult = fileListings.get(key);
                if (listingsResult != null) {
                    return listingsResult.listing;
                }
            }
            files = new ArrayList<String>();
            if (this.isURL) {
                try {
                    String input;
                    URLConnection c = this.url.openConnection();
                    InputStream is = c.getInputStream();
                    boolean foundEnd = false;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    StringBuffer buffer = new StringBuffer();
                    while ((input = br.readLine()) != null) {
                        buffer.append(input);
                    }
                    br.close();
                    String s = buffer.toString();
                    while (!foundEnd) {
                        int ndx;
                        int idx;
                        if (s.toLowerCase().indexOf("</html>") != -1) {
                            foundEnd = true;
                        }
                        while (s.indexOf("a href") != -1 && (idx = s.indexOf("\"", ndx = s.indexOf("a href") + 8)) >= 0) {
                            Location check;
                            String f = s.substring(ndx, idx);
                            if (files.size() > 0 && f.startsWith("/")) {
                                return null;
                            }
                            s = s.substring(idx + 1);
                            if (f.startsWith("?") || !(check = new Location(this.getAbsolutePath(), f)).exists() || noHiddenFiles && check.isHidden()) continue;
                            files.add(check.getName());
                        }
                    }
                    is.close();
                    if (files.size() == 0) {
                        return null;
                    }
                    break block15;
                }
                catch (IOException e) {
                    LOGGER.trace("Could not retrieve directory listing", (Throwable)e);
                    return null;
                }
            }
            if (this.file == null) {
                return null;
            }
            String[] f = this.file.list();
            if (f == null) {
                return null;
            }
            String path = this.file.getAbsolutePath();
            for (String name : f) {
                if (noHiddenFiles && (name.startsWith(".") || new Location(path, name).isHidden())) continue;
                files.add(name);
            }
        }
        result = files.toArray(new String[files.size()]);
        if (cacheListings) {
            fileListings.put(key, new ListingsResult(result, System.nanoTime()));
        }
        LOGGER.trace("  returning {} files", (Object)files.size());
        return result;
    }

    public boolean canRead() {
        LOGGER.trace("canRead()");
        return this.isURL ? this.isDirectory() || this.isFile() || this.exists() : this.file.canRead();
    }

    public boolean canWrite() {
        LOGGER.trace("canWrite()");
        return this.isURL ? false : this.file.canWrite();
    }

    public boolean createNewFile() throws IOException {
        if (this.isURL) {
            throw new IOException("Unimplemented");
        }
        return this.file.createNewFile();
    }

    public boolean mkdirs() {
        if (this.file == null) {
            return false;
        }
        return this.file.mkdirs();
    }

    public boolean delete() {
        return this.isURL ? false : this.file.delete();
    }

    public void deleteOnExit() {
        if (!this.isURL) {
            this.file.deleteOnExit();
        }
    }

    public boolean equals(Object obj) {
        String absPath = this.getAbsolutePath();
        String thatPath = null;
        thatPath = obj instanceof Location ? ((Location)obj).getAbsolutePath() : obj.toString();
        return absPath.equals(thatPath);
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    public boolean exists() {
        LOGGER.trace("exists()");
        if (this.isURL) {
            try {
                this.url.getContent();
                return true;
            }
            catch (IOException e) {
                LOGGER.trace("Failed to retrieve content from URL", (Throwable)e);
                return false;
            }
        }
        if (this.file.exists()) {
            return true;
        }
        if (Location.getMappedFile(this.file.getPath()) != null) {
            return true;
        }
        String mappedId = Location.getMappedId(this.file.getPath());
        return mappedId != null && new File(mappedId).exists();
    }

    public Location getAbsoluteFile() {
        return new Location(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        LOGGER.trace("getAbsolutePath()");
        return this.isURL ? this.url.toExternalForm() : this.file.getAbsolutePath();
    }

    public Location getCanonicalFile() throws IOException {
        return this.isURL ? this.getAbsoluteFile() : new Location(this.file.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.isURL ? this.getAbsolutePath() : this.file.getCanonicalPath();
    }

    public String getName() {
        LOGGER.trace("getName()");
        if (this.isURL) {
            String name = this.url.getFile();
            name = name.substring(name.lastIndexOf("/") + 1);
            return name;
        }
        return this.file.getName();
    }

    public String getParent() {
        LOGGER.trace("getParent()");
        if (this.isURL) {
            String absPath = this.getAbsolutePath();
            absPath = absPath.substring(0, absPath.lastIndexOf("/"));
            return absPath;
        }
        return this.file.getParent();
    }

    public Location getParentFile() {
        return new Location(this.getParent());
    }

    public String getPath() {
        return this.isURL ? this.url.getHost() + this.url.getPath() : this.file.getPath();
    }

    public boolean isAbsolute() {
        LOGGER.trace("isAbsolute()");
        return this.isURL ? true : this.file.isAbsolute();
    }

    public boolean isDirectory() {
        LOGGER.trace("isDirectory()");
        if (this.isURL) {
            String[] list = this.list();
            return list != null;
        }
        return this.file.isDirectory();
    }

    public boolean isFile() {
        LOGGER.trace("isFile()");
        return this.isURL ? !this.isDirectory() && this.exists() : this.file.isFile();
    }

    public boolean isHidden() {
        LOGGER.trace("isHidden()");
        if (this.isURL) {
            return false;
        }
        boolean dotFile = this.file.getName().startsWith(".");
        if (IS_WINDOWS) {
            return dotFile || this.file.isHidden();
        }
        return dotFile;
    }

    public long lastModified() {
        LOGGER.trace("lastModified()");
        if (this.isURL) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                LOGGER.trace("Could not determine URL's last modification time", (Throwable)e);
                return 0L;
            }
        }
        return this.file.lastModified();
    }

    public long length() {
        LOGGER.trace("length()");
        if (this.isURL) {
            try {
                return this.url.openConnection().getContentLength();
            }
            catch (IOException e) {
                LOGGER.trace("Could not determine URL's content length", (Throwable)e);
                return 0L;
            }
        }
        return this.file.length();
    }

    public String[] list() {
        return this.list(false);
    }

    public Location[] listFiles() {
        String[] s = this.list();
        if (s == null) {
            return null;
        }
        Location[] f = new Location[s.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Location(this.getAbsolutePath(), s[i]);
            f[i] = f[i].getAbsoluteFile();
        }
        return f;
    }

    public URL toURL() throws MalformedURLException {
        return this.isURL ? this.url : this.file.toURI().toURL();
    }

    public String toString() {
        return this.isURL ? this.url.toString() : this.file.toString();
    }

    protected class ListingsResult {
        public final String[] listing;
        public final long time;

        ListingsResult(String[] listing, long time) {
            this.listing = listing;
            this.time = time;
        }
    }
}

