/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Properties;

public class JavaProperties
implements PlugIn {
    StringBuffer sb = new StringBuffer();

    public void run(String arg) {
        this.show("java.version");
        this.show("java.vendor");
        if (IJ.isMacintosh()) {
            this.show("mrj.version");
        }
        this.show("os.name");
        this.show("os.version");
        this.show("os.arch");
        this.show("file.separator");
        this.show("path.separator");
        String s = System.getProperty("line.separator");
        String str2 = "";
        char ch1 = s.charAt(0);
        String str1 = ch1 == '\r' ? "<cr>" : "<lf>";
        if (s.length() == 2) {
            char ch2 = s.charAt(1);
            str2 = ch2 == '\r' ? "<cr>" : "<lf>";
        }
        this.sb.append("  line.separator: " + str1 + str2 + "\n");
        Applet applet = IJ.getApplet();
        if (applet != null) {
            this.sb.append("\n");
            this.sb.append("  code base: " + applet.getCodeBase() + "\n");
            this.sb.append("  document base: " + applet.getDocumentBase() + "\n");
            this.sb.append("  sample images dir: " + Prefs.getImagesURL() + "\n");
            TextWindow tw = new TextWindow("Properties", new String(this.sb), 400, 400);
            return;
        }
        this.sb.append("\n");
        this.show("user.name");
        this.show("user.home");
        this.show("user.dir");
        this.show("user.country");
        this.show("file.encoding");
        this.show("java.home");
        this.show("java.compiler");
        this.show("java.class.path");
        this.show("java.ext.dirs");
        this.show("java.io.tmpdir");
        this.sb.append("\n");
        String userDir = System.getProperty("user.dir");
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        this.sb.append("  IJ.getVersion: " + IJ.getVersion() + "\n");
        this.sb.append("  IJ.getFullVersion: " + IJ.getFullVersion() + "\n");
        this.sb.append("  IJ.isJava2: " + IJ.isJava2() + "\n");
        this.sb.append("  IJ.isJava15: " + IJ.isJava15() + "\n");
        this.sb.append("  IJ.isJava16: " + IJ.isJava16() + "\n");
        this.sb.append("  IJ.isLinux: " + IJ.isLinux() + "\n");
        this.sb.append("  IJ.isMacintosh: " + IJ.isMacintosh() + "\n");
        this.sb.append("  IJ.isMacOSX: " + IJ.isMacOSX() + "\n");
        this.sb.append("  IJ.isWindows: " + IJ.isWindows() + "\n");
        this.sb.append("  IJ.is64Bit: " + IJ.is64Bit() + "\n");
        this.sb.append("\n");
        this.sb.append("  IJ.getDirectory(\"imagej\"): " + IJ.getDirectory("imagej") + "\n");
        this.sb.append("  IJ.getDirectory(\"home\"): " + IJ.getDirectory("home") + "\n");
        this.sb.append("  IJ.getDirectory(\"plugins\"): " + IJ.getDirectory("plugins") + "\n");
        this.sb.append("  IJ.getDirectory(\"macros\"): " + IJ.getDirectory("macros") + "\n");
        this.sb.append("  IJ.getDirectory(\"luts\"): " + IJ.getDirectory("luts") + "\n");
        this.sb.append("  IJ.getDirectory(\"current\"): " + IJ.getDirectory("current") + "\n");
        this.sb.append("  IJ.getDirectory(\"temp\"): " + IJ.getDirectory("temp") + "\n");
        this.sb.append("  IJ.getDirectory(\"default\"): " + IJ.getDirectory("default") + "\n");
        this.sb.append("  IJ.getDirectory(\"image\"): " + IJ.getDirectory("image") + "\n");
        this.sb.append("\n");
        this.sb.append("  Menus.getPlugInsPath: " + Menus.getPlugInsPath() + "\n");
        this.sb.append("  Menus.getMacrosPath: " + Menus.getMacrosPath() + "\n");
        this.sb.append("  Prefs.getImageJDir: " + Prefs.getImageJDir() + "\n");
        this.sb.append("  Prefs.getThreads: " + Prefs.getThreads() + this.cores());
        this.sb.append("  Prefs.open100Percent: " + Prefs.open100Percent + "\n");
        this.sb.append("  Prefs.blackBackground: " + Prefs.blackBackground + "\n");
        this.sb.append("  Prefs.useJFileChooser: " + Prefs.useJFileChooser + "\n");
        this.sb.append("  Prefs.weightedColor: " + Prefs.weightedColor + "\n");
        this.sb.append("  Prefs.blackCanvas: " + Prefs.blackCanvas + "\n");
        this.sb.append("  Prefs.pointAutoMeasure: " + Prefs.pointAutoMeasure + "\n");
        this.sb.append("  Prefs.pointAutoNextSlice: " + Prefs.pointAutoNextSlice + "\n");
        this.sb.append("  Prefs.requireControlKey: " + Prefs.requireControlKey + "\n");
        this.sb.append("  Prefs.useInvertingLut: " + Prefs.useInvertingLut + "\n");
        this.sb.append("  Prefs.antialiasedTools: " + Prefs.antialiasedTools + "\n");
        this.sb.append("  Prefs.useInvertingLut: " + Prefs.useInvertingLut + "\n");
        this.sb.append("  Prefs.intelByteOrder: " + Prefs.intelByteOrder + "\n");
        this.sb.append("  Prefs.doubleBuffer: " + Prefs.doubleBuffer + "\n");
        this.sb.append("  Prefs.noPointLabels: " + Prefs.noPointLabels + "\n");
        this.sb.append("  Prefs.disableUndo: " + Prefs.disableUndo + "\n");
        this.sb.append("  Prefs dir: " + Prefs.getPrefsDir() + "\n");
        this.sb.append("  Current dir: " + OpenDialog.getDefaultDirectory() + "\n");
        this.sb.append("  Sample images dir: " + Prefs.getImagesURL() + "\n");
        this.sb.append("  Memory in use: " + IJ.freeMemory() + "\n");
        Dimension d = IJ.getScreenSize();
        this.sb.append("  Screen size: " + d.width + "x" + d.height + "\n");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String b1 = this.toString(GUI.getMaxWindowBounds());
        String b2 = this.toString(ge.getMaximumWindowBounds());
        if (!b2.equals(b1)) {
            b1 = b1 + " (" + b2 + ")";
        }
        this.sb.append("  Max window bounds: " + b1 + "\n");
        this.listMonitors(ge, this.sb);
        System.gc();
        this.doFullDump();
        if (IJ.getInstance() == null) {
            IJ.log(new String(this.sb));
        } else {
            new TextWindow("Properties", new String(this.sb), 400, 500);
        }
    }

    private void listMonitors(GraphicsEnvironment ge, StringBuffer sb) {
        int max = 10;
        String[] str = new String[max];
        int n = 0;
        Rectangle bounds2 = null;
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle bounds = gc[i].getBounds();
                if (bounds == null || bounds.equals(bounds2) || n >= max) continue;
                str[n++] = this.toString(bounds);
                bounds2 = bounds;
            }
        }
        if (n > 1) {
            Rectangle ub = GUI.getUnionOfBounds();
            if (ub != null) {
                sb.append("  Union of bounds: " + this.toString(ub) + "\n");
            }
            for (int i = 0; i < n; ++i) {
                sb.append("  Monitor" + (i + 1) + ": " + str[i] + "\n");
            }
        }
    }

    private String toString(Rectangle r) {
        if (r == null) {
            return "";
        }
        String s = r.toString();
        return s.substring(19, s.length() - 1);
    }

    String cores() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores == 1) {
            return " (1 core)\n";
        }
        return " (" + cores + " cores)\n";
    }

    void show(String property) {
        String p = System.getProperty(property);
        if (p != null) {
            this.sb.append("  " + property + ": " + p + "\n");
        }
    }

    void doFullDump() {
        this.sb.append("\n");
        this.sb.append("All Java Properties\n");
        Properties props = System.getProperties();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.sb.append("  " + key + ": " + (String)props.get(key) + "\n");
        }
    }
}

