/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Correction;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Immersion;
import omero.model.Instrument;
import omero.model.Length;
import omero.model.Objective;
import omero.model.ObjectiveAnnotationLink;
import omero.model.ObjectiveAnnotationLinkI;
import omero.rtypes;
import omero.util.IceMapper;

public class ObjectiveI
extends Objective
implements ModelBased {
    public static final String MANUFACTURER = "ome.model.acquisition.Objective_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Objective_model";
    public static final String LOTNUMBER = "ome.model.acquisition.Objective_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.Objective_serialNumber";
    public static final String NOMINALMAGNIFICATION = "ome.model.acquisition.Objective_nominalMagnification";
    public static final String CALIBRATEDMAGNIFICATION = "ome.model.acquisition.Objective_calibratedMagnification";
    public static final String LENSNA = "ome.model.acquisition.Objective_lensNA";
    public static final String IMMERSION = "ome.model.acquisition.Objective_immersion";
    public static final String CORRECTION = "ome.model.acquisition.Objective_correction";
    public static final String WORKINGDISTANCE = "ome.model.acquisition.Objective_workingDistance";
    public static final String IRIS = "ome.model.acquisition.Objective_iris";
    public static final String INSTRUMENT = "ome.model.acquisition.Objective_instrument";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.Objective_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.Objective_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public ObjectiveI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ObjectiveI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ObjectiveI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadLotNumber();
        this.unloadSerialNumber();
        this.unloadNominalMagnification();
        this.unloadCalibratedMagnification();
        this.unloadLensNA();
        this.unloadImmersion();
        this.unloadCorrection();
        this.unloadWorkingDistance();
        this.unloadIris();
        this.unloadInstrument();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ObjectiveI copy = new ObjectiveI();
        copy.id = this.id;
        copy.version = this.version;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.lotNumber = this.lotNumber;
        copy.serialNumber = this.serialNumber;
        copy.nominalMagnification = this.nominalMagnification;
        copy.calibratedMagnification = this.calibratedMagnification;
        copy.lensNA = this.lensNA;
        copy.immersion = this.immersion == null ? null : (Immersion)this.immersion.proxy();
        copy.correction = this.correction == null ? null : (Correction)this.correction.proxy();
        copy.workingDistance = this.workingDistance == null ? null : this.workingDistance.copy();
        copy.iris = this.iris;
        Instrument instrument = copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<ObjectiveAnnotationLink>();
            for (ObjectiveAnnotationLink item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (ObjectiveAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ObjectiveI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLotNumber() {
        this.lotNumber = null;
    }

    @Override
    public RString getLotNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lotNumber;
    }

    @Override
    public void setLotNumber(RString lotNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lotNumber = lotNumber;
    }

    private void copyLotNumber(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.lotNumber = source.getLotNumber() == null ? null : rtypes.rstring(source.getLotNumber());
    }

    private void fillLotNumber(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setLotNumber((String)mapper.fromRType(this.getLotNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSerialNumber() {
        this.serialNumber = null;
    }

    @Override
    public RString getSerialNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.serialNumber;
    }

    @Override
    public void setSerialNumber(RString serialNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.serialNumber = serialNumber;
    }

    private void copySerialNumber(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.serialNumber = source.getSerialNumber() == null ? null : rtypes.rstring(source.getSerialNumber());
    }

    private void fillSerialNumber(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setSerialNumber((String)mapper.fromRType(this.getSerialNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadNominalMagnification() {
        this.nominalMagnification = null;
    }

    @Override
    public RDouble getNominalMagnification(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.nominalMagnification;
    }

    @Override
    public void setNominalMagnification(RDouble nominalMagnification, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.nominalMagnification = nominalMagnification;
    }

    private void copyNominalMagnification(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.nominalMagnification = source.getNominalMagnification() == null ? null : rtypes.rdouble(source.getNominalMagnification());
    }

    private void fillNominalMagnification(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setNominalMagnification((Double)mapper.fromRType(this.getNominalMagnification()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadCalibratedMagnification() {
        this.calibratedMagnification = null;
    }

    @Override
    public RDouble getCalibratedMagnification(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.calibratedMagnification;
    }

    @Override
    public void setCalibratedMagnification(RDouble calibratedMagnification, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.calibratedMagnification = calibratedMagnification;
    }

    private void copyCalibratedMagnification(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.calibratedMagnification = source.getCalibratedMagnification() == null ? null : rtypes.rdouble(source.getCalibratedMagnification());
    }

    private void fillCalibratedMagnification(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setCalibratedMagnification((Double)mapper.fromRType(this.getCalibratedMagnification()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLensNA() {
        this.lensNA = null;
    }

    @Override
    public RDouble getLensNA(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lensNA;
    }

    @Override
    public void setLensNA(RDouble lensNA, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lensNA = lensNA;
    }

    private void copyLensNA(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.lensNA = source.getLensNA() == null ? null : rtypes.rdouble(source.getLensNA());
    }

    private void fillLensNA(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setLensNA((Double)mapper.fromRType(this.getLensNA()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadImmersion() {
        this.immersion = null;
    }

    @Override
    public Immersion getImmersion(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.immersion;
    }

    @Override
    public void setImmersion(Immersion immersion, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.immersion = immersion;
    }

    private void copyImmersion(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.immersion = (Immersion)mapper.findTarget(source.getImmersion());
    }

    private void fillImmersion(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(IMMERSION, (Object)mapper.reverse((ModelBased)this.getImmersion()));
    }

    public void unloadCorrection() {
        this.correction = null;
    }

    @Override
    public Correction getCorrection(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.correction;
    }

    @Override
    public void setCorrection(Correction correction, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.correction = correction;
    }

    private void copyCorrection(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.correction = (Correction)mapper.findTarget(source.getCorrection());
    }

    private void fillCorrection(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(CORRECTION, (Object)mapper.reverse((ModelBased)this.getCorrection()));
    }

    public void unloadWorkingDistance() {
        this.workingDistance = null;
    }

    @Override
    public Length getWorkingDistance(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.workingDistance;
    }

    @Override
    public void setWorkingDistance(Length workingDistance, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.workingDistance = workingDistance;
    }

    private void copyWorkingDistance(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.workingDistance = (Length)mapper.findTarget(source.getWorkingDistance());
    }

    private void fillWorkingDistance(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(WORKINGDISTANCE, (Object)mapper.reverse((ModelBased)this.getWorkingDistance()));
    }

    public void unloadIris() {
        this.iris = null;
    }

    @Override
    public RBool getIris(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.iris;
    }

    @Override
    public void setIris(RBool iris, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.iris = iris;
    }

    private void copyIris(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.iris = source.getIris() == null ? null : rtypes.rbool(source.getIris());
    }

    private void fillIris(ome.model.acquisition.Objective target, IceMapper mapper) {
        try {
            target.setIris((Boolean)mapper.fromRType(this.getIris()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Objective target, IceMapper mapper) {
        target.putAt(INSTRUMENT, (Object)mapper.reverse((ModelBased)this.getInstrument()));
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.acquisition.Objective source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.acquisition.Objective target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addObjectiveAnnotationLink(ObjectiveAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllObjectiveAnnotationLinkSet(List<ObjectiveAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (ObjectiveAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeObjectiveAnnotationLink(ObjectiveAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllObjectiveAnnotationLinkSet(List<ObjectiveAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ObjectiveAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ObjectiveAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Objective toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ObjectiveAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (ObjectiveAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<ObjectiveAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public ObjectiveAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ObjectiveAnnotationLinkI link = new ObjectiveAnnotationLinkI();
        link.link(this, addition);
        this.addObjectiveAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addObjectiveAnnotationLinkToBoth(ObjectiveAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<ObjectiveAnnotationLink> findObjectiveAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<ObjectiveAnnotationLink> result = new ArrayList<ObjectiveAnnotationLink>();
        for (ObjectiveAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<ObjectiveAnnotationLink> toRemove = this.findObjectiveAnnotationLink(removal);
        Iterator<ObjectiveAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeObjectiveAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeObjectiveAnnotationLinkFromBoth(ObjectiveAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (ObjectiveAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Objective) {
            ome.model.acquisition.Objective source = (ome.model.acquisition.Objective)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copyLotNumber(source, mapper);
                this.copySerialNumber(source, mapper);
                this.copyNominalMagnification(source, mapper);
                this.copyCalibratedMagnification(source, mapper);
                this.copyLensNA(source, mapper);
                this.copyImmersion(source, mapper);
                this.copyCorrection(source, mapper);
                this.copyWorkingDistance(source, mapper);
                this.copyIris(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Objective cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Objective target = new ome.model.acquisition.Objective();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillLotNumber(target, mapper);
            this.fillSerialNumber(target, mapper);
            this.fillNominalMagnification(target, mapper);
            this.fillCalibratedMagnification(target, mapper);
            this.fillLensNA(target, mapper);
            this.fillImmersion(target, mapper);
            this.fillCorrection(target, mapper);
            this.fillWorkingDistance(target, mapper);
            this.fillIris(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ObjectiveI> cast(List list) {
        return list;
    }
}

