/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.awt.Color;
import java.awt.image.BufferedImage;
import omero.RDouble;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.gateway.model.ShapeSettingsData;
import omero.model.Mask;
import omero.model.MaskI;
import omero.model.Shape;
import omero.rtypes;

public class MaskData
extends ShapeData {
    public MaskData(Shape shape) {
        super(shape);
    }

    public MaskData() {
        this(0.0, 0.0, 0.0, 0.0, null);
    }

    public MaskData(double x, double y, double width, double height, byte[] mask) {
        super(new MaskI(), true);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.setMask(mask);
    }

    public String getText() {
        Mask shape = (Mask)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Mask shape = (Mask)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring(text));
        this.setDirty(true);
    }

    public double getX() {
        Mask shape = (Mask)this.asIObject();
        RDouble value = shape.getX();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setX(double x) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Mask shape = (Mask)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setX(rtypes.rdouble(x));
        this.setDirty(true);
    }

    public double getY() {
        Mask shape = (Mask)this.asIObject();
        RDouble value = shape.getY();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setY(double y) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Mask shape = (Mask)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setY(rtypes.rdouble(y));
        this.setDirty(true);
    }

    public double getWidth() {
        Mask shape = (Mask)this.asIObject();
        RDouble value = shape.getWidth();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setWidth(double width) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Mask shape = (Mask)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setWidth(rtypes.rdouble(width));
        this.setDirty(true);
    }

    public double getHeight() {
        Mask shape = (Mask)this.asIObject();
        RDouble value = shape.getHeight();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setHeight(double height) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Mask shape = (Mask)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setHeight(rtypes.rdouble(height));
        this.setDirty(true);
    }

    public void setMask(byte[] mask) {
        Mask shape = (Mask)this.asIObject();
        shape.setBytes(mask);
        this.setDirty(true);
    }

    public void setMask(BufferedImage image) {
        byte[] data = new byte[(int)(this.getWidth() * this.getHeight())];
        boolean colourSet = false;
        ShapeSettingsData settings = this.getShapeSettings();
        int y = 0;
        while ((double)y < this.getHeight()) {
            int x = 0;
            while ((double)x < this.getWidth()) {
                if (image.getRGB(x, y) == 0) {
                    this.setBit(data, (int)((double)y * this.getWidth() + (double)x), 0);
                } else {
                    if (!colourSet) {
                        settings.setFill(new Color(image.getRGB(x, y), true));
                        colourSet = true;
                    }
                    this.setBit(data, (int)((double)y * this.getWidth() + (double)x), 1);
                }
                ++x;
            }
            ++y;
        }
        this.setDirty(true);
    }

    public BufferedImage getMaskAsBufferedImage() {
        Mask shape = (Mask)this.asIObject();
        byte[] data = shape.getBytes();
        if (data == null) {
            return null;
        }
        double width = this.getWidth();
        if (width == 0.0) {
            return null;
        }
        double height = this.getHeight();
        if (height == 0.0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage((int)width, (int)height, 2);
        int offset = 0;
        int colourValue = this.getShapeSettings().getFill().getRGB();
        for (int y = 0; y < (int)height; ++y) {
            for (int x = 0; x < (int)width; ++x) {
                byte bit = this.getBit(data, offset);
                if (bit == 1) {
                    bufferedImage.setRGB(x, y, colourValue);
                } else {
                    bufferedImage.setRGB(x, y, 0);
                }
                ++offset;
            }
        }
        return bufferedImage;
    }

    public int[][] getMaskAsBinaryArray() {
        Mask shape = (Mask)this.asIObject();
        byte[] data = shape.getBytes();
        if (data == null) {
            return null;
        }
        double width = this.getWidth();
        if (width == 0.0) {
            return null;
        }
        double height = this.getHeight();
        if (height == 0.0) {
            return null;
        }
        int[][] returnArray = new int[(int)width][(int)height];
        int offset = 0;
        for (int y = (int)height - 1; y > 0; --y) {
            for (int x = 0; x < (int)width; ++x) {
                returnArray[x][y] = this.getBit(data, offset);
                ++offset;
            }
        }
        return returnArray;
    }

    public byte[] getMask() {
        Mask shape = (Mask)this.asIObject();
        byte[] data = shape.getBytes();
        return data;
    }

    public void setBit(byte[] data, int bit, int val) {
        int bytePosition = bit / 8;
        int bitPosition = 7 - bit % 8;
        data[bytePosition] = (byte)((byte)(data[bytePosition] & ~((byte)(1 << bitPosition))) | (byte)(val << bitPosition));
        this.setDirty(true);
    }

    public byte getBit(byte[] data, int bit) {
        int bytePosition = bit / 8;
        int bitPosition = 7 - bit % 8;
        return (byte)(data[bytePosition] & 1 << bitPosition) != 0 ? (byte)1 : 0;
    }
}

