/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSliderModel;

class TwoKnobsSliderUI {
    static final int EXTRA = 3;
    static final int BUFFER = 1;
    private static final Color TRACK_COLOR = Color.LIGHT_GRAY;
    private static final Dimension DEFAULT_THUMB_SIZE = new Dimension(16, 16);
    private TwoKnobsSlider component;
    private TwoKnobsSliderModel model;
    private Rectangle trackRect;
    private Rectangle tickRect;
    private Rectangle labelRect;
    private Rectangle startLabelRect;
    private Rectangle endLabelRect;
    private Color shadowColor;
    private Color fontColor;
    private Image thumbImage;
    private Image upArrowImage;
    private Image disabledUpArrowImage;
    private Image disabledThumbImage;
    private Image thumbImageDarker;
    private Image disabledThumbImageDarker;

    private void initialize() {
        this.trackRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.startLabelRect = new Rectangle();
        this.endLabelRect = new Rectangle();
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.fontColor = UIUtilities.LINE_COLOR;
    }

    private void createThumbImage() {
        IconManager icons = IconManager.getInstance();
        ImageIcon icon = icons.getImageIcon(6);
        this.thumbImage = icon.getImage();
        icon = icons.getImageIcon(7);
        this.disabledThumbImage = icon.getImage();
        icon = icons.getImageIcon(8);
        this.upArrowImage = icon.getImage();
        icon = icons.getImageIcon(12);
        this.disabledUpArrowImage = icon.getImage();
    }

    private void paintTicks(Graphics2D g) {
        double value;
        g.setColor(this.shadowColor);
        g.translate(0, this.tickRect.y);
        int xPos = 0;
        double minor = this.model.getMinorTickSpacing();
        double major = this.model.getMajorTickSpacing();
        double max = this.model.getMaximum();
        double min = this.model.getMinimum();
        if (this.model.getOrientation() == 100) {
            if (minor > 0.0) {
                for (value = this.model.getMinimum(); value <= max; value += minor) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, this.tickRect, xPos);
                }
            }
            if (major > 0.0) {
                for (value = min; value <= max; value += major) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, this.tickRect, xPos);
                }
            }
            g.translate(0, -this.tickRect.y);
        } else {
            g.translate(this.tickRect.x, 0);
            int yPos = 0;
            if (minor > 0.0) {
                for (value = min; value <= max; value += minor) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, this.tickRect, yPos);
                }
            }
            if (major > 0.0) {
                for (value = min; value <= max; value += major) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, this.tickRect, yPos);
                }
            }
            g.translate(-this.tickRect.x, 0);
        }
    }

    private void paintLabels(Graphics2D g, FontMetrics fontMetrics) {
        g.setColor(this.fontColor);
        Map<Double, String> labels = this.model.getLabels();
        for (Double key : labels.keySet()) {
            int value = key.intValue();
            if (this.model.getOrientation() == 100) {
                g.translate(0, this.labelRect.y);
                this.paintHorizontalLabel(g, fontMetrics, value);
                g.translate(0, -this.labelRect.y);
                continue;
            }
            g.translate(this.labelRect.x, 0);
            this.paintVerticalLabel(g, fontMetrics, value);
            g.translate(-this.labelRect.x, 0);
        }
    }

    private void paintCurrentValues(Graphics2D g, FontMetrics fontMetrics) {
        g.setColor(this.fontColor);
        String s = "" + this.model.getStartValue();
        g.drawString(s, this.startLabelRect.x, fontMetrics.getHeight());
        s = "" + this.model.getEndValue();
        g.drawString(s, this.startLabelRect.y, fontMetrics.getHeight());
    }

    private void paintHorizontalLabel(Graphics2D g, FontMetrics fontMetrics, int value) {
        String s = "" + value;
        int labelLeft = this.xPositionForValue(value) - fontMetrics.stringWidth(s) / 2;
        g.translate(labelLeft, 0);
        g.drawString(s, 0, fontMetrics.getHeight());
        g.translate(-labelLeft, 0);
    }

    private void paintVerticalLabel(Graphics2D g, FontMetrics fontMetrics, int value) {
        int v = fontMetrics.getHeight() / 2 + fontMetrics.getHeight() / 2 % 2;
        int labelTop = this.yPositionForValue(value) - v;
        g.translate(0, labelTop);
        g.drawString("" + value, 0, fontMetrics.getHeight());
        g.translate(0, -labelTop);
    }

    private void paintMinorTickForHorizSlider(Graphics2D g, Rectangle bounds, int x) {
        g.drawLine(x, 0, x, bounds.height / 2 - 1);
    }

    private void paintMajorTickForHorizSlider(Graphics2D g, Rectangle bounds, int x) {
        g.drawLine(x, 0, x, bounds.height - 2);
    }

    private void paintMinorTickForVertSlider(Graphics2D g, Rectangle bounds, int y) {
        g.drawLine(0, y, bounds.width / 2 - 1, y);
    }

    private void paintMajorTickForVertSlider(Graphics2D g, Rectangle bounds, int y) {
        g.drawLine(0, y, bounds.width - 2, y);
    }

    private void paintTrackAndKnobsForHorizSlider(Graphics2D g2D) {
        Image img;
        int l = this.xPositionForValue(this.model.getStartValue());
        int r = this.xPositionForValue(this.model.getEndValue());
        int w = this.component.getKnobWidth();
        int h = this.component.getKnobHeight();
        if (this.component.getImage() != null) {
            if (this.component.isSqueezeBackground()) {
                g2D.drawImage(this.component.getImage(), l, this.trackRect.y, r - l, this.trackRect.height - 9, null);
            } else {
                g2D.drawImage(this.component.getImage(), this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height - 9, null);
            }
            g2D.drawRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height - 8);
        } else if (!this.component.getColourGradient()) {
            GradientPaint paint = new GradientPaint(0.0f, this.trackRect.y, UIUtilities.TRACK_GRADIENT_START, 0.0f, this.trackRect.y + this.trackRect.height - 10, UIUtilities.TRACK_GRADIENT_END, false);
            g2D.setPaint(paint);
            g2D.fillRoundRect(l, this.trackRect.y + 3, r - l, this.trackRect.height - 12, this.trackRect.height / 3, this.trackRect.height / 3);
            g2D.setColor(TRACK_COLOR);
            g2D.drawRoundRect(this.trackRect.x, this.trackRect.y + 2, this.trackRect.width, this.trackRect.height - 11, this.trackRect.height / 3, this.trackRect.height / 3);
        } else {
            Color[] colors = this.component.getGradientColors();
            GradientPaint paint = new GradientPaint(l, this.trackRect.y - 2, colors[0], r, this.trackRect.height + 2, colors[1], false);
            g2D.setPaint(paint);
            g2D.fillRoundRect(l, this.trackRect.y + 2, r - l, this.trackRect.height - 10, this.trackRect.height / 3, this.trackRect.height / 3);
            g2D.setColor(Color.black);
            g2D.drawRoundRect(this.trackRect.x, this.trackRect.y + 2, this.trackRect.width, this.trackRect.height - 9, this.trackRect.height / 3, this.trackRect.height / 3);
        }
        int offset = 0;
        if (!this.component.getColourGradient()) {
            img = this.model.isEnabled() ? this.thumbImage : this.disabledThumbImage;
        } else {
            w = 12;
            h = 12;
            img = this.model.isEnabled() ? this.upArrowImage : this.disabledUpArrowImage;
            offset = 5;
        }
        if (this.component.getKnobControl() == 1) {
            if (this.model.allowOverlap() && !this.component.getColourGradient()) {
                img = this.thumbImageDarker;
                if (!this.model.isEnabled()) {
                    img = this.disabledThumbImageDarker;
                }
            }
            g2D.drawImage(img, r - w / 2, 1 + offset, w, h, null);
            if (!this.component.getColourGradient()) {
                img = this.model.isEnabled() ? this.thumbImage : this.disabledThumbImage;
            }
            g2D.drawImage(img, l - w / 2, 1 + offset, w, h, null);
        } else {
            g2D.drawImage(img, l - w / 2, 1 + offset, w, h, null);
            if (this.model.allowOverlap() && !this.component.getColourGradient()) {
                img = this.thumbImageDarker;
                if (!this.model.isEnabled()) {
                    img = this.disabledThumbImageDarker;
                }
            }
            g2D.drawImage(img, r - w / 2, 1 + offset, w, h, null);
        }
    }

    private void paintTrackAndKnobsForVertSlider(Graphics2D g2D) {
        Image img;
        int down = this.yPositionForValue(this.model.getStartValue());
        int up = this.yPositionForValue(this.model.getEndValue());
        int w = this.component.getKnobWidth();
        int h = this.component.getKnobHeight();
        int x = this.trackRect.x - w / 2 + (this.trackRect.width - w) / 2;
        if (!this.component.getColourGradient()) {
            GradientPaint paint = new GradientPaint(this.trackRect.x + 1, this.trackRect.y + h / 2, UIUtilities.TRACK_GRADIENT_START, this.trackRect.x + 1 + this.trackRect.width - w - 2, this.trackRect.y + h / 2, UIUtilities.TRACK_GRADIENT_END, false);
            g2D.setPaint(paint);
            g2D.fillRoundRect(this.trackRect.x + 1, this.trackRect.y + h / 2, this.trackRect.width - w - 2, this.trackRect.height, this.trackRect.width / 3, this.trackRect.width / 3);
        } else {
            Color[] colors = this.component.getGradientColors();
            GradientPaint paint = new GradientPaint(this.trackRect.x + 1, this.trackRect.y + h / 2, colors[0], this.trackRect.x + 1 + this.trackRect.width - w - 2, this.trackRect.y + h / 2, colors[1], false);
            g2D.setPaint(paint);
            g2D.fillRoundRect(this.trackRect.x, this.trackRect.y + 3, this.trackRect.width, this.trackRect.height - 12, this.trackRect.height / 3, this.trackRect.height / 3);
        }
        if (!this.component.getColourGradient()) {
            img = this.model.isEnabled() ? this.thumbImage : this.disabledThumbImage;
        } else {
            w = 10;
            h = 10;
            img = this.model.isEnabled() ? this.upArrowImage : this.disabledUpArrowImage;
        }
        if (this.component.getKnobControl() == 1) {
            if (this.model.allowOverlap() && !this.component.getColourGradient()) {
                img = this.thumbImageDarker;
                if (!this.model.isEnabled()) {
                    img = this.disabledThumbImageDarker;
                }
            }
            g2D.drawImage(img, x, down, w, h, null);
            if (!this.component.getColourGradient()) {
                img = this.model.isEnabled() ? this.thumbImage : this.disabledThumbImage;
            }
            g2D.drawImage(img, x, up, w, h, null);
        } else {
            g2D.drawImage(img, x, up, w, h, null);
            if (this.model.allowOverlap() && !this.component.getColourGradient()) {
                img = this.thumbImageDarker;
                if (!this.model.isEnabled()) {
                    img = this.disabledThumbImageDarker;
                }
            }
            g2D.drawImage(img, x, down, w, h, null);
        }
    }

    private void computeRectangles(FontMetrics fontMetrics, Dimension size) {
        int w = this.component.getKnobWidth();
        int h = this.component.getKnobHeight();
        int fontWidth = fontMetrics.stringWidth(this.model.render(this.model.getAbsoluteMaximum()));
        int x = 0;
        if (this.model.getOrientation() == 100) {
            int v;
            x = fontWidth / 2;
            if (this.model.isPaintCurrentValues()) {
                v = fontMetrics.stringWidth(this.model.render(this.model.getAbsoluteMinimum()));
                x += (v /= 2);
            }
            if (this.model.isPaintEndLabels()) {
                this.trackRect.setBounds(x, 3, size.width - 2 * x, h);
            } else {
                this.trackRect.setBounds(w / 2, 3, size.width - w, h);
            }
            if (this.model.isPaintCurrentValues()) {
                v = fontMetrics.stringWidth(this.model.render(this.model.getAbsoluteMinimum()));
                x += (v /= 2);
                this.startLabelRect.setBounds(0, this.trackRect.y, v, this.trackRect.y);
                v = fontWidth / 2;
                x += v;
                this.endLabelRect.setBounds(this.trackRect.x + this.trackRect.width, this.trackRect.y, v, this.trackRect.y);
            }
            if (this.model.isPaintTicks()) {
                this.tickRect = new Rectangle(this.trackRect.x, this.trackRect.y + this.trackRect.height, this.trackRect.width, this.trackRect.height);
            }
            this.labelRect = new Rectangle(this.tickRect.x, this.trackRect.y + this.trackRect.height + this.tickRect.height, this.trackRect.width, fontMetrics.getHeight() + 2);
        } else {
            int y = fontMetrics.getHeight() / 2 + h;
            if (this.model.isPaintEndLabels()) {
                this.trackRect.setBounds(w / 2, y, w + 6, size.height - 2 * y);
            } else {
                this.trackRect.setBounds(w / 2, 0, w + 6, size.height - h);
            }
            if (this.model.isPaintTicks()) {
                this.tickRect = new Rectangle(this.trackRect.x + this.trackRect.width, this.trackRect.y - h, this.trackRect.width, this.trackRect.height);
            }
            this.labelRect = new Rectangle(this.trackRect.x + this.trackRect.width + this.tickRect.width, this.trackRect.y, fontWidth + 2, this.trackRect.height);
        }
    }

    TwoKnobsSliderUI(TwoKnobsSlider component, TwoKnobsSliderModel model) {
        if (component == null) {
            throw new NullPointerException("No component");
        }
        if (model == null) {
            throw new NullPointerException("No model");
        }
        this.component = component;
        this.model = model;
        this.initialize();
        this.createThumbImage();
    }

    void createDarkerImage() {
        if (!this.model.allowOverlap()) {
            return;
        }
        this.thumbImageDarker = Factory.makeConstrastDecImage(this.thumbImage);
        this.disabledThumbImageDarker = Factory.makeConstrastDecImage(this.disabledThumbImage);
    }

    int getKnobWidth() {
        if (this.thumbImage == null) {
            return TwoKnobsSliderUI.DEFAULT_THUMB_SIZE.width;
        }
        return this.thumbImage.getWidth(null);
    }

    int getKnobHeight() {
        if (this.thumbImage == null) {
            return TwoKnobsSliderUI.DEFAULT_THUMB_SIZE.height;
        }
        return this.thumbImage.getHeight(null);
    }

    void setFontColor(Color c) {
        if (c == null) {
            return;
        }
        this.fontColor = c;
    }

    int xPositionForValue(double value) {
        double min = this.model.getPartialMinimum();
        double max = this.model.getPartialMaximum();
        int trackLength = this.trackRect.width;
        double valueRange = max - min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + this.trackRect.width - 1;
        int xPosition = trackLeft;
        xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * (value - min)));
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    int yPositionForValue(double value) {
        double min = this.model.getPartialMinimum();
        double max = this.model.getPartialMaximum();
        int trackLength = this.trackRect.height;
        double valueRange = max - min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + this.trackRect.height - 1;
        int yPosition = trackTop;
        yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * (max - value)));
        yPosition = Math.max(trackTop, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    double xValueForPosition(int xPosition, boolean start) {
        double value;
        double minValue = this.model.getPartialMinimum();
        double maxValue = this.model.getPartialMaximum();
        int trackLength = this.trackRect.width;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + this.trackRect.width - 1;
        if (xPosition <= trackLeft) {
            value = minValue;
        } else if (xPosition >= trackRight) {
            value = maxValue;
        } else {
            int distanceFromTrackLeft = trackRight - xPosition;
            if (start) {
                distanceFromTrackLeft = xPosition - trackLeft;
            }
            double valueRange = maxValue - minValue;
            double valuePerPixel = Math.ceil(valueRange / (double)trackLength * 1000.0) / 1000.0;
            double valueFromTrackLeft = Math.ceil((double)distanceFromTrackLeft * valuePerPixel * 1000.0) / 1000.0;
            value = start ? minValue + valueFromTrackLeft : maxValue - valueFromTrackLeft;
        }
        return value;
    }

    double yValueForPosition(int yPosition, boolean start) {
        double value;
        double minValue = this.model.getPartialMinimum();
        double maxValue = this.model.getPartialMaximum();
        int trackLength = this.trackRect.height;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + this.trackRect.height - 1;
        if (yPosition <= trackTop) {
            value = maxValue;
        } else if (yPosition >= trackBottom) {
            value = minValue;
        } else {
            int distanceFromTrackTop = trackBottom - yPosition;
            if (start) {
                distanceFromTrackTop = yPosition - trackTop;
            }
            double valueRange = maxValue - minValue;
            double valuePerPixel = Math.ceil(valueRange / (double)trackLength * 1000.0) / 1000.0;
            double valueFromTrackTop = Math.ceil((double)distanceFromTrackTop * valuePerPixel * 1000.0) / 1000.0;
            value = !start ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
        }
        return value;
    }

    void paintComponent(Graphics2D g2D, Dimension size) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        this.computeRectangles(fontMetrics, size);
        g2D.setColor(TRACK_COLOR);
        if (this.model.getOrientation() == 100) {
            this.paintTrackAndKnobsForHorizSlider(g2D);
        } else {
            this.paintTrackAndKnobsForVertSlider(g2D);
        }
        if (this.model.isPaintTicks()) {
            this.paintTicks(g2D);
        }
        if (this.model.isPaintLabels() || this.model.isPaintEndLabels()) {
            this.paintLabels(g2D, fontMetrics);
        }
    }
}

