/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.ui.omeeditpane.FormatSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEEditorKit;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.SelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

class OMEEditPane
extends JEditorPane
implements ActionListener,
FocusListener {
    private static final int DELAY = 400;
    private static String DOC_TYPE = "text/wiki";
    private final OMEEditorKit editorKit;
    private final OMEWikiComponent component;
    private Timer timer;
    private int count;
    private Point location;

    private void handleMousePressed() {
        if (this.timer == null) {
            this.timer = new Timer(400, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    private void onUpdate() {
        this.component.onUpdate();
    }

    OMEEditPane(OMEWikiComponent component, Map<String, FormatSelectionAction> formatters) {
        this.component = component;
        this.editorKit = new OMEEditorKit(formatters);
        this.setEditorKitForContentType(DOC_TYPE, this.editorKit);
        this.setContentType(DOC_TYPE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OMEEditPane.this.handleMousePressed();
                OMEEditPane.this.count++;
                OMEEditPane.this.location = e.getPoint();
            }
        });
        this.addFocusListener(this);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                OMEEditPane.this.onUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OMEEditPane.this.onUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    void addFormatter(String value, FormatSelectionAction action) {
        this.editorKit.addFormatter(value, action);
    }

    @Override
    public void focusGained(FocusEvent e) {
        String text = this.getText();
        if (text != null) {
            if (this.component.getDefaultText().equals(text)) {
                this.selectAll();
            } else {
                this.setText(text);
                int n = this.getDocument().getLength();
                if (n >= 0) {
                    this.setCaretPosition(n);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.select(0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.count == 1 || this.count == 2) {
            int index = this.viewToModel(this.location);
            WikiView view = this.editorKit.getView();
            SelectionAction action = view.getSelectionAction(index);
            this.component.onSelection(action, view.getSelectedText(index), this.count);
            this.timer.stop();
            this.count = 0;
        }
    }
}

