/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import sun.awt.shell.ShellFolder;

public class GenericFileChooser
extends JFileChooser {
    private JComboBox box;
    private ActionListener listener;

    private void handleFileSelection(File f) {
        if (this.box == null || f == null) {
            return;
        }
        if (f instanceof ShellFolder && ((ShellFolder)f).isLink() || f.getName().endsWith(".lnk")) {
            JOptionPane.showMessageDialog(null, "Cannot use shortcut from selection box.");
            this.box.setSelectedItem(f.getParentFile());
        }
    }

    private void initialize() {
        this.box = (JComboBox)UIUtilities.findComponent(this, JComboBox.class);
        if (this.box != null) {
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object selected;
                    JComboBox b = (JComboBox)e.getSource();
                    if (b == GenericFileChooser.this.box && (selected = b.getSelectedItem()) != null && selected instanceof File) {
                        GenericFileChooser.this.handleFileSelection((File)selected);
                    }
                }
            };
            this.box.addActionListener(this.listener);
        }
    }

    public GenericFileChooser() {
        this.initialize();
    }

    @Override
    public void setCurrentDirectory(File directory) {
        try {
            if (this.box != null) {
                this.box.removeActionListener(this.listener);
            }
            super.setCurrentDirectory(directory);
            if (this.box != null) {
                this.box.addActionListener(this.listener);
            }
        }
        catch (Exception e) {
            this.setCurrentDirectory(directory.getParentFile());
        }
    }
}

