/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.SplashScreenFuture;
import org.openmicroscopy.shoola.env.ui.SplashScreenManager;

class SplashScreenProxy
implements SplashScreen {
    private SplashScreenManager servant;
    private boolean isValid;

    SplashScreenProxy(Container c) {
        this.servant = new SplashScreenManager(this, c);
        this.isValid = false;
    }

    @Override
    public void open() {
        if (this.isValid) {
            return;
        }
        Runnable doOpen = new Runnable(){

            @Override
            public void run() {
                SplashScreenProxy.this.servant.open();
            }
        };
        SwingUtilities.invokeLater(doOpen);
        this.isValid = true;
    }

    @Override
    public void close() {
        if (!this.isValid) {
            return;
        }
        Runnable doClose = new Runnable(){

            @Override
            public void run() {
                SplashScreenProxy.this.servant.close();
            }
        };
        SwingUtilities.invokeLater(doClose);
        this.isValid = true;
    }

    @Override
    public void setTotalTasks(final int value) {
        if (!this.isValid) {
            return;
        }
        Runnable doSetTotalTasks = new Runnable(){

            @Override
            public void run() {
                SplashScreenProxy.this.servant.setTotalTasks(value);
            }
        };
        SwingUtilities.invokeLater(doSetTotalTasks);
    }

    @Override
    public void updateProgress(final String task) {
        if (!this.isValid) {
            return;
        }
        Runnable doUpdateProgress = new Runnable(){

            @Override
            public void run() {
                SplashScreenProxy.this.servant.updateProgress(task);
            }
        };
        SwingUtilities.invokeLater(doUpdateProgress);
    }

    @Override
    public UserCredentials getUserCredentials(final boolean init) {
        if (!this.isValid) {
            return null;
        }
        final SplashScreenFuture future = new SplashScreenFuture();
        Runnable doCollectUserCredentials = new Runnable(){

            @Override
            public void run() {
                SplashScreenProxy.this.servant.collectUserCredentials(future, init);
            }
        };
        SwingUtilities.invokeLater(doCollectUserCredentials);
        return (UserCredentials)future.get();
    }

    @Override
    public void onLoginFailure() {
        this.servant.onLoginFailure();
    }
}

