/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.util.ArrayList;
import java.util.List;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.util.math.geom2D.Line;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

class NavigationHistory {
    final int SIZE_Z;
    final int SIZE_T;
    final int MAX_ENTRIES;
    private List history;

    private void ensureCapacity() {
        if (this.history.size() >= this.MAX_ENTRIES) {
            this.history.remove(0);
        }
    }

    private PlaneDef lastMove() {
        int hSize = this.history.size();
        if (1 < hSize) {
            return (PlaneDef)this.history.get(hSize - 2);
        }
        return null;
    }

    private PlaneDef curMove() {
        int hSize = this.history.size();
        if (0 < hSize) {
            return (PlaneDef)this.history.get(hSize - 1);
        }
        return null;
    }

    NavigationHistory(int maxEntries, int sizeZ, int sizeT) {
        if (sizeZ <= 0) {
            throw new IllegalArgumentException("Non-positive sizeZ: " + sizeZ + ".");
        }
        if (sizeT <= 0) {
            throw new IllegalArgumentException("Non-positive  sizeT: " + sizeT + ".");
        }
        this.SIZE_Z = sizeZ;
        this.SIZE_T = sizeT;
        this.MAX_ENTRIES = maxEntries < 2 ? 2 : maxEntries;
        this.history = new ArrayList(this.MAX_ENTRIES);
    }

    void addMove(PlaneDef pd) {
        if (pd == null) {
            throw new NullPointerException("No plane def.");
        }
        int slice = pd.slice;
        int z = pd.z;
        int t = pd.t;
        if (slice != 0) {
            throw new IllegalArgumentException("Can only accept XY planes: " + slice + ".");
        }
        if (this.SIZE_Z <= z) {
            throw new IllegalArgumentException("z not in [0, SIZE_Z=" + this.SIZE_Z + "): " + z + ".");
        }
        if (this.SIZE_T <= t) {
            throw new IllegalArgumentException("t not in [0, SIZE_T=" + this.SIZE_T + "): " + t + ".");
        }
        if (pd.equals(this.curMove())) {
            return;
        }
        pd = new PlaneDef();
        pd.slice = 0;
        pd.t = t;
        pd.z = z;
        this.ensureCapacity();
        this.history.add(pd);
    }

    Line currentDirection() {
        int hSize = this.history.size();
        if (hSize < 2) {
            return null;
        }
        PlaneDef curMove = this.curMove();
        PlaneDef lastMove = this.lastMove();
        PlanePoint L = new PlanePoint(lastMove.z, lastMove.t);
        PlanePoint C = new PlanePoint(curMove.z, curMove.t);
        return new Line(L, C, C);
    }

    PlaneDef[] guessNextMoves(int maxMoves) {
        Line dir = this.currentDirection();
        if (dir == null || maxMoves <= 0) {
            return new PlaneDef[0];
        }
        ArrayList<PlaneDef> nextMoves = new ArrayList<PlaneDef>(maxMoves);
        for (int k = 1; k <= maxMoves; ++k) {
            PlanePoint p = dir.getPoint(k);
            if (p.x1 < 0.0 || (double)this.SIZE_Z <= p.x1 || p.x2 < 0.0 || (double)this.SIZE_T <= p.x2) break;
            PlaneDef pd = new PlaneDef();
            pd.slice = 0;
            pd.t = (int)p.x2;
            pd.y = (int)p.x1;
            if (nextMoves.contains(pd)) continue;
            nextMoves.add(pd);
        }
        return nextMoves.toArray(new PlaneDef[0]);
    }

    List getHistory() {
        return this.history;
    }
}

