/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.FolderData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.ROIData;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataSaver;
import org.openmicroscopy.shoola.env.data.views.calls.Analyser;
import org.openmicroscopy.shoola.env.data.views.calls.EnumerationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ExportLoader;
import org.openmicroscopy.shoola.env.data.views.calls.FigureCreator;
import org.openmicroscopy.shoola.env.data.views.calls.ImageRenderer;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesImporter;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.MovieCreator;
import org.openmicroscopy.shoola.env.data.views.calls.OverlaysRenderer;
import org.openmicroscopy.shoola.env.data.views.calls.PixelsDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PlaneInfoLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ProjectionSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ROICountLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ROILoader;
import org.openmicroscopy.shoola.env.data.views.calls.ROISaver;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingControlLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ResultsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.SaveAsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ScriptRunner;
import org.openmicroscopy.shoola.env.data.views.calls.ScriptUploader;
import org.openmicroscopy.shoola.env.data.views.calls.ServerSideROILoader;
import org.openmicroscopy.shoola.env.data.views.calls.TileLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.Tile;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

class ImageDataViewImpl
implements ImageDataView {
    ImageDataViewImpl() {
    }

    @Override
    public CallHandle loadRenderingControl(SecurityContext ctx, long pixelsID, int index, AgentEventListener observer) {
        int i = -1;
        switch (index) {
            default: {
                i = 0;
                break;
            }
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
            }
        }
        RenderingControlLoader cmd = new RenderingControlLoader(ctx, pixelsID, i);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle render(SecurityContext ctx, long pixelsID, PlaneDef pd, boolean largeImage, int compression, AgentEventListener observer) {
        ImageRenderer cmd = new ImageRenderer(ctx, pixelsID, pd, largeImage, compression);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPixels(SecurityContext ctx, long pixelsID, AgentEventListener observer) {
        PixelsDataLoader cmd = new PixelsDataLoader(ctx, pixelsID, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle analyseShapes(SecurityContext ctx, PixelsData pixels, Collection channels, List shapes, Coord3D plane, AgentEventListener observer) {
        Analyser cmd = new Analyser(ctx, pixels, channels, shapes, plane);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getRenderingSettings(SecurityContext ctx, long pixelsID, AgentEventListener observer) {
        return this.getRenderingSettings(ctx, pixelsID, -1L, observer);
    }

    @Override
    public CallHandle getRenderingSettings(SecurityContext ctx, long pixelsID, long userID, AgentEventListener observer) {
        RenderingSettingsLoader cmd = new RenderingSettingsLoader(ctx, pixelsID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle renderProjected(SecurityContext ctx, long pixelsID, int startZ, int endZ, int stepping, int algorithm, List<Integer> channels, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(ctx, pixelsID, startZ, endZ, stepping, algorithm, channels);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle projectImage(SecurityContext ctx, ProjectionParam ref, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(ctx, ref);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createRndSetting(SecurityContext ctx, long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(ctx, pixelsID, rndToCopy, indexes);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadAcquisitionData(SecurityContext ctx, Object refObject, AgentEventListener observer) {
        AcquisitionDataLoader cmd = new AcquisitionDataLoader(ctx, refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadInstrumentData(SecurityContext ctx, long instrumentID, AgentEventListener observer) {
        AcquisitionDataLoader cmd = new AcquisitionDataLoader(ctx, 0, instrumentID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveAcquisitionData(SecurityContext ctx, Object refObject, AgentEventListener observer) {
        AcquisitionDataSaver cmd = new AcquisitionDataSaver(ctx, refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPlaneInfo(SecurityContext ctx, long pixelsID, int z, int t, int channel, AgentEventListener observer) {
        PlaneInfoLoader cmd = new PlaneInfoLoader(ctx, pixelsID, z, t, channel);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelMetadataEnumerations(SecurityContext ctx, AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(ctx, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImageMetadataEnumerations(SecurityContext ctx, AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(ctx, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle importFiles(ImportableObject context, AgentEventListener observer) {
        ImagesImporter cmd = new ImagesImporter(context);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle monitorDirectory(SecurityContext ctx, File directory, DataObject container, long userID, long groupID, AgentEventListener observer) {
        return null;
    }

    @Override
    public CallHandle loadImage(SecurityContext ctx, long imageID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(ctx, imageID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createMovie(SecurityContext ctx, long imageID, long pixelsID, List<Integer> channels, MovieExportParam param, AgentEventListener observer) {
        MovieCreator cmd = new MovieCreator(ctx, imageID, pixelsID, channels, param);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createFigure(SecurityContext ctx, List<Long> ids, Class type, Object param, AgentEventListener observer) {
        FigureCreator cmd = new FigureCreator(ctx, ids, type, param);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadROI(SecurityContext ctx, long imageID, List<Long> fileID, long userID, AgentEventListener observer) {
        ROILoader cmd = new ROILoader(ctx, imageID, fileID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveROI(SecurityContext ctx, long imageID, long userID, List<ROIData> roiList, AgentEventListener observer) {
        ROISaver cmd = new ROISaver(ctx, imageID, userID, roiList);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveROIFolders(SecurityContext ctx, long imageID, long userID, Collection<ROIData> allROIs, Collection<ROIData> roiList, Collection<FolderData> folders, ROIFolderSaver.ROIFolderAction action, AgentEventListener observer) {
        ROIFolderSaver cmd = new ROIFolderSaver(ctx, imageID, userID, allROIs, roiList, folders, action);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle exportImageAsOMETiff(SecurityContext ctx, long imageID, File file, Target target, AgentEventListener observer) {
        ExportLoader cmd = new ExportLoader(ctx, imageID, file, 0, target);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadROIFromServer(SecurityContext ctx, long imageID, long userID, AgentEventListener observer) {
        ServerSideROILoader cmd = new ServerSideROILoader(ctx, imageID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getROICount(SecurityContext ctx, long imageID, AgentEventListener observer) {
        ROICountLoader cmd = new ROICountLoader(ctx, imageID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle renderOverLays(SecurityContext ctx, long pixelsID, PlaneDef pd, long tableID, Map<Long, Integer> overlays, AgentEventListener observer) {
        OverlaysRenderer cmd = new OverlaysRenderer(ctx, pixelsID, pd, tableID, overlays);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle runScript(SecurityContext ctx, ScriptObject script, AgentEventListener observer) {
        ScriptRunner cmd = new ScriptRunner(ctx, script);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle uploadScript(SecurityContext ctx, ScriptObject script, AgentEventListener observer) {
        ScriptUploader cmd = new ScriptUploader(ctx, script);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveAs(SecurityContext ctx, SaveAsParam parameters, AgentEventListener observer) {
        SaveAsLoader cmd = new SaveAsLoader(ctx, parameters);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadTiles(SecurityContext ctx, long pixelsID, PlaneDef pDef, RenderingControl proxy, Collection<Tile> tiles, AgentEventListener observer) {
        TileLoader cmd = new TileLoader(ctx, pixelsID, pDef, proxy, tiles);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle shutDownRenderingControl(SecurityContext ctx, long pixelsID, AgentEventListener observer) {
        RenderingControlLoader cmd = new RenderingControlLoader(ctx, pixelsID, 3);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveResults(SecurityContext ctx, ResultsObject results, AgentEventListener observer) {
        ResultsSaver cmd = new ResultsSaver(ctx, results);
        return cmd.exec(observer);
    }
}

