/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import omero.RString;
import omero.gateway.model.FileAnnotationData;
import omero.model.OriginalFile;

public class DownloadActivityParam {
    public static final int ORIGINAL_FILE = 0;
    public static final int FILE_ANNOTATION = 1;
    public static final int METADATA_FROM_IMAGE = 2;
    private Icon icon;
    private File folder;
    private OriginalFile file;
    private String legend;
    private String fileName;
    private String legendExtension;
    private int index;
    private long id;
    private JComponent source;
    private boolean uiRegister;
    private FileAnnotationData toDelete;
    private boolean overwrite = false;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    public DownloadActivityParam(OriginalFile file, File folder, Icon icon) {
        if (file == null) {
            throw new IllegalArgumentException("No file to download.");
        }
        this.file = file;
        this.folder = folder;
        this.icon = icon;
        this.legend = null;
        this.fileName = null;
        this.legendExtension = null;
        this.index = -1;
        this.id = -1L;
        this.uiRegister = true;
    }

    public DownloadActivityParam(long id, int index, File folder, Icon icon) {
        this.checkIndex(index);
        this.index = index;
        this.folder = folder;
        this.icon = icon;
        this.id = id;
        this.uiRegister = true;
    }

    public void setUIRegister(boolean uiRegister) {
        this.uiRegister = uiRegister;
    }

    public boolean isUIRegister() {
        return this.uiRegister;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegendExtension(String legendExtension) {
        this.legendExtension = legendExtension;
    }

    public String getLegendExtension() {
        return this.legendExtension;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public File getFolder() {
        return this.folder;
    }

    public OriginalFile getFile() {
        return this.file;
    }

    public String getOriginalFileName() {
        if (this.file == null) {
            return "";
        }
        if (!this.file.isLoaded()) {
            return "";
        }
        RString name = this.file.getName();
        if (name == null) {
            return "";
        }
        return name.getValue();
    }

    public long getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setSource(JComponent source) {
        this.source = source;
    }

    public JComponent getSource() {
        return this.source;
    }

    public FileAnnotationData getToDelete() {
        return this.toDelete;
    }

    public void setToDelete(FileAnnotationData toDelete) {
        this.toDelete = toDelete;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

