/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JFrame;
import omero.ServerError;
import omero.api.IConfigPrx;
import omero.gateway.LoginCredentials;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.AdminFacility;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.cache.CacheServiceFactory;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.AdminServiceImpl;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroDataServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroImageServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataServiceImpl;
import org.openmicroscopy.shoola.env.data.events.ConnectedEvent;
import org.openmicroscopy.shoola.env.data.events.ReloadRenderingEngine;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.svc.proxy.ProxyUtil;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.VersionCompare;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.ShutDownDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DataServicesFactory {
    private static DataServicesFactory singleton;
    private JDialog connectionDialog;
    private boolean compatible;
    private boolean upgradeCheck = false;
    private Container container;
    private static Registry registry;
    private static OMEROGateway omeroGateway;
    private OmeroDataService ds;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private AdminService admin;
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);

    public static DataServicesFactory getInstance(Container c) throws DSOutOfServiceException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            singleton = new DataServicesFactory(c);
        }
        return singleton;
    }

    private DataServicesFactory(Container c) throws DSOutOfServiceException {
        registry = c.getRegistry();
        this.container = c;
        omeroGateway = new OMEROGateway(this);
        this.ds = new OmeroDataServiceImpl(omeroGateway, registry);
        this.is = new OmeroImageServiceImpl(omeroGateway, registry);
        this.ms = new OmeroMetadataServiceImpl(omeroGateway, registry);
        this.admin = new AdminServiceImpl(omeroGateway, registry);
        RegistryFactory.linkOS(this.ds, registry);
        RegistryFactory.linkMS(this.ms, registry);
        RegistryFactory.linkAdmin(this.admin, registry);
        RegistryFactory.linkIS(this.is, registry);
        RegistryFactory.linkGateway(omeroGateway.getGateway(), registry);
        DataViewsFactory.initialize(c);
    }

    private float determineCompression(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: 
            case 1: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private int determineImageQuality(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    private Boolean checkClientServerCompatibility(String server, String client2) {
        if (server == null || client2 == null) {
            return false;
        }
        if (client2.startsWith("@")) {
            return true;
        }
        if (server.contains("-")) {
            server = server.split("-")[0];
        }
        if (client2.contains("-")) {
            client2 = client2.split("-")[0];
        }
        String[] values = server.split("\\.");
        String[] valuesClient = client2.split("\\.");
        if (values.length < 2 || valuesClient.length < 2) {
            return false;
        }
        try {
            int s1 = Integer.parseInt(values[0]);
            int s2 = Integer.parseInt(values[1]);
            int c1 = Integer.parseInt(valuesClient[0]);
            int c2 = Integer.parseInt(valuesClient[1]);
            if (s1 < c1) {
                return false;
            }
            if (s2 != c2) {
                return false;
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Client server compatibility");
            msg.print((Throwable)e);
            registry.getLogger().debug((Object)this, msg);
            String message = "An error occurred while checking the compatibility between client and server.\nDo you still want to connect (further errors might occur)?";
            JFrame f = new JFrame();
            f.setIconImage(IconManager.getOMEImageIcon());
            MessageBox box = new MessageBox(f, "Version Check", message);
            box.setAlwaysOnTop(true);
            if (box.centerMsgBox() == 1) {
                return true;
            }
            return null;
        }
        return true;
    }

    private void notifyIncompatibility(String clientVersion, String serverVersion, String hostname) {
        UserNotifier un = registry.getUserNotifier();
        StringBuffer buffer = new StringBuffer();
        buffer.append("The client version (" + clientVersion + ") is not compatible with the server:\n" + hostname);
        if (serverVersion != null) {
            buffer.append(" version:" + serverVersion);
        }
        buffer.append(".");
        un.notifyInfo("Client Server not compatible", buffer.toString());
    }

    UserCredentials getCredentials() {
        return (UserCredentials)registry.lookup("/user/credentials");
    }

    Integer getElapseTime() {
        return (Integer)registry.lookup("/services/NETWORK/timeout");
    }

    private void addListenerAndShow() {
        if (this.connectionDialog instanceof ShutDownDialog) {
            ShutDownDialog d = (ShutDownDialog)this.connectionDialog;
            d.setGateway(omeroGateway.getGateway());
            d.setCheckupTime(5);
        }
        this.connectionDialog.setModal(false);
        this.connectionDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("closeNotification".equals(name)) {
                    DataServicesFactory.this.reconnecting.set(false);
                    DataServicesFactory.this.connectionDialog = null;
                    DataServicesFactory.this.exitApplication(true, true);
                } else if ("cancelNotification".equals(name)) {
                    DataServicesFactory.this.connectionDialog = null;
                    DataServicesFactory.this.reconnecting.set(false);
                    int index = (Integer)evt.getNewValue();
                    if (index == 0) {
                        DataServicesFactory.this.reconnect();
                    }
                }
            }
        });
        this.connectionDialog.setModal(true);
        UIUtilities.centerAndShow(this.connectionDialog);
    }

    private void reconnect() {
        JFrame f = registry.getTaskBar().getFrame();
        Map<SecurityContext, Set<Long>> l = omeroGateway.getRenderingEngines();
        boolean b = omeroGateway.joinSession();
        if (b) {
            Iterator<Map.Entry<SecurityContext, Set<Long>>> i = l.entrySet().iterator();
            OmeroImageService svc = registry.getImageService();
            HashMap<SecurityContext, List<Long>> failures = new HashMap<SecurityContext, List<Long>>();
            while (i.hasNext()) {
                Map.Entry<SecurityContext, Set<Long>> entry = i.next();
                Iterator<Long> j = entry.getValue().iterator();
                SecurityContext ctx = entry.getKey();
                while (j.hasNext()) {
                    Long id = j.next();
                    try {
                        RenderingControl p = PixelsServicesFactory.getRenderingControl(registry, (long)id, false);
                        if (p.isShutDown()) continue;
                        registry.getLogger().debug((Object)this, "loading re " + id);
                        svc.reloadRenderingService(ctx, id);
                    }
                    catch (Exception e) {
                        ArrayList<Long> failure = (ArrayList<Long>)failures.get(ctx);
                        if (failure == null) {
                            failure = new ArrayList<Long>();
                            failures.put(ctx, failure);
                        }
                        registry.getLogger().debug((Object)this, "Failed to load re for " + id + " " + e);
                        failure.add(id);
                    }
                }
            }
            if (failures.size() > 0) {
                registry.getEventBus().post(new ReloadRenderingEngine(failures));
            }
            this.connectionDialog.setVisible(false);
            this.connectionDialog.dispose();
            this.connectionDialog = null;
            this.reconnecting.set(false);
        } else {
            String message = "A failure occurred while attempting to reconnect.\nThe application will now exit.";
            this.connectionDialog = new NotificationDialog(f, "Reconnection Failure", message, null);
            this.addListenerAndShow();
        }
    }

    int runAsPlugin() {
        Integer v = (Integer)this.container.getRegistry().lookup("Plugin");
        if (v == null) {
            return -1;
        }
        return v;
    }

    public void sessionExpiredExit(int index, Throwable exc) {
        if (this.reconnecting.get()) {
            return;
        }
        this.reconnecting.set(true);
        if (exc != null) {
            LogMessage msg = new LogMessage();
            msg.print("Connection Error");
            msg.print(exc);
            registry.getLogger().debug((Object)this, msg);
        }
        JFrame f = registry.getTaskBar().getFrame();
        switch (index) {
            case 2: {
                String message = "The connection has been destroyed.\nThe application will now exit.";
                this.connectionDialog = new NotificationDialog(f, "Connection Refused", message, null);
                this.addListenerAndShow();
                break;
            }
            case 3: {
                String message = "The network is down.\n";
                this.connectionDialog = new ShutDownDialog(f, "Network down", message, -1);
                this.addListenerAndShow();
                break;
            }
            case 0: {
                this.connectionDialog = new ShutDownDialog(f, "Lost connection", "Trying to reconnect...", index);
                this.addListenerAndShow();
                break;
            }
            case 1: {
                String message = "The server is no longer running.\nPlease contact your system administrator.\nThe application will now exit.";
                this.connectionDialog = new NotificationDialog(f, "Connection Refused", message, null);
                this.addListenerAndShow();
            }
        }
    }

    public OmeroDataService getOS() {
        return this.ds;
    }

    public OmeroImageService getIS() {
        return this.is;
    }

    public OmeroMetadataService getMS() {
        return this.ms;
    }

    public AdminService getAdmin() {
        return this.admin;
    }

    public LoginService getLoginService() {
        return (LoginService)registry.lookup("/services/Login");
    }

    Logger getLogger() {
        return registry.getLogger();
    }

    public void connect(UserCredentials uc) throws DSOutOfServiceException {
        HashSet<GroupData> available;
        String version;
        Boolean check;
        if (uc == null) {
            throw new NullPointerException("No user credentials.");
        }
        String name = (String)this.container.getRegistry().lookup("master");
        if (CommonsLangUtils.isBlank(name)) {
            name = "OMERO.insight";
        }
        LoginCredentials cred = new LoginCredentials();
        cred.getUser().setUsername(uc.getUserName());
        cred.getUser().setPassword(uc.getPassword());
        cred.getServer().setHostname(uc.getHostName());
        cred.getServer().setPort(uc.getPort());
        cred.setApplicationName(name);
        cred.setCheckNetwork(true);
        cred.setCompression(this.determineCompression(uc.getSpeedLevel()));
        cred.setEncryption(uc.isEncrypted());
        ExperimenterData exp = omeroGateway.connect(cred);
        this.compatible = true;
        Object v = this.container.getRegistry().lookup("Version");
        String clientVersion = "";
        if (v != null && v instanceof String) {
            clientVersion = (String)v;
        }
        if (uc.getUserName().equals(omeroGateway.getSessionId(exp))) {
            this.container.getRegistry().bind("SessionKey", Boolean.TRUE);
        }
        if ((check = this.checkClientServerCompatibility(version = omeroGateway.getServerVersion(), clientVersion)) == null) {
            this.compatible = false;
            omeroGateway.logout();
            return;
        }
        if (!check.booleanValue()) {
            this.compatible = false;
            this.notifyIncompatibility(clientVersion, version, uc.getHostName());
            omeroGateway.logout();
            return;
        }
        this.container.getRegistry().bind("5.4.8 or later", VersionCompare.compare(version, "5.4.8") >= 0);
        IConfigPrx cs = omeroGateway.getGateway().getConfigService(new SecurityContext(exp.getGroupId()));
        try {
            String val = cs.getConfigValue("omero.pixeldata.max_plane_width");
            if (val != null) {
                this.container.getRegistry().bind("/services/Thumbnailing/non_pyramid_max_plane_width", Integer.parseInt(val));
            }
            if ((val = cs.getConfigValue("omero.pixeldata.max_plane_height")) != null) {
                this.container.getRegistry().bind("/services/Thumbnailing/non_pyramid_max_plane_height", Integer.parseInt(val));
            }
        }
        catch (ServerError e2) {
            registry.getLogger().warn((Object)this, "Could not access ConfigService");
        }
        omeroGateway.isUpgradeRequired(name);
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.post(new ConnectedEvent());
        this.compatible = true;
        Map<String, String> info = ProxyUtil.collectOsInfoAndJavaVersion();
        LogMessage msg = new LogMessage();
        msg.println("Server version: " + version);
        msg.println("Client version: " + clientVersion);
        for (Map.Entry<String, String> entry : info.entrySet()) {
            msg.println(entry.getKey() + ": " + entry.getValue());
        }
        registry.getLogger().info((Object)this, msg);
        registry.bind("/current_user/details", exp);
        registry.bind("/connection/speed", this.determineImageQuality(uc.getSpeedLevel()));
        try {
            List agents = (List)registry.lookup("/agents");
            Map<String, String> props = omeroGateway.getOmeroClientProperties(exp.getGroupId());
            for (String key : props.keySet()) {
                if (registry.lookup(key) == null) {
                    registry.bind(key, props.get(key));
                }
                for (Object agent : agents) {
                    Registry agentReg = ((AgentInfo)agent).getRegistry();
                    if (agentReg == null || agentReg.lookup(key) != null) continue;
                    agentReg.bind(key, props.get(key));
                }
            }
        }
        catch (DSAccessException e1) {
            registry.getLogger().warn((Object)this, "Could not load omero client properties from the server");
        }
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        Object ldap = null;
        long gid = exp.getDefaultGroup().getId();
        SecurityContext ctx = new SecurityContext(gid);
        boolean canCreate = omeroGateway.canCreate(ctx);
        if (!canCreate && "OMERO.importer".equals(name)) {
            registry.getUserNotifier().notifyError("Read-only server", "Cannot import on a read-only server!");
            this.exitApplication(true, true);
        }
        try {
            GroupData defaultGroup = null;
            registry.bind("canCreate", canCreate);
            Set<GroupData> groups = omeroGateway.getAvailableGroups(ctx, exp);
            registry.bind("/system/roles", omeroGateway.getSystemRoles(ctx));
            Iterator i = groups.iterator();
            available = new HashSet<GroupData>();
            while (i.hasNext()) {
                GroupData g = (GroupData)i.next();
                if (gid == g.getId()) {
                    defaultGroup = g;
                }
                if (!this.admin.isSecuritySystemGroup(g.getId())) {
                    available.add(g);
                    continue;
                }
                if (!this.admin.isSecuritySystemGroup(g.getId(), "system")) continue;
                available.add(g);
                uc.setAdministrator(true);
            }
            if (available.size() == 0) {
                if (defaultGroup != null) {
                    available.add(defaultGroup);
                } else {
                    available.add(exp.getDefaultGroup());
                }
            }
            registry.bind("/userGroup/details", available);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (GroupData g : available) {
                Set set = g.getExperimenters();
                for (ExperimenterData e : set) {
                    if (ids.contains(e.getId())) continue;
                    ids.add(e.getId());
                    exps.add(e);
                }
            }
            registry.bind("/users/details", exps);
            registry.bind("/users/administrator", uc.isAdministrator());
            try {
                List privs = DataServicesFactory.omeroGateway.getGateway().getAdminService((SecurityContext)ctx).getEventContext().adminPrivileges;
                registry.bind("/fulladministrator", ((AdminFacility)omeroGateway.getGateway().getFacility(AdminFacility.class)).isFullAdmin(ctx));
                registry.bind("/users/edit", privs.contains("ModifyUser"));
                registry.bind("/groups/edit", privs.contains("ModifyGroup"));
                registry.bind("/groups/add", privs.contains("ModifyGroupMembership"));
                registry.bind("/groups/move", privs.contains("Chgrp"));
                registry.bind("/scripts/upload", privs.contains("WriteScriptRepo"));
                registry.bind("/users/sudo", privs.contains("Sudo"));
            }
            catch (Exception e1) {
                registry.bind("/fulladministrator", false);
                registry.bind("/users/edit", false);
                registry.bind("/groups/edit", false);
                registry.bind("/groups/add", false);
                registry.bind("/groups/move", false);
                registry.getLogger().warn((Object)this, "Could not retrieve admin priviledges.");
            }
        }
        catch (DSAccessException e) {
            throw new DSOutOfServiceException("Cannot retrieve groups", (Throwable)e);
        }
        List agents = (List)registry.lookup("/agents");
        Iterator kk = agents.iterator();
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        String url = (String)registry.lookup("HelpOnLineSearch");
        while (kk.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)kk.next();
            if (!agentInfo.isActive()) continue;
            Registry reg = agentInfo.getRegistry();
            reg.bind("canCreate", canCreate);
            reg.bind("/current_user/details", exp);
            reg.bind("/userGroup/details", available);
            reg.bind("/users/details", exps);
            reg.bind("/users/administrator", uc.isAdministrator());
            reg.bind("/connection/speed", this.determineImageQuality(uc.getSpeedLevel()));
            reg.bind("/services/SERVER/BinaryAvailable", b);
            reg.bind("HelpOnLineSearch", url);
            reg.bind("/fulladministrator", registry.lookup("/fulladministrator"));
            reg.bind("/users/edit", registry.lookup("/users/edit"));
            reg.bind("/groups/edit", registry.lookup("/groups/edit"));
            reg.bind("/groups/move", registry.lookup("/groups/move"));
            reg.bind("/groups/add", registry.lookup("/groups/add"));
            reg.bind("/users/sudo", registry.lookup("/users/sudo"));
            reg.bind("/scripts/upload", registry.lookup("/scripts/upload"));
        }
    }

    public boolean isConnected() {
        return omeroGateway.isConnected();
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void shutdown(SecurityContext ctx) {
        try {
            if (omeroGateway != null) {
                omeroGateway.logout();
            }
            registry.getCacheService().clearAllCaches();
            PixelsServicesFactory.shutDownRenderingControls(this.container.getRegistry());
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage("Could not properly shutdown OMERO connection", (Throwable)e);
            this.container.getRegistry().getLogger().error((Object)this, msg);
        }
        singleton = null;
        omeroGateway = null;
    }

    public void exitApplication(boolean forceQuit, boolean exit) {
        if (!forceQuit) {
            AgentInfo agentInfo;
            List agents = (List)registry.lookup("/agents");
            Iterator i = agents.iterator();
            i = agents.iterator();
            ArrayList<AgentInfo> notTerminated = new ArrayList<AgentInfo>();
            while (i.hasNext()) {
                agentInfo = (AgentInfo)i.next();
                if (!agentInfo.isActive()) continue;
                Agent a = agentInfo.getAgent();
                if (a.canTerminate()) {
                    a.terminate();
                    continue;
                }
                notTerminated.add(agentInfo);
            }
            if (notTerminated.size() > 0) {
                i = notTerminated.iterator();
                StringBuffer buffer = new StringBuffer();
                while (i.hasNext()) {
                    agentInfo = (AgentInfo)i.next();
                    buffer.append(agentInfo.getName());
                    buffer.append("\n");
                }
                String message = "The following components could not be closed safely:\n" + buffer.toString() + "\nPlease check.";
                String title = "Exit Application";
                Environment env = (Environment)registry.lookup("/env");
                if (env != null && env.isRunAsPlugin()) {
                    title = "Exit Plugin";
                }
                MessageBox box = new MessageBox(registry.getTaskBar().getFrame(), title, message, IconManager.getInstance().getIcon(51));
                box.setNoText("OK");
                box.setYesText("Force Quit");
                box.setSize(400, 250);
                if (!env.isRunAsPlugin() && box.centerMsgBox() == 0) {
                    return;
                }
            }
        }
        this.shutdown(null);
        if (exit) {
            CacheServiceFactory.shutdown(this.container);
            this.container.exit();
        }
        singleton = null;
    }

    public void removeGroup(SecurityContext ctx) throws Exception {
        omeroGateway.removeGroup(ctx);
    }

    public void checkServicesStatus() {
        PixelsServicesFactory.checkRenderingControls(this.container.getRegistry());
    }
}

