/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.cache;

import java.io.InputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import omero.gateway.cache.CacheService;
import omero.log.LogMessage;
import omero.log.Logger;

class CacheServiceImpl
implements CacheService {
    private CacheManager manager;
    private int cacheID;
    private Logger log;

    CacheServiceImpl(InputStream config, Logger log) {
        if (log == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        this.manager = new CacheManager(config);
        this.log = log;
        this.cacheID = -1;
    }

    public void shutDown() {
        try {
            this.manager.shutdown();
        }
        catch (Exception e) {
            String s = "Cache shut down";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
    }

    public int createCache() {
        return this.createCache(0);
    }

    public int createCache(int type, int size) {
        if (size <= 0) {
            size = 1;
        }
        switch (type) {
            case 1: {
                return -1;
            }
            case 2: {
                ++this.cacheID;
                Cache cache = new Cache("" + this.cacheID, size, MemoryStoreEvictionPolicy.LRU, true, this.manager.getConfiguration().getDiskStoreConfiguration().getPath(), false, 300L, 600L, false, 300L, null, null, 10000000);
                this.manager.addCache(cache);
                break;
            }
            case 0: {
                ++this.cacheID;
                this.manager.addCache("" + this.cacheID);
                break;
            }
            default: {
                return -1;
            }
        }
        return this.cacheID;
    }

    public int createCache(int type) {
        return this.createCache(type, 10);
    }

    public void removeCache(int cacheID) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            String s = "Remove cache with ID: " + cacheID;
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (cache != null) {
            this.manager.removeCache("" + cacheID);
        }
    }

    public void addElement(int cacheID, Object key, Object element) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            String s = "Cannot retrieve cache with ID: " + cacheID;
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (cache == null) {
            return;
        }
        if (cache.getSize() >= cache.getCacheConfiguration().getMaxElementsInMemory()) {
            cache.flush();
        }
        cache.put(new Element(key, element));
    }

    public Object getElement(int cacheID, Object key) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            String s = "Cannot retrieve cache with ID: " + cacheID;
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (cache == null) {
            return null;
        }
        Element element = null;
        try {
            element = cache.get(key);
        }
        catch (Exception e) {
            String s = "Cannot retrieve the specified key: " + key.toString();
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public void clearCache(int cacheID) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            String s = "Cannot retrieve cache with ID: " + cacheID;
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (cache == null) {
            return;
        }
        cache.removeAll();
    }

    public void clearAllCaches() {
        try {
            String[] names = this.manager.getCacheNames();
            if (names == null) {
                return;
            }
            for (int i = 0; i < names.length; ++i) {
                Cache cache = this.manager.getCache(names[i]);
                if (cache != null) {
                    cache.removeAll();
                }
                this.manager.removeCache(names[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCacheEntries(int cacheID, int size) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            String s = "Cannot retrieve cache with ID: " + cacheID;
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            this.log.debug((Object)this, msg);
        }
        if (cache == null) {
            return;
        }
        cache.flush();
        cache.getCacheConfiguration().setMaxElementsInMemory(size);
    }
}

