/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.editorpreview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewModel;
import org.openmicroscopy.shoola.agents.util.editorpreview.StepObject;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PreviewPanel
extends JPanel
implements PropertyChangeListener {
    public static final String OPEN_FILE_PROPERTY = "openFile";
    public static final String PREVIEW_EDITED_PROPERTY = "previewEdited";
    public static final int MAX_CHARS = 50;
    public static final String VALUE = "v";
    public static final String PARAMETER = "p";
    public static final String LEVEL = "l";
    public static final String STEP = "s";
    public static final String STEPS = "ss";
    public static final String DESCRIPTION = "d";
    public static final String NAME = "n";
    private static final String DEFAULT_TEXT = "None";
    private PreviewModel model;
    private long fileID;
    private List<DataComponent> fields;

    private JPanel layoutTiTle() {
        IconManager icons = IconManager.getInstance();
        JButton open = new JButton(icons.getIcon(103));
        open.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(open);
        open.setBackground(UIUtilities.BACKGROUND_COLOR);
        open.setToolTipText("Open the file.");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreviewPanel.this.fileID >= 0L) {
                    PreviewPanel.this.firePropertyChange(PreviewPanel.OPEN_FILE_PROPERTY, -1L, PreviewPanel.this.fileID);
                }
            }
        });
        JToolBar bar = new JToolBar();
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(open);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 0));
        if (this.fileID > 0L) {
            p.add(bar);
        }
        p.add(UIUtilities.setTextFont(this.getTitle()));
        JPanel content = UIUtilities.buildComponentPanel(p, 0, 0);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        return content;
    }

    private void initComponents() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        String description = "";
        List<String> values = this.getFormattedDesciption();
        if (values.size() == 0) {
            description = "Description and Summary Not available";
        } else {
            Iterator<String> i = values.iterator();
            StringBuffer buffer = new StringBuffer();
            while (i.hasNext()) {
                buffer.append(i.next());
                buffer.append("<br>");
            }
            description = "<html><span style='font-family:sans-serif;font-size:11pt'>" + buffer.toString() + "</span></html>";
            JEditorPane ep = new JEditorPane("text/html", description);
            ep.setEditable(false);
            ep.setBorder(new EmptyBorder(3, 5, 5, 3));
            p.add(ep);
        }
        List<StepObject> protocolSteps = this.model.getSteps();
        this.fields = new ArrayList<DataComponent>();
        for (StepObject stepObject : protocolSteps) {
            List<DataComponent> paramComponents = this.transformFieldParams(stepObject);
            if (paramComponents.isEmpty()) continue;
            this.fields.addAll(paramComponents);
            String stepName = stepObject.getName();
            int indent = stepObject.getLevel() * 10;
            JPanel nodePanel = new JPanel();
            AbstractBorder border = new EmptyBorder(0, indent, 0, 0);
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createTitledBorder(stepName));
            nodePanel.setBorder(border);
            nodePanel.setBackground(UIUtilities.BACKGROUND_COLOR);
            nodePanel.setLayout(new GridBagLayout());
            this.layoutFields(nodePanel, null, paramComponents);
            p.add(nodePanel);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.layoutTiTle(), "North");
        this.add((Component)p, "Center");
    }

    private void rebuildUI() {
        this.removeAll();
        this.initComponents();
        this.revalidate();
        this.repaint();
    }

    private void layoutFields(JPanel pane, JButton button, List<DataComponent> fields) {
        pane.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        for (DataComponent comp : fields) {
            c.gridx = 0;
            if (!comp.isSetField()) continue;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            pane.add((Component)comp.getLabel(), c);
            ++c.gridx;
            pane.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.weightx = 1.0;
            pane.add((Component)comp.getArea(), c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        if (button != null) {
            pane.add((Component)button, c);
        }
    }

    private List<DataComponent> transformFieldParams(StepObject step) {
        ArrayList<DataComponent> cmps = new ArrayList<DataComponent>();
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List<StepObject.Param> params = step.getParams();
        for (StepObject.Param param : params) {
            String key = param.getName();
            String value = param.getValue();
            if (value != null && value.length() > 50) {
                value = value.substring(0, 49) + "...";
            }
            JComponent area = UIUtilities.createComponent(OMETextArea.class, null);
            if (value == null || value.equals("")) {
                value = DEFAULT_TEXT;
            }
            ((OMETextArea)area).setText(value);
            ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            DataComponent comp = new DataComponent(label, area);
            comp.attachListener(this);
            comp.setSetField(value != null);
            comp.setEnabled(false);
            cmps.add(comp);
        }
        return cmps;
    }

    private void onFieldModified() {
        boolean dirty = this.hasDataToSave();
        this.firePropertyChange(PREVIEW_EDITED_PROPERTY, (Object)(!dirty ? 1 : 0), (Object)dirty);
    }

    public PreviewPanel(String xmlDescription, long fileID) {
        this.fileID = fileID;
        this.setDescriptionXml(xmlDescription);
    }

    public PreviewPanel() {
        this.fileID = -1L;
    }

    public void setDescriptionXml(String xmlDescription) {
        this.model = new PreviewModel(xmlDescription);
        this.rebuildUI();
    }

    public String getTitle() {
        if (this.model == null) {
            return "OMERO.editor";
        }
        return this.model.getTitle();
    }

    public String getDescription() {
        if (this.model == null) {
            return "";
        }
        return this.model.getDescription();
    }

    public List<String> getFormattedDesciption() {
        ArrayList<String> list = new ArrayList<String>();
        String description = this.getDescription();
        if (description == null || description.length() == 0) {
            return list;
        }
        String[] values = description.split(" ");
        StringBuffer buffer = null;
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (n == 0) {
                buffer = new StringBuffer();
            }
            buffer.append(values[i] + " ");
            if (++n != 10) continue;
            n = 0;
            list.add(buffer.toString());
        }
        return list;
    }

    public boolean hasDataToSave() {
        boolean dirty = false;
        for (DataComponent comp : this.fields) {
            if (!comp.isDirty()) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    public String prepareDataToSave() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("dataModified".equals(name)) {
            this.onFieldModified();
        }
    }
}

