/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.util.ChgrpObject;
import org.openmicroscopy.shoola.agents.treeviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.CreateFolderDialog;

public class MoveGroupSelectionDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
TreeSelectionListener {
    public static final String TRANSFER_PROPERTY = "transfer";
    public static final int CANCEL = 1;
    private static final int MOVE = 2;
    private static final int CREATE = 3;
    private static final String TEXT = "Select where to move the data.";
    private static final Dimension SIZE = new Dimension(32, 32);
    private ChgrpObject object;
    private JButton cancelButton;
    private JButton moveButton;
    private JButton createButton;
    private JComponent body;
    private long userID;
    private ViewerSorter sorter;
    private int status;
    private JTree treeDisplay;
    private Class<?> containerType;
    private DataObject toCreate;
    private boolean noDisplay;

    private void create(String name) {
        if (this.containerType == null) {
            return;
        }
        if (ProjectData.class.equals(this.containerType)) {
            this.toCreate = new ProjectData();
            ((ProjectData)this.toCreate).setName(name);
        } else if (ScreenData.class.equals(this.containerType)) {
            this.toCreate = new ScreenData();
            ((ScreenData)this.toCreate).setName(name);
        } else if (DatasetData.class.equals(this.containerType)) {
            this.toCreate = new DatasetData();
            ((DatasetData)this.toCreate).setName(name);
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        TreeImageSet node = new TreeImageSet(this.toCreate);
        node.setDisplayItems(false);
        dtm.insertNodeInto(node, root, root.getChildCount());
        node = (TreeImageSet)root.getChildAt(root.getChildCount() - 1);
        this.treeDisplay.setSelectionPath(new TreePath(node.getPath()));
        if (this.noDisplay) {
            this.noDisplay = false;
            Container c = this.getContentPane();
            c.remove(this.body);
            c.remove(1);
            c.add((Component)new JScrollPane(this.treeDisplay), "Center");
            c.add((Component)this.buildToolBar(), "South");
            this.validate();
            this.repaint();
        }
    }

    private void showNewFolder() {
        if (this.containerType == null) {
            return;
        }
        String title = "";
        String defaultName = "";
        if (ProjectData.class.equals(this.containerType)) {
            title = "New Project";
            defaultName = "untitled project";
        } else if (ScreenData.class.equals(this.containerType)) {
            title = "New Screen";
            defaultName = "untitled screen";
        } else if (DatasetData.class.equals(this.containerType)) {
            title = "New Dataset";
            defaultName = "untitled dataset";
        }
        CreateFolderDialog d = new CreateFolderDialog(this, title);
        d.setDefaultName(defaultName);
        d.addPropertyChangeListener("createFolder", this);
        d.pack();
        UIUtilities.centerAndShow(this, d);
    }

    private void buildTreeNode(TreeImageDisplay parent, Collection<TreeImageDisplay> nodes, DefaultTreeModel tm) {
        for (TreeImageDisplay display : nodes) {
            List children;
            display.setDisplayItems(false);
            tm.insertNodeInto(display, parent, parent.getChildCount());
            if (!(display instanceof TreeImageSet) || (children = display.getChildrenDisplay()).size() <= 0) continue;
            this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
        }
    }

    private void cancel() {
        this.status = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void move() {
        DataObject target = null;
        if (this.toCreate != null) {
            target = this.toCreate;
        } else {
            Object object;
            TreePath path = this.treeDisplay.getSelectionPath();
            if (path != null && (object = path.getLastPathComponent()) != null && object instanceof TreeImageDisplay) {
                target = (DataObject)((TreeImageDisplay)object).getUserObject();
            }
        }
        ChgrpObject newObject = new ChgrpObject(this.object.getGroupData(), target, this.object.getTransferable());
        this.firePropertyChange(TRANSFER_PROPERTY, null, newObject);
        this.cancel();
    }

    private void initComponents(boolean same) {
        this.containerType = null;
        this.sorter = new ViewerSorter();
        this.createButton = new JButton("New...");
        this.createButton.addActionListener(this);
        this.createButton.setActionCommand("3");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("1");
        this.moveButton = new JButton("Move");
        this.moveButton.setEnabled(true);
        this.moveButton.addActionListener(this);
        this.moveButton.setActionCommand("2");
        for (Map.Entry<SecurityContext, List<DataObject>> entry : this.object.getTransferable().entrySet()) {
            List<DataObject> list = entry.getValue();
            if (list == null || list.size() <= 0) continue;
            DataObject data = list.get(0);
            if (data instanceof PlateData) {
                this.containerType = ScreenData.class;
                continue;
            }
            if (data instanceof DatasetData) {
                this.containerType = ProjectData.class;
                continue;
            }
            if (!(data instanceof ImageData)) continue;
            this.containerType = DatasetData.class;
        }
        this.createButton.setEnabled(false);
        if (same) {
            this.createButton.setEnabled(this.containerType != null);
            this.createButton.setVisible(this.containerType != null);
        }
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.moveButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        JPanel barLeft = new JPanel();
        barLeft.add(this.createButton);
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        row.add(UIUtilities.buildComponentPanel(barLeft));
        row.add(UIUtilities.buildComponentPanelRight(bar));
        return row;
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(this.getTitle(), TEXT, icons.getIcon(162));
        Container c = this.getContentPane();
        c.add((Component)((Object)tp), "North");
        JXBusyLabel label = new JXBusyLabel(SIZE);
        label.setBusy(true);
        this.body = this.buildContent((JComponent)label);
        c.add((Component)this.body, "Center");
        c.add((Component)this.buildToolBar(), "South");
        this.setSize(400, 500);
    }

    private JComponent buildContent(JComponent comp) {
        double[][] tl = new double[][]{{-1.0}, {-1.0}};
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setLayout(new TableLayout(tl));
        content.setBackground(UIUtilities.BACKGROUND);
        content.add((Component)comp, "0, 0, CENTER, CENTER");
        return content;
    }

    private List<TreeImageDisplay> prepareSortedList(List<TreeImageDisplay> sorted) {
        ArrayList<TreeImageDisplay> top = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> bottom = new ArrayList<TreeImageDisplay>();
        ArrayList top2 = new ArrayList();
        ArrayList bottom2 = new ArrayList();
        for (TreeImageDisplay object : sorted) {
            Object uo = object.getUserObject();
            if (ProjectData.class.equals(this.containerType)) {
                if (!(uo instanceof ProjectData)) continue;
                top.add(object);
                object.removeAllChildrenDisplay();
                continue;
            }
            if (ScreenData.class.equals(this.containerType)) {
                if (!(uo instanceof ScreenData)) continue;
                top.add(object);
                object.removeAllChildrenDisplay();
                continue;
            }
            if (!DatasetData.class.equals(this.containerType)) continue;
            if (uo instanceof ProjectData) {
                top.add(object);
                continue;
            }
            if (!(uo instanceof DatasetData)) continue;
            bottom.add(object);
        }
        ArrayList<TreeImageDisplay> all = new ArrayList<TreeImageDisplay>();
        if (top.size() > 0) {
            all.addAll(top);
        }
        if (bottom.size() > 0) {
            all.addAll(bottom);
        }
        if (top2.size() > 0) {
            all.addAll(top2);
        }
        if (bottom2.size() > 0) {
            all.addAll(bottom2);
        }
        return all;
    }

    private void buildNoContentPane() {
        this.noDisplay = true;
        Container c = this.getContentPane();
        StringBuffer s = new StringBuffer();
        StringBuffer s1 = new StringBuffer();
        if (ProjectData.class.equals(this.containerType)) {
            s.append("There is no Project to move the Dataset(s) into.");
            s1.append("Please create a new Project if you wish.");
        } else if (DatasetData.class.equals(this.containerType)) {
            s.append("There is no Dataset to move the Image(s) into.");
            s1.append("Please create a new Dataset if you wish.");
        } else if (ScreenData.class.equals(this.containerType)) {
            s.append("There is no Screen to move the Plate into.");
            s1.append("Please create a new Screen if you wish.");
        }
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND);
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel(s.toString()));
        p.add(new JLabel(s1.toString()));
        this.body = this.buildContent(p);
        c.add((Component)this.body, "Center");
        c.add((Component)this.buildToolBar(), "South");
        this.validate();
        this.repaint();
    }

    public MoveGroupSelectionDialog(JFrame owner, long userID, ChgrpObject object, boolean same) {
        super(owner);
        if (object == null) {
            throw new IllegalArgumentException("No object to move.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Move to ");
        buf.append(object.getGroupData().getName());
        this.setTitle(buf.toString());
        this.object = object;
        this.userID = userID;
        this.initComponents(same);
        this.buildGUI();
    }

    public int getStatus() {
        return this.status;
    }

    public void setTargets(Collection<DataObject> targets) {
        Container c = this.getContentPane();
        c.remove(this.body);
        c.remove(1);
        this.treeDisplay = new JTree();
        this.treeDisplay.setVisible(true);
        this.treeDisplay.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer(this.userID));
        this.treeDisplay.setShowsRootHandles(true);
        TreeImageSet root = new TreeImageSet("");
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        this.treeDisplay.addTreeSelectionListener(this);
        if (CollectionUtils.isEmpty(targets)) {
            this.buildNoContentPane();
            return;
        }
        Set<TreeImageDisplay> nodes = TreeViewerTranslator.transformHierarchy(new ArrayList<DataObject>(targets));
        List<TreeImageDisplay> transformedNodes = this.prepareSortedList(this.sorter.sort(nodes));
        if (transformedNodes.size() == 0) {
            this.buildNoContentPane();
            return;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        this.buildTreeNode(root, transformedNodes, dtm);
        dtm.reload();
        c.add((Component)new JScrollPane(this.treeDisplay), "Center");
        c.add((Component)this.buildToolBar(), "South");
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.cancel();
                break;
            }
            case 2: {
                this.move();
                break;
            }
            case 3: {
                this.showNewFolder();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String folderName;
        String name = evt.getPropertyName();
        if ("createFolder".equals(name) && (folderName = (String)evt.getNewValue()) != null && folderName.trim().length() > 0) {
            this.create(folderName);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.treeDisplay.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.moveButton.setEnabled(false);
            return;
        }
        Object p = paths[0].getLastPathComponent();
        if (p instanceof TreeImageDisplay) {
            Object ho = ((TreeImageDisplay)p).getUserObject();
            this.moveButton.setEnabled(ho.getClass().equals(this.containerType));
        }
    }
}

