/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.treeviewer.ImageChecker;
import org.openmicroscopy.shoola.agents.treeviewer.util.ChgrpObject;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.ThumbnailLabel;
import org.openmicroscopy.shoola.env.data.model.MIFResultObject;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MIFNotificationDialog
extends JDialog {
    public static final String MOVE_ALL_PROPERTY = "moveAll";
    private static final String TITLE_DELETE = "Delete";
    private static final String TITLE_CHGRP = "Move to Group: ";
    private JButton closeButton;
    private JButton moveButton;
    private ImageChecker.ImageCheckerType index;
    private List<MIFResultObject> result;
    private Object action;
    private Collection groups;

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void move() {
        ChgrpObject object = (ChgrpObject)this.action;
        Map<SecurityContext, List<DataObject>> map = object.getTransferable();
        for (MIFResultObject mif : this.result) {
            List<DataObject> values = map.get(mif.getContext());
            values.addAll(mif.getFailures());
        }
        this.firePropertyChange(MOVE_ALL_PROPERTY, null, object);
        this.close();
    }

    private void initialize() {
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MIFNotificationDialog.this.close();
            }
        });
        this.moveButton = new JButton("Move All");
        this.moveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MIFNotificationDialog.this.move();
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        if (ImageChecker.ImageCheckerType.CHGRP.equals((Object)this.index)) {
            bar.add(this.moveButton);
            bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        }
        bar.add(this.closeButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        String title = TITLE_DELETE;
        StringBuffer buf = new StringBuffer();
        if (ImageChecker.ImageCheckerType.CHGRP.equals((Object)this.index)) {
            ChgrpObject object = (ChgrpObject)this.action;
            GroupData group = object.getGroupData();
            StringBuffer buffer = new StringBuffer();
            buffer.append(TITLE_CHGRP);
            buffer.append(group.getName());
            title = buffer.toString();
            buf.append("Multi-image filesets cannot be split between 2 groups.");
        } else {
            buf.append("Multi-image filesets cannot be partially deleted.");
        }
        this.setTitle(title);
        TitlePanel tp = new TitlePanel(title, buf.toString(), null);
        Container c = this.getContentPane();
        c.add((Component)((Object)tp), "North");
        JPanel p = new JPanel();
        double[] size = new double[]{-1.0};
        TableLayout layout = new TableLayout();
        layout.setColumn(size);
        p.setLayout(layout);
        Iterator<MIFResultObject> i = this.result.iterator();
        int n = this.result.size();
        int index = 0;
        while (i.hasNext()) {
            layout.insertRow(index, -2.0);
            p.add((Component)this.layoutMIFResult(i.next(), n), new TableLayoutConstraints(0, index));
            ++index;
        }
        c.add((Component)p, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private JComponent layoutMIFResult(MIFResultObject object, int n) {
        StringBuffer buf;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        Map<Long, Map<Boolean, List<ImageData>>> map = object.getResult();
        Iterator<Map.Entry<Long, Map<Boolean, List<ImageData>>>> i = map.entrySet().iterator();
        String text = "You tried to move ";
        if (ImageChecker.ImageCheckerType.DELETE.equals((Object)this.index)) {
            text = "You tried to delete ";
        }
        while (i.hasNext()) {
            Map.Entry<Long, Map<Boolean, List<ImageData>>> e = i.next();
            buf = new StringBuffer();
            buf.append(text);
            JPanel row = this.createRow();
            List<ImageData> images = e.getValue().get(true);
            int size = images.size();
            buf.append(size);
            buf.append(" image");
            if (size > 1) {
                buf.append("s");
            }
            buf.append(" from a fileset, leaving ");
            List<ThumbnailData> thumbnails = object.getThumbnailsFromList(images);
            row.add(this.layoutThumbnails(images.size() - thumbnails.size(), thumbnails));
            row.add(Box.createHorizontalStrut(10));
            images = e.getValue().get(false);
            buf.append(images.size());
            buf.append(".");
            thumbnails = object.getThumbnailsFromList(images);
            row.add(this.layoutThumbnails(images.size() - thumbnails.size(), thumbnails));
            p.add(UIUtilities.buildComponentPanel(new JLabel(buf.toString())));
            p.add(row);
        }
        if (n == 1) {
            return new JScrollPane(p);
        }
        long id = object.getContext().getGroupID();
        GroupData group = this.getGroup(id);
        if (group != null) {
            text = group.getName();
        } else {
            buf = new StringBuffer();
            buf.append("Group ");
            buf.append(id);
            text = buf.toString();
        }
        JXTaskPane pane = EditorUtil.createTaskPane(text);
        pane.add((Component)new JScrollPane(p));
        return pane;
    }

    private GroupData getGroup(long groupID) {
        for (GroupData g : this.groups) {
            if (g.getId() != groupID) continue;
            return g;
        }
        return null;
    }

    private JPanel layoutThumbnails(int n, List<ThumbnailData> thumbnails) {
        JPanel row = this.createRow();
        row.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        Iterator<ThumbnailData> i = thumbnails.iterator();
        while (i.hasNext()) {
            ThumbnailLabel label = new ThumbnailLabel();
            label.setData(i.next());
            label.setToolTipText("");
            row.add(label);
        }
        if (n > 0) {
            row.add(new JLabel("..."));
        }
        return row;
    }

    private JPanel createRow() {
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0));
        return row;
    }

    public MIFNotificationDialog(JFrame owner, List<MIFResultObject> result, Object action, ImageChecker.ImageCheckerType index, Collection groups) {
        super(owner);
        if (CollectionUtils.isEmpty(result)) {
            throw new IllegalArgumentException("No result to display");
        }
        this.index = index;
        this.result = result;
        this.action = action;
        this.groups = groups;
        this.initialize();
        this.buildGUI();
        this.pack();
    }
}

