/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FilterMenuAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderControl;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderModel;
import org.openmicroscopy.shoola.agents.treeviewer.finder.PopupMenu;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;

class FinderUI
extends JPanel {
    private static final String NO_PHRASE_MSG = "Phrase not found.";
    private static final String OCCURENCES_MSG = " occurences found";
    private static final String OCCURENCE_MSG = " occurence found";
    private static final Dimension H_SPACE_DIM = new Dimension(10, 5);
    private static final int WIDTH = 100;
    private Finder finder;
    private FinderControl controller;
    private FinderModel model;
    private JTextField findArea;
    private JCheckBox caseSensitive;
    private JToolBar controlsBar;
    private JToolBar leftBar;
    private PopupMenu popupMenu;
    private JPanel infoComponent;

    private void initComponents() {
        this.createMenuBar();
        this.createLeftMenuBar();
        this.caseSensitive = new JCheckBox("Match case");
        this.caseSensitive.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                FinderUI.this.finder.setCaseSensitive(source.isSelected());
            }
        });
        this.infoComponent = new JPanel();
        this.findArea = new JTextField();
        this.findArea.setBorder(BorderFactory.createBevelBorder(1));
        this.findArea.setBackground(Color.WHITE);
        this.findArea.setOpaque(true);
        this.findArea.setEditable(true);
        int h = this.getFontMetrics(this.getFont()).getHeight() + 4;
        this.findArea.setPreferredSize(new Dimension(100, h));
        this.findArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField field;
                Object source;
                if (e.getKeyCode() == 10 && (source = e.getSource()) instanceof JTextField && (field = (JTextField)source).getText() != null && field.getText().length() > 0) {
                    FinderUI.this.finder.find();
                }
            }
        });
        this.findArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                Document d = de.getDocument();
                try {
                    FinderUI.this.finder.setTextUpdate(d.getText(0, d.getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                Document d = de.getDocument();
                try {
                    FinderUI.this.finder.setTextUpdate(d.getText(0, d.getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
            }
        });
        this.findArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object[] h;
                if (FinderUI.this.findArea.getDocument().getLength() == 0 && (h = FinderUI.this.model.getHistory()).length != 0) {
                    Rectangle r = FinderUI.this.findArea.getBounds();
                    HistoryDialog d = new HistoryDialog(h, r.width);
                    d.show(FinderUI.this.findArea, 0, r.height);
                    d.addPropertyChangeListener("selection", FinderUI.this.controller);
                }
            }
        });
    }

    private void createMenuBar() {
        this.leftBar = new JToolBar();
        this.leftBar.setBorder(null);
        this.leftBar.setRollover(true);
        this.leftBar.setFloatable(false);
        this.leftBar.add(new JButton(this.controller.getAction(FinderControl.CLOSE)));
    }

    private void createLeftMenuBar() {
        this.controlsBar = new JToolBar();
        this.controlsBar.setBorder(null);
        this.controlsBar.setRollover(true);
        this.controlsBar.setFloatable(false);
        JButton button = new JButton(this.controller.getAction(FinderControl.FIND_NEXT));
        this.controlsBar.add(button);
        button = new JButton(this.controller.getAction(FinderControl.FIND_PREVIOUS));
        this.controlsBar.add(button);
        button = new JButton(this.controller.getAction(FinderControl.HIGHLIGHT));
        button = new JButton(this.controller.getAction(FinderControl.FILTER_MENU));
        button.addMouseListener((FilterMenuAction)this.controller.getAction(FinderControl.FILTER_MENU));
        this.controlsBar.add(button);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.add(this.leftBar);
        p.add(Box.createRigidArea(H_SPACE_DIM));
        p.add(new JLabel("Find: "));
        p.add(this.findArea);
        p.add(this.controlsBar);
        p.add(this.caseSensitive);
        p.add(this.infoComponent);
        this.setLayout(new FlowLayout(0, 5, 5));
        this.add(p);
    }

    FinderUI(Finder finder, FinderControl controller, FinderModel model) {
        if (finder == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No controller.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.finder = finder;
        this.controller = controller;
        this.initComponents();
        this.popupMenu = new PopupMenu(finder);
        this.buildGUI();
    }

    void showPopup(Component c, Point p) {
        this.popupMenu.show(c, p.x, p.y);
    }

    void setMessage(int n) {
        this.infoComponent.removeAll();
        if (n == 0) {
            IconManager im = IconManager.getInstance();
            JLabel icon = new JLabel(im.getIcon(31));
            this.infoComponent.add(icon);
            JLabel label = new JLabel(NO_PHRASE_MSG);
            icon.setLabelFor(label);
            this.infoComponent.add(label);
        } else {
            IconManager im = IconManager.getInstance();
            JLabel icon = new JLabel(im.getIcon(29));
            this.infoComponent.add(icon);
            JLabel label = n > 1 ? new JLabel(n + OCCURENCES_MSG) : new JLabel(n + OCCURENCE_MSG);
            icon.setLabelFor(label);
            this.infoComponent.add(label);
        }
        this.validate();
        this.repaint();
    }

    void setTextToFind(String text) {
        this.findArea.setText(text);
    }
}

