/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.FileAnnotationCheckResult;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FileAttachmentWarningDialog
extends JDialog {
    public static final String DELETE_PROPERTY = "delete";
    private static final String TITLE = "Delete Attachments";
    private static final String MESSAGE = "These attachments are not linked to any other data, removing them means they will be permanently deleted from the data repository.";
    private JButton closeButton;
    private JButton deleteButton;
    private FileAnnotationCheckResult result;

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void delete() {
        this.firePropertyChange(DELETE_PROPERTY, null, null);
        this.close();
    }

    private void initialize() {
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileAttachmentWarningDialog.this.close();
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileAttachmentWarningDialog.this.delete();
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.deleteButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.closeButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        Icon attachIcon = IconManager.getInstance().getIcon(4);
        this.setTitle(TITLE);
        TitlePanel tp = new TitlePanel(TITLE, MESSAGE, null);
        Container c = this.getContentPane();
        c.add((Component)((Object)tp), "North");
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(0.0f);
        List<FileAnnotationData> annos = this.result.getDeleteCandidates();
        Collections.sort(annos, new FileAnnotationDataComparator());
        for (FileAnnotationData fd : annos) {
            JLabel label = new JLabel(attachIcon);
            label.setText(EditorUtil.truncate(fd.getFileName()));
            p.add(label);
        }
        p.add(Box.createVerticalGlue());
        JScrollPane sp = new JScrollPane(p);
        c.add((Component)sp, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public FileAttachmentWarningDialog(JFrame owner, FileAnnotationCheckResult result) {
        super(owner);
        if (result.getDeleteCandidates().isEmpty()) {
            throw new IllegalArgumentException("No result to display");
        }
        this.result = result;
        this.initialize();
        this.buildGUI();
        this.pack();
        this.setSize(new Dimension(400, 300));
    }

    class FileAnnotationDataComparator
    implements Comparator<FileAnnotationData> {
        FileAnnotationDataComparator() {
        }

        @Override
        public int compare(FileAnnotationData o1, FileAnnotationData o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getFileName(), o2.getFileName());
        }
    }
}

