/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnalysisDialog;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.PublishingDialog;
import org.openmicroscopy.shoola.agents.metadata.util.FilesetInfoDialog;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.ScriptSubMenu;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.util.PojosUtil;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

class ToolBar
extends JPanel {
    private static final String EXPORT_AS_OME_TIFF_TOOLTIP = "Export the image as OME-TIFF.";
    private JButton downloadButton;
    private JButton publishingButton;
    private JButton scriptsButton;
    private JButton exportAsOmeTiffButton;
    private JButton uploadScriptButton;
    private JButton saveAsButton;
    private JPopupMenu saveAsMenu;
    private JXBusyLabel busyLabel;
    private EditorControl controller;
    private EditorModel model;
    private Point location;
    private PublishingDialog publishingDialog;
    private AnalysisDialog analysisDialog;
    private JMenuItem downloadItem;
    private JMenuItem exportAsOmeTiffItem;
    private JButton viewButton;
    private JButton pathButton;
    private JButton locationButton;
    private Component component;

    private void checkBinaryAvailability() {
        if (MetadataViewerAgent.isBinaryAvailable()) {
            return;
        }
        this.downloadButton.setEnabled(false);
        this.publishingButton.setEnabled(false);
    }

    private JPopupMenu createSaveAsMenu() {
        boolean enabled;
        this.saveAsMenu = new JPopupMenu();
        IconManager icons = IconManager.getInstance();
        this.downloadItem = new JMenuItem(icons.getIcon(18));
        this.downloadItem.setToolTipText("Download the Archived File(s).");
        this.downloadItem.setText("Download...");
        this.downloadItem.addActionListener(this.controller);
        this.downloadItem.setActionCommand("4");
        this.downloadItem.setBackground(UIUtilities.BACKGROUND_COLOR);
        List<DataObject> nodes = this.model.getSelectedObjects();
        boolean b = false;
        if (!CollectionUtils.isEmpty(nodes)) {
            Iterator<DataObject> i = nodes.iterator();
            while (i.hasNext()) {
                if (!PojosUtil.isDownloadable(i.next())) continue;
                b = true;
                break;
            }
        }
        this.downloadItem.setEnabled(b);
        this.saveAsMenu.add(this.downloadItem);
        this.exportAsOmeTiffItem = new JMenuItem(icons.getIcon(72));
        this.exportAsOmeTiffItem.setText("Export as OME-TIFF...");
        this.exportAsOmeTiffItem.setToolTipText(EXPORT_AS_OME_TIFF_TOOLTIP);
        this.exportAsOmeTiffItem.addActionListener(this.controller);
        this.exportAsOmeTiffItem.setActionCommand("11");
        b = false;
        if (!this.model.isMultiSelection() && MetadataViewerAgent.canCreate()) {
            b = this.model.getRefObject() instanceof ImageData && !this.model.isLargeImage();
        }
        this.exportAsOmeTiffItem.setEnabled(b);
        this.saveAsMenu.add(this.exportAsOmeTiffItem);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Integer.parseInt(e.getActionCommand());
                ToolBar.this.controller.saveAs(index);
            }
        };
        Map<Integer, String> formats = FigureParam.FORMATS;
        Iterator<Map.Entry<Integer, String>> i = formats.entrySet().iterator();
        Object ho = this.model.getRefObject();
        boolean bl = enabled = (ho instanceof ImageData || ho instanceof WellSampleData || ho instanceof DatasetData) && this.model.isExportable();
        while (i.hasNext()) {
            Map.Entry<Integer, String> e = i.next();
            JMenuItem item = new JMenuItem(icons.getIcon(72));
            item.setText("Export as " + e.getValue() + "...");
            item.addActionListener(l);
            item.setActionCommand("" + e.getKey());
            item.setEnabled(enabled);
            this.saveAsMenu.add(item);
        }
        this.setRootObject();
        return this.saveAsMenu;
    }

    private void showViewMenu(Component source, Point p) {
        JPopupMenu menu = new JPopupMenu();
        IconManager icons = IconManager.getInstance();
        JMenuItem item = new JMenuItem(icons.getIcon(120));
        item.setText("View...");
        item.setActionCommand("22");
        item.addActionListener(this.controller);
        menu.add(item);
        item = new JMenuItem(icons.getIcon(122));
        item.setText("View in ImageJ...");
        item.setActionCommand("23");
        item.addActionListener(this.controller);
        menu.add(item);
        menu.show(source, p.x, p.y);
    }

    private void initComponents() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        IconManager icons = IconManager.getInstance();
        this.downloadButton = new JButton(icons.getIcon(18));
        this.downloadButton.setToolTipText("Download the Archived File(s).");
        this.downloadButton.addActionListener(this.controller);
        this.downloadButton.setActionCommand("4");
        this.downloadButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publishingButton = new JButton(icons.getIcon(78));
        this.publishingButton.setToolTipText("Display the publishing options.");
        this.publishingButton.setEnabled(false);
        this.publishingButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publishingButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 100);
            }
        });
        this.scriptsButton = new JButton(icons.getIcon(107));
        this.scriptsButton.setToolTipText("Display the available scripts.");
        this.scriptsButton.setEnabled(false);
        this.scriptsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.scriptsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ToolBar.this.model.getScripts() == null) {
                    ToolBar.this.location = e.getPoint();
                    ToolBar.this.scriptsButton.setEnabled(false);
                    ToolBar.this.model.loadScripts();
                    ToolBar.this.setStatus(true);
                } else {
                    ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 102);
                }
            }
        });
        this.exportAsOmeTiffButton = new JButton(icons.getIcon(72));
        this.exportAsOmeTiffButton.setEnabled(false);
        this.exportAsOmeTiffButton.setToolTipText(EXPORT_AS_OME_TIFF_TOOLTIP);
        this.exportAsOmeTiffButton.addActionListener(this.controller);
        this.exportAsOmeTiffButton.setActionCommand("11");
        this.exportAsOmeTiffButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.uploadScriptButton = new JButton(icons.getIcon(97));
        this.uploadScriptButton.setToolTipText("Upload a script to the server.");
        this.uploadScriptButton.addActionListener(this.controller);
        this.uploadScriptButton.setActionCommand("17");
        this.uploadScriptButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.saveAsButton = new JButton(icons.getIcon(72));
        this.saveAsButton.setToolTipText("Display the saving options.");
        this.saveAsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ToolBar.this.launchOptions((Component)e.getSource(), e.getPoint(), 103);
            }
        });
        this.saveAsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.viewButton = new JButton("Full Viewer");
        this.viewButton.setToolTipText("Open full viewer.");
        if (MetadataViewerAgent.runAsPlugin() == 1) {
            this.viewButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ToolBar.this.showViewMenu((Component)e.getSource(), e.getPoint());
                }
            });
        } else {
            this.viewButton.setActionCommand("22");
            this.viewButton.addActionListener(this.controller);
        }
        MouseAdapter pathLocML = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ToolBar.this.location = e.getPoint();
                ToolBar.this.component = (Component)e.getSource();
            }
        };
        this.pathButton = new JButton(icons.getIcon(123));
        this.pathButton.setToolTipText("Show file paths on server.");
        this.pathButton.addActionListener(this.controller);
        this.pathButton.setActionCommand("24");
        this.pathButton.setEnabled(this.model.isSingleMode() && this.model.getImage() != null);
        this.pathButton.addMouseListener(pathLocML);
        this.locationButton = new JButton(icons.getIcon(9));
        this.locationButton.setToolTipText("Show parent Projects & Datasets.");
        this.locationButton.addActionListener(this.controller);
        this.locationButton.setActionCommand("26");
        this.locationButton.setEnabled(this.model.isSingleMode() && this.model.getImage() != null);
        this.locationButton.addMouseListener(pathLocML);
        UIUtilities.unifiedButtonLookAndFeel(this.pathButton);
        UIUtilities.unifiedButtonLookAndFeel(this.locationButton);
        UIUtilities.unifiedButtonLookAndFeel(this.saveAsButton);
        UIUtilities.unifiedButtonLookAndFeel(this.downloadButton);
        UIUtilities.unifiedButtonLookAndFeel(this.exportAsOmeTiffButton);
        UIUtilities.unifiedButtonLookAndFeel(this.publishingButton);
        UIUtilities.unifiedButtonLookAndFeel(this.uploadScriptButton);
        UIUtilities.unifiedButtonLookAndFeel(this.scriptsButton);
        Dimension d = new Dimension(16, 16);
        this.busyLabel = new JXBusyLabel(d);
        this.busyLabel.setEnabled(true);
        this.busyLabel.setVisible(false);
    }

    private JComponent buildGeneralBar() {
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.viewButton);
        bar.add(Box.createHorizontalGlue());
        bar.add(this.publishingButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.locationButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.pathButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.saveAsButton);
        bar.add(Box.createHorizontalStrut(20));
        bar.add((Component)this.busyLabel);
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add(this.buildGeneralBar());
        this.add(new JSeparator());
    }

    private void setScriptIcon(ScriptObject so) {
        if (so.getIcon() != null) {
            return;
        }
        Icon icon = null;
        Icon largeIcon = null;
        Iterator<CustomizedFileFilter> i = EditorUtil.SCRIPTS_FILTERS.iterator();
        IconManager icons = IconManager.getInstance();
        while (i.hasNext()) {
            CustomizedFileFilter filter = i.next();
            if (!filter.accept(so.getName())) continue;
            if (filter instanceof CppFilter) {
                largeIcon = icons.getIcon(93);
                icon = icons.getIcon(89);
                break;
            }
            if (filter instanceof MatlabFilter) {
                icon = icons.getIcon(88);
                largeIcon = icons.getIcon(92);
                break;
            }
            if (filter instanceof JavaFilter) {
                icon = icons.getIcon(87);
                largeIcon = icons.getIcon(91);
                break;
            }
            if (!(filter instanceof PythonFilter)) break;
            icon = icons.getIcon(86);
            largeIcon = icons.getIcon(90);
            break;
        }
        if (icon == null) {
            icon = icons.getIcon(81);
        }
        if (largeIcon == null) {
            largeIcon = icons.getIcon(94);
        }
        so.setIcon(icon);
        so.setIconLarge(largeIcon);
    }

    private JPopupMenu getScriptsMenu() {
        JPopupMenu menu = new JPopupMenu();
        Collection<ScriptObject> scripts = this.model.getScripts();
        if (scripts == null || scripts.size() == 0) {
            return menu;
        }
        IconManager icons = IconManager.getInstance();
        JMenuItem refresh = new JMenuItem(icons.getIcon(0));
        refresh.setText("Reload Scripts");
        refresh.setToolTipText("Reloads the existing scripts.");
        refresh.addActionListener(this.controller);
        refresh.setActionCommand("18");
        menu.add(refresh);
        menu.add(new JSeparator());
        Iterator<ScriptObject> i = scripts.iterator();
        HashMap<String, ScriptSubMenu> menus = new HashMap<String, ScriptSubMenu>();
        ArrayList<ScriptSubMenu> others = new ArrayList<ScriptSubMenu>();
        ArrayList<String> formattedName = new ArrayList<String>();
        while (i.hasNext()) {
            ScriptObject so = i.next();
            this.setScriptIcon(so);
            String path = so.getPath();
            ScriptSubMenu subMenu = (ScriptSubMenu)menus.get(path);
            if (subMenu == null) {
                subMenu = new ScriptSubMenu(path, formattedName);
                menus.put(path, subMenu);
                if (so.isOfficialScript()) {
                    menu.add(subMenu);
                } else {
                    others.add(subMenu);
                }
            }
            subMenu.addScript(so).addActionListener(this.controller);
        }
        if (others.size() > 0) {
            menu.add(new JSeparator());
            JMenu uploadedMenu = new JMenu("User Scripts");
            menu.add(uploadedMenu);
            Iterator j = others.iterator();
            while (j.hasNext()) {
                uploadedMenu.add((JMenuItem)j.next());
            }
        }
        return menu;
    }

    ToolBar(EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setStatus(boolean busy) {
        this.busyLabel.setBusy(busy);
        this.busyLabel.setVisible(busy);
    }

    void buildUI() {
        this.saveAsMenu = null;
        Object refObject = this.model.getRefObject();
        this.downloadButton.setEnabled(false);
        if (this.pathButton != null) {
            this.pathButton.setEnabled(false);
        }
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            if (refObject instanceof ImageData) {
                this.downloadButton.setEnabled(this.model.isArchived());
            }
            if (this.pathButton != null) {
                this.pathButton.setEnabled(this.model.isSingleMode());
            }
        } else if (refObject instanceof FileAnnotationData) {
            this.downloadButton.setEnabled(true);
        }
        this.setRootObject();
        this.checkBinaryAvailability();
        this.revalidate();
        this.repaint();
    }

    private void setRootObject() {
        Object ref = this.model.getRefObject();
        if (ref instanceof ExperimenterData || ref instanceof GroupData) {
            this.publishingButton.setEnabled(false);
            this.scriptsButton.setEnabled(false);
            return;
        }
        this.pathButton.setEnabled(false);
        this.locationButton.setEnabled(false);
        this.viewButton.setEnabled(false);
        this.exportAsOmeTiffButton.setEnabled(false);
        if (this.model.isSingleMode()) {
            if (MetadataViewerAgent.canCreate()) {
                this.exportAsOmeTiffButton.setEnabled(this.model.getImage() != null && !this.model.isLargeImage());
            }
            this.viewButton.setEnabled(this.model.getImage() != null);
            this.pathButton.setEnabled(this.model.getImage() != null);
            this.locationButton.setEnabled(this.model.getImage() != null || this.model.getRefObject() instanceof DatasetData);
        }
        this.publishingButton.setEnabled(MetadataViewerAgent.canCreate());
        this.scriptsButton.setEnabled(MetadataViewerAgent.canCreate());
        if (this.publishingDialog != null) {
            this.publishingDialog.setRootObject();
        }
        if (this.analysisDialog != null) {
            this.analysisDialog.setRootObject();
        }
    }

    void launchOptions(Component source, Point p, int index) {
        if (!this.publishingButton.isEnabled()) {
            return;
        }
        if (p == null) {
            p = new Point(0, 0);
        }
        switch (index) {
            case 100: {
                if (this.publishingDialog == null) {
                    this.publishingDialog = new PublishingDialog(this.controller, this.model);
                }
                this.publishingDialog.show(source, p.x, p.y);
                break;
            }
            case 101: {
                if (this.analysisDialog == null) {
                    this.analysisDialog = new AnalysisDialog(this.controller, this.model);
                }
                this.analysisDialog.show(source, p.x, p.y);
                break;
            }
            case 102: {
                this.getScriptsMenu().show(source, p.x, p.y);
                break;
            }
            case 103: {
                this.createSaveAsMenu().show(source, p.x, p.y);
            }
        }
    }

    void setScripts() {
        this.scriptsButton.setEnabled(true);
        this.setStatus(false);
        this.launchOptions(this.scriptsButton, this.location, 102);
        this.location = null;
    }

    void onSizeLoaded() {
        if (this.exportAsOmeTiffItem != null) {
            boolean b = this.model.getRefObject() instanceof ImageData && !this.model.isLargeImage();
            this.exportAsOmeTiffButton.setEnabled(b);
        }
    }

    void displayFileset() {
        SwingUtilities.convertPointToScreen(this.location, this.component);
        FilesetInfoDialog d = new FilesetInfoDialog();
        d.setData(this.model.getFileset(), this.model.getImportType());
        d.pack();
        if (this.location != null) {
            this.location = new Point(this.location.x - d.getSize().width, this.location.y + 10);
        }
        d.open(this.location);
    }

    void displayLocation() {
        JComponent comp = this.model.getBrowser().getUI();
        this.model.loadParents();
        SwingUtilities.convertPointToScreen(this.location, this.component);
        TinyDialog d = new TinyDialog(null, (JComponent)new JScrollPane(comp), 1);
        d.getContentPane().setBackground(comp.getBackground());
        if (this.location != null) {
            this.location = new Point(this.location.x - 400, this.location.y + 10);
        }
        d.setLocation(this.location);
        d.setSize(new Dimension(400, 130));
        d.setResizable(true);
        d.setVisible(true);
    }
}

