/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class StructuredDataLoader
extends MetadataLoader {
    private List<DataObject> dataObjects;
    private CallHandle handle;

    public StructuredDataLoader(MetadataViewer viewer, SecurityContext ctx, List<DataObject> dataObjects, int loaderID) {
        super(viewer, ctx, null, loaderID);
        if (CollectionUtils.isEmpty(dataObjects)) {
            throw new IllegalArgumentException("No object specified.");
        }
        this.dataObjects = dataObjects;
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadStructuredData(this.ctx, this.dataObjects, -1L, false, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 4) {
            return;
        }
        this.viewer.setMetadata((Map)result, this.loaderID);
    }

    @Override
    public void handleException(Throwable exc) {
        this.handleException(exc, false);
        HashMap<DataObject, StructuredDataResults> m = new HashMap<DataObject, StructuredDataResults>();
        for (DataObject data : this.dataObjects) {
            m.put(data, new StructuredDataResults(data, false));
        }
        this.viewer.setMetadata(m, this.loaderID);
    }
}

