/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.TableResult;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.StringCellRenderer;

class ServerROITable
extends JPanel
implements ListSelectionListener {
    private static final int VISIBILITY_INDEX = 0;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private ROIResult result;
    private JTable table;
    private Map<Long, Integer> rowIDs;
    private JButton export;

    private Object roundValue(Object value) {
        if (value instanceof Double) {
            return UIUtilities.roundTwoDecimals((Double)value);
        }
        if (value instanceof Float) {
            return UIUtilities.roundTwoDecimals(((Float)value).floatValue());
        }
        return value;
    }

    private void initialize() {
        int i;
        TableResult tr = (TableResult)this.result.getResult();
        if (tr == null) {
            return;
        }
        String[] headers = tr.getHeaders();
        Object[][] data = tr.getData();
        Object[][] rows = new Object[data.length][headers.length];
        String[] columns = new String[headers.length];
        int roiIndex = tr.getColumnIndex(TableResult.ROI_COLUMN_INDEX);
        if (roiIndex < 0) {
            roiIndex = 0;
        }
        for (i = 0; i < headers.length; ++i) {
            columns[i] = i == roiIndex ? "Visible" : headers[i];
        }
        for (i = 0; i < columns.length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                if (i == roiIndex) {
                    this.rowIDs.put((Long)data[j][i], j);
                    rows[j][i] = true;
                    continue;
                }
                rows[j][i] = this.roundValue(data[j][i]);
            }
        }
        this.table = new JTable(new ServerROITableModel(rows, columns));
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellEditor(this.table.getDefaultEditor(Boolean.class));
        tc.setCellRenderer(this.table.getDefaultRenderer(Boolean.class));
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.setSelectionBackground(UIUtilities.SELECTED_BACKGROUND_COLOUR);
        this.table.setSelectionMode(2);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        StringCellRenderer renderer = new StringCellRenderer();
        for (int i2 = 0; i2 < this.table.getColumnCount(); ++i2) {
            tcm.getColumn(i2).setHeaderRenderer(renderer);
        }
        this.export = new JButton("Save To Excel");
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerROITable.this.saveTable();
            }
        });
    }

    private void saveTable() {
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        FileChooser chooser = new FileChooser(this.view, 1, "Save the Results", "Save the Results data to a file which can be loaded by a spreadsheet.", filterList);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        int choice = chooser.showDialog();
        if (choice != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getAbsolutePath().endsWith("xls")) {
            String fileName = file.getAbsolutePath() + "." + "xls";
            file = new File(fileName);
        }
        String filename = file.getAbsolutePath();
        ExcelWriter writer = new ExcelWriter(filename);
        try {
            writer.openFile();
            writer.createSheet("Measurement");
            writer.writeTableToSheet(0, 0, this.table.getModel());
            try {
                BufferedImage originalImage = this.model.getRenderedImage();
                BufferedImage image = Factory.copyBufferedImage(originalImage);
                this.model.setAttributes(MeasurementAttributes.SHOWID, true);
                this.model.getDrawingView().print(image.getGraphics());
                this.model.setAttributes(MeasurementAttributes.SHOWID, false);
                String imageName = "ROIImage";
                writer.addImageToWorkbook(imageName, image);
                int col = writer.getMaxColumn(0);
                writer.writeImage(0, col + 1, 256, 256, imageName);
            }
            catch (Exception originalImage) {
                // empty catch block
            }
            writer.close();
        }
        catch (Exception e) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Measurements", "Unable to save the measurements");
        }
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        if (this.table != null) {
            this.add((Component)new JScrollPane(this.table), "Center");
            this.add((Component)UIUtilities.buildComponentPanelRight(this.export), "South");
        }
    }

    private void handleVisibility(int row, boolean value) {
        Iterator<Map.Entry<Long, Integer>> i = this.rowIDs.entrySet().iterator();
        long id = -1L;
        while (i.hasNext()) {
            Map.Entry<Long, Integer> entry = i.next();
            if (entry.getValue() != row) continue;
            id = entry.getKey();
        }
        if (id != -1L) {
            try {
                ROI roi = this.model.getROI(id);
                TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
                for (ROIShape shape : shapes.values()) {
                    shape.getFigure().setVisible(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void scrollToRow(int row) {
        Rectangle r = this.table.getCellRect(row, 0, true);
        this.table.scrollRectToVisible(r);
    }

    ServerROITable(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.rowIDs = new HashMap<Long, Integer>();
    }

    void selectROI(List<Long> roiIDs) {
        if (roiIDs == null || roiIDs.size() == 0) {
            return;
        }
        if (this.table == null) {
            return;
        }
        Iterator<Long> i = roiIDs.iterator();
        this.table.getSelectionModel().removeListSelectionListener(this);
        int[] array = this.table.getSelectedRows();
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (array != null) {
            for (int j = 0; j < array.length; ++j) {
                l.add(array[j]);
            }
        }
        if (roiIDs.size() <= l.size()) {
            this.table.clearSelection();
        }
        while (i.hasNext()) {
            int index;
            Long id = i.next();
            if (!this.rowIDs.containsKey(id) || l.contains(index = this.rowIDs.get(id).intValue())) continue;
            this.table.addRowSelectionInterval(index, index);
            this.scrollToRow(index);
        }
        this.table.repaint();
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    void setResult(ROIResult result) {
        if (result == null) {
            throw new IllegalArgumentException("No result to display");
        }
        this.result = result;
        this.initialize();
        this.buildGUI();
    }

    String getComponentName() {
        if (this.result == null) {
            return "";
        }
        FileAnnotationData fa = this.model.getMeasurement(this.result.getFileID());
        if (fa == null) {
            return "";
        }
        return fa.getDescription();
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(3);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (!lsm.isSelectionEmpty()) {
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                indexes.add(i);
            }
        }
        Iterator<Map.Entry<Long, Integer>> i = this.rowIDs.entrySet().iterator();
        try {
            ArrayList<ROIFigure> list = new ArrayList<ROIFigure>();
            while (i.hasNext()) {
                Map.Entry<Long, Integer> entry = i.next();
                if (!indexes.contains(entry.getValue())) continue;
                ROI roi = this.model.getROI(entry.getKey());
                TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
                for (ROIShape shape : shapes.values()) {
                    list.add(shape.getFigure());
                }
            }
            this.view.setTableSelectedFigure(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    long getFileID() {
        if (this.result == null) {
            return -1L;
        }
        return this.result.getFileID();
    }

    class ServerROITableModel
    extends DefaultTableModel {
        ServerROITableModel(Object[][] rows, String[] columns) {
            super(rows, columns);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            if (col == 0) {
                ServerROITable.this.handleVisibility(row, (Boolean)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

