/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class IntensityTable
extends JTable {
    private static final int COLUMNWIDTH = 24;
    private static final Color GRIDCOLOUR = new Color(180, 213, 255);
    private int columnWidth;

    IntensityTable(TableModel model) {
        this.setModel(model);
        this.setAutoResizeMode(0);
        this.columnWidth = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int w = metrics.stringWidth(model.getColumnName(i));
            this.columnWidth = Math.max(w, 24);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            int width = this.columnWidth;
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setGridColor(GRIDCOLOUR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(true);
    }

    int getColumnWidth() {
        return this.columnWidth;
    }
}

