/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import omero.model.Length;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.ui.KeyDescription;
import org.openmicroscopy.shoola.agents.measurement.util.ui.RendererUtils;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementTableModel;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.FigureType;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ResultsCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final Icon SCRIBBLE;
    private static final Icon LINE;
    private static final Icon CONNECTION;
    private static final Icon POLYGON;
    private static final Icon POINT;
    private static final Icon RECTANGLE;
    private static final Icon ELLIPSE;
    private static final Icon TEXT;
    private static final Icon MASK;

    private JComponent makeShapeIcon(JLabel label, String shape) {
        if ("Scribble".equals(shape)) {
            label.setIcon(SCRIBBLE);
        } else if ("Line".equals(shape)) {
            label.setIcon(LINE);
        } else if ("LineConnection".equals(shape)) {
            label.setIcon(CONNECTION);
        } else if ("Polygon".equals(shape)) {
            label.setIcon(POLYGON);
        } else if ("Point".equals(shape)) {
            label.setIcon(POINT);
        } else if ("Rectangle".equals(shape)) {
            label.setIcon(RECTANGLE);
        } else if ("Ellipse".equals(shape)) {
            label.setIcon(ELLIPSE);
        } else if ("Text".equals(shape)) {
            label.setIcon(TEXT);
        } else if ("Mask".equals(shape)) {
            label.setIcon(MASK);
        } else {
            label.setText(shape);
        }
        if (label.getIcon() != null) {
            JPanel p = new JPanel();
            FlowLayout layout = new FlowLayout(1);
            layout.setVgap(0);
            p.setBorder(BorderFactory.createEmptyBorder());
            p.setLayout(layout);
            p.setOpaque(true);
            p.setBackground(this.getBackground());
            p.add(label);
            return p;
        }
        return label;
    }

    private String twoDecimalPlaces(Float value) {
        return UIUtilities.twoDecimalPlaces(value.doubleValue());
    }

    private String twoDecimalPlaces(Double value) {
        return UIUtilities.twoDecimalPlaces(value);
    }

    private JList createList(Object value) {
        List elementList = (List)value;
        JList list = new JList();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (Object element : elementList) {
            String v;
            if (element instanceof Float) {
                v = this.twoDecimalPlaces((Float)element);
                if (v == null) {
                    return list;
                }
                model.addElement(v);
                continue;
            }
            if (element instanceof Double) {
                v = this.twoDecimalPlaces((Double)element);
                if (v == null) {
                    return list;
                }
                model.addElement(v);
                continue;
            }
            if (!(element instanceof Length)) continue;
            v = this.twoDecimalPlaces(((Length)element).getValue());
            if (v == null) {
                return list;
            }
            model.addElement(v);
        }
        list.setModel(model);
        return list;
    }

    public ResultsCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent thisComponent = new JLabel();
        JLabel label = new JLabel();
        label.setOpaque(true);
        MeasurementTableModel tm = (MeasurementTableModel)table.getModel();
        KeyDescription key = tm.getColumnNames().get(column);
        String k = key.getKey();
        if (value instanceof Length) {
            MeasurementUnits units = tm.getUnitsType();
            Length n = (Length)value;
            if (!units.getUnit().equals((Object)UnitsLength.PIXEL)) {
                String s = UIUtilities.formatValue(n, AnnotationKeys.AREA.getKey().equals(k));
                if (CommonsLangUtils.isNotBlank(s)) {
                    label.setText(s);
                }
            } else {
                String s = UIUtilities.twoDecimalPlaces(n.getValue());
                if (CommonsLangUtils.isNotBlank(s)) {
                    label.setText(s);
                }
            }
            thisComponent = label;
        } else if (value instanceof FigureType || value instanceof String) {
            thisComponent = this.makeShapeIcon(label, "" + value);
        } else if (value instanceof Color) {
            label.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            label.setBackground((Color)value);
            thisComponent = label;
        } else if (value instanceof Boolean) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected((Boolean)value);
            thisComponent = checkBox;
        } else if (value instanceof ArrayList) {
            thisComponent = this.createList(value);
        } else if (value instanceof Number) {
            String s;
            if (value instanceof Integer || value instanceof Long) {
                s = "" + value;
            } else {
                s = UIUtilities.twoDecimalPlaces(((Number)value).doubleValue());
                if (s == null) {
                    s = "0";
                }
            }
            label.setText(s);
            thisComponent = label;
        } else if (value instanceof String) {
            label.setText((String)value);
            thisComponent = label;
        }
        if (!(value instanceof Color)) {
            RendererUtils.setRowColor((Component)thisComponent, table.getSelectedRow(), row);
            if (label != null) {
                label.setBackground(thisComponent.getBackground());
            }
        }
        return thisComponent;
    }

    static {
        IconManager icons = IconManager.getInstance();
        SCRIBBLE = icons.getIcon(35);
        LINE = icons.getIcon(30);
        CONNECTION = icons.getIcon(33);
        POLYGON = icons.getIcon(34);
        POINT = icons.getIcon(36);
        RECTANGLE = icons.getIcon(32);
        ELLIPSE = icons.getIcon(31);
        TEXT = icons.getIcon(37);
        MASK = icons.getIcon(42);
    }
}

