/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import omero.gateway.model.TagAnnotationData;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.LightFileImportComponent;
import org.openmicroscopy.shoola.agents.fsimporter.view.FailedImportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElement;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImporterUIElementLight
extends ImporterUIElement {
    private Map<Integer, Integer> importStatus = new ConcurrentHashMap<Integer, Integer>();
    private JProgressBar upload = new JProgressBar(0);
    private JProgressBar processed = new JProgressBar(0);
    private JXBusyLabel scanningBusy = new JXBusyLabel();
    private JXBusyLabel uploadBusy = new JXBusyLabel();
    private JXBusyLabel processedBusy = new JXBusyLabel();
    private JLabel errors = new JLabel("0");
    private JLabel cancelled = new JLabel("0");
    private JLabel cancelledLabel = new JLabel("Cancelled:");
    private Boolean isScanning = null;

    @Override
    FileImportComponentI buildComponent(ImportableFile importable, boolean browsable, boolean singleGroup, int index, Collection<TagAnnotationData> tags) {
        return new LightFileImportComponent(importable, this.getID(), this.object.getTags());
    }

    ImporterUIElementLight(ImporterControl controller, ImporterModel model, ImporterUI view, int id, int index, String name, ImportableObject object) {
        super(controller, model, view, id, index, name, object);
        this.buildGUI();
    }

    private void buildGUI() {
        this.scanningBusy.setBusy(false);
        this.upload.setBorderPainted(true);
        this.upload.setMinimum(0);
        this.upload.setStringPainted(false);
        this.processed.setBorderPainted(true);
        this.processed.setMinimum(0);
        this.processed.setStringPainted(false);
        this.uploadBusy.setBusy(false);
        this.processedBusy.setBusy(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.buildHeader(), "North");
        JPanel info = new JPanel();
        info.setOpaque(false);
        info.setBorder(new LineBorder(Color.LIGHT_GRAY));
        info.setBackground(UIUtilities.BACKGROUND);
        info.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 1280;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        info.add((Component)new JLabel("Scanning:"), c);
        c.gridx = 2;
        c.fill = 0;
        info.add((Component)this.scanningBusy, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        info.add((Component)new JLabel("Uploaded:"), c);
        c.gridx = 1;
        c.fill = 2;
        info.add((Component)this.upload, c);
        c.gridx = 2;
        c.fill = 0;
        info.add((Component)this.uploadBusy, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        info.add((Component)new JLabel("Processed:"), c);
        c.gridx = 1;
        c.fill = 2;
        info.add((Component)this.processed, c);
        c.gridx = 2;
        c.fill = 0;
        info.add((Component)this.processedBusy, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.cancelledLabel.setVisible(false);
        info.add((Component)this.cancelledLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        this.cancelled.setVisible(false);
        info.add((Component)this.cancelled, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        info.add((Component)new JLabel("Errors:"), c);
        c.gridx = 1;
        c.fill = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        info.add((Component)this.errors, c);
        this.add((Component)info, "Center");
    }

    private void updateDisplay() {
        int complete = 0;
        int uploaded = 0;
        for (int i = 1; i < 7; ++i) {
            int c = 0;
            for (int step : this.importStatus.values()) {
                if (i != step) continue;
                ++c;
            }
            uploaded += c;
            if (i != 6) continue;
            complete = c;
        }
        if (this.isScanning != null) {
            if (this.isScanning.booleanValue()) {
                this.scanningBusy.setBusy(true);
            } else {
                this.scanningBusy.setBusy(false);
                this.scanningBusy.setIcon(IconManager.getInstance().getIcon(16));
            }
        }
        int cancelled = super.cancelled();
        this.upload.setValue(uploaded);
        this.upload.setMaximum(this.totalToImport);
        this.uploadBusy.setText(uploaded + "/" + this.totalToImport);
        if (super.isDone()) {
            this.uploadBusy.setBusy(false);
            this.uploadBusy.setIcon(IconManager.getInstance().getIcon(16));
        } else {
            this.uploadBusy.setBusy(true);
        }
        this.processed.setValue(complete);
        this.processed.setMaximum(uploaded);
        this.processedBusy.setText(complete + "/" + uploaded);
        if (super.isDone()) {
            this.processedBusy.setBusy(false);
            this.processedBusy.setIcon(IconManager.getInstance().getIcon(16));
        } else {
            this.processedBusy.setBusy(true);
        }
        this.errors.setText("" + this.countFailure);
        if (cancelled > 0) {
            this.cancelledLabel.setVisible(true);
            this.cancelled.setText("" + cancelled);
            this.cancelled.setVisible(true);
        }
        if (this.countFailure > 0) {
            this.filterButton.setEnabled(true);
        }
    }

    @Override
    void showFailures() {
        JFrame f = ImporterAgent.getRegistry().getTaskBar().getFrame();
        FailedImportDialog d = new FailedImportDialog(f, this.getMarkedFiles());
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("importFilesNumber".equals(name)) {
            Integer v = (Integer)evt.getNewValue() - 1;
            this.totalToImport += v.intValue();
            this.setNumberOfImport();
        } else if ("cancelImport".equals(name)) {
            this.controller.cancel((FileImportComponentI)evt.getNewValue());
        } else if ("step".equals(name)) {
            String[] tmp = ((String)evt.getNewValue()).split("_");
            int id = Integer.parseInt(tmp[0]);
            int step = Integer.parseInt(tmp[1]);
            this.importStatus.put(id, step);
            if (this.isScanning != null && this.isScanning.booleanValue()) {
                this.isScanning = false;
            }
        } else if ("scanning".equals(name) && this.isScanning == null) {
            this.isScanning = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImporterUIElementLight.this.updateDisplay();
            }
        });
    }
}

