/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import omero.gateway.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElement;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElementDetailed;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElementLight;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPane;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImporterUI
extends TopWindow {
    private static final String TEXT_TITLE_DESCRIPTION = "Select data to import and monitor imports.";
    private static final String TEXT_TITLE = "Import Data";
    private static final String TEXT_REFRESH = "New containers added. Please Refresh";
    private static final String STYLE = "StyleName";
    private static final int MAX_CHAR = 2000;
    private ImporterModel model;
    private ImporterControl controller;
    private int total;
    private ClosableTabbedPane tabs;
    private boolean initialized;
    private int uiElementID;
    private Map<Integer, ImporterUIElement> uiElements;
    private JComponent controlsBar;
    private JXLabel messageLabel;
    private JPopupMenu personalMenu;
    private JTextPane debugTextPane;

    private JComponent createDebugTab() {
        this.debugTextPane = new JTextPane();
        this.debugTextPane.setEditable(false);
        StyledDocument doc = (StyledDocument)this.debugTextPane.getDocument();
        Style style = doc.addStyle(STYLE, null);
        StyleConstants.setForeground(style, Color.black);
        StyleConstants.setFontFamily(style, "SansSerif");
        StyleConstants.setFontSize(style, 12);
        StyleConstants.setBold(style, false);
        JScrollPane sp = new JScrollPane(this.debugTextPane);
        sp.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                try {
                    ImporterUI.this.debugTextPane.setCaretPosition(ImporterUI.this.debugTextPane.getDocument().getLength());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)sp, "Center");
        return panel;
    }

    private void initMenuItem(JMenuItem item) {
        item.setBorder(null);
    }

    private void showPersonalMenu(Component c, Point p) {
        if (p == null) {
            return;
        }
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        this.personalMenu = new JPopupMenu();
        this.personalMenu.setBorder(BorderFactory.createBevelBorder(0));
        List<GroupSelectionAction> l = this.controller.getUserGroupAction();
        Iterator<GroupSelectionAction> i = l.iterator();
        ButtonGroup buttonGroup = new ButtonGroup();
        long id = this.model.getGroupId();
        while (i.hasNext()) {
            GroupSelectionAction a = i.next();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
            item.setEnabled(true);
            item.setSelected(a.isSameGroup(id));
            this.initMenuItem(item);
            buttonGroup.add(item);
            this.personalMenu.add(item);
        }
        this.personalMenu.show(c, p.x, p.y);
    }

    private JPanel buildControls() {
        JPanel p = new JPanel();
        p.add(new JButton(this.controller.getAction(ImporterControl.RETRY_BUTTON)));
        p.add(Box.createHorizontalStrut(5));
        p.add(new JButton(this.controller.getAction(ImporterControl.SEND_BUTTON)));
        p.add(Box.createHorizontalStrut(5));
        p.add(new JButton(this.controller.getAction(ImporterControl.CANCEL_BUTTON)));
        p.add(Box.createHorizontalStrut(5));
        if (!this.model.isMaster()) {
            p.add(new JButton(this.controller.getAction(ImporterControl.CLOSE_BUTTON)));
        }
        return UIUtilities.buildComponentPanelRight(p);
    }

    private void buildGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TEXT_TITLE, "", TEXT_TITLE_DESCRIPTION, icons.getIcon(2));
        JXPanel p = new JXPanel();
        JXPanel lp = new JXPanel();
        lp.setLayout((LayoutManager)new FlowLayout(0));
        lp.add((Component)this.messageLabel);
        p.setLayout((LayoutManager)new BoxLayout((Container)p, 1));
        p.add((Component)((Object)tp));
        p.add((Component)lp);
        p.setBackgroundPainter(tp.getBackgroundPainter());
        lp.setBackgroundPainter(tp.getBackgroundPainter());
        container.add((Component)p, "North");
        container.add((Component)this.tabs, "Center");
        container.add((Component)this.controlsBar, "South");
    }

    private void display() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(6 * (screenSize.width / 10), 8 * (screenSize.height / 10));
    }

    private void initComponents() {
        this.messageLabel = new JXLabel();
        this.messageLabel.setText(TEXT_REFRESH);
        this.messageLabel.setVisible(false);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.controlsBar = this.buildControls();
        this.controlsBar.setVisible(false);
        this.uiElementID = 0;
        this.uiElements = new LinkedHashMap<Integer, ImporterUIElement>();
        this.tabs = new ClosableTabbedPane(1, 0);
        this.tabs.setAlignmentX(0.0f);
        this.tabs.addPropertyChangeListener(this.controller);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImporterUI.this.controlsBar.setVisible(ImporterUI.this.tabs.getSelectedIndex() != 0);
                ImporterUI.this.controller.getAction(ImporterControl.RETRY_BUTTON).setEnabled(ImporterUI.this.hasFailuresToReupload());
                ImporterUI.this.controller.getAction(ImporterControl.SEND_BUTTON).setEnabled(ImporterUI.this.hasFailuresToSend());
            }
        });
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.add(new JMenuItem(this.controller.getAction(ImporterControl.LOG_OFF)));
        menu.add(new JMenuItem(this.controller.getAction(ImporterControl.EXIT)));
        return menu;
    }

    private JMenuBar createMenuBar() {
        int i;
        TaskBar tb = ImporterAgent.getRegistry().getTaskBar();
        JMenuBar bar = tb.getTaskBarMenuBar();
        if (!this.model.isMaster()) {
            return bar;
        }
        JMenu[] existingMenus = new JMenu[bar.getMenuCount()];
        for (i = 0; i < existingMenus.length; ++i) {
            existingMenus[i] = bar.getMenu(i);
        }
        bar.removeAll();
        bar.add(this.createFileMenu());
        for (i = 0; i < existingMenus.length; ++i) {
            if (i == 2) continue;
            bar.add(existingMenus[i]);
        }
        return bar;
    }

    private void packWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int width = screenSize.width;
        int height = screenSize.height;
        int w = size.width - 10;
        int h = size.height - 10;
        boolean reset = false;
        if (w > width) {
            reset = true;
        }
        if (h > height) {
            reset = true;
            h = height;
        }
        if (reset) {
            this.setSize(h, h);
        }
    }

    ImporterUI() {
        super(TEXT_TITLE);
    }

    void initialize(ImporterModel model, ImporterControl controller) {
        this.model = model;
        this.controller = controller;
        this.total = 1;
        this.initComponents();
        this.setJMenuBar(this.createMenuBar());
        this.buildGUI();
        this.setName("importer window");
    }

    void showRefreshMessage(boolean show) {
        this.messageLabel.setVisible(show);
    }

    void addComponent(ImportDialog chooser) {
        if (chooser == null) {
            return;
        }
        this.tabs.insertTab("Select Data to Import", null, chooser, "", 0);
        Boolean debugEnabled = (Boolean)ImporterAgent.getRegistry().lookup("/options/Debug");
        if (debugEnabled != null && debugEnabled.booleanValue()) {
            IconManager icons = IconManager.getInstance();
            ClosableTabbedPaneComponent c = new ClosableTabbedPaneComponent(1, "Debug Text", icons.getIcon(32));
            c.setCloseVisible(false);
            c.setClosable(false);
            double[][] tl = new double[][]{{-1.0}, {-1.0}};
            c.setLayout(new TableLayout(tl));
            c.add((Component)this.createDebugTab(), "0, 0");
            this.tabs.insertClosableComponent(c);
        }
        this.selectChooser();
        this.pack();
    }

    void selectChooser() {
        this.tabs.setSelectedIndex(0);
    }

    List<FileImportComponentI> getMarkedFiles() {
        Component[] comps = this.tabs.getComponents();
        if (comps == null || comps.length == 0) {
            return null;
        }
        ArrayList<FileImportComponentI> list = new ArrayList<FileImportComponentI>();
        ImporterUIElement element = this.getSelectedPane();
        if (element == null) {
            return null;
        }
        List<FileImportComponentI> l = element.getMarkedFiles();
        if (l != null && l.size() > 0) {
            list.addAll(l);
        }
        return list;
    }

    ImporterUIElement addImporterElement(ImportableObject object) {
        if (object == null) {
            return null;
        }
        int maxFiles = (Integer)ImporterAgent.getRegistry().lookup("/options/DetailedImportFileLimit");
        int n = this.tabs.getComponentCount();
        String title = "Import #" + this.total;
        ImporterUIElement element = null;
        element = this.fileCount(object) > maxFiles ? new ImporterUIElementLight(this.controller, this.model, this, this.uiElementID, n, title, object) : new ImporterUIElementDetailed(this.controller, this.model, this, this.uiElementID, n, title, object);
        this.tabs.insertTab(title, element.getImportIcon(), element, "", this.total);
        ++this.total;
        this.uiElements.put(this.uiElementID, element);
        ++this.uiElementID;
        if (!this.isVisible()) {
            this.setVisible(true);
            this.display();
        }
        return element;
    }

    private int fileCount(ImportableObject obj) {
        int count = 0;
        for (ImportableFile f : obj.getFiles()) {
            count += this.fileCount(f.getOriginalFile().getTrueFile());
        }
        return count;
    }

    private int fileCount(File file) {
        if (file == null) {
            return 0;
        }
        if (file.isDirectory()) {
            int count = 0;
            for (File f : file.listFiles()) {
                count += this.fileCount(f);
            }
            return count;
        }
        return 1;
    }

    void reset() {
        int n = this.tabs.getTabCount();
        for (int i = 1; i < n; ++i) {
            this.tabs.remove(i);
        }
        this.uiElements.clear();
    }

    void onImportEnded(ImporterUIElement element) {
        if (element == null) {
            return;
        }
        element.onImportEnded();
        if (this.tabs.getSelectedComponent() == element) {
            this.tabs.setIconAt(this.tabs.getSelectedIndex(), element.getImportIcon());
        } else {
            Component[] components = this.tabs.getComponents();
            int index = -1;
            for (int i = 0; i < components.length; ++i) {
                if (components[i] != element) continue;
                index = i;
            }
            if (index >= 0) {
                this.tabs.setIconAt(index, element.getImportIcon());
            }
        }
    }

    void setSelectedPane(ImporterUIElement element, boolean startImport) {
        int n = this.tabs.getComponentCount();
        if (n == 0 || element == null) {
            return;
        }
        Component[] components = this.tabs.getComponents();
        int index = -1;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != element) continue;
            index = i;
            this.tabs.setSelectedComponent(element);
        }
        if (startImport) {
            Icon icon = element.startImport(this.tabs);
            if (index >= 0) {
                this.tabs.setIconAt(index, icon);
            }
        }
    }

    ImporterUIElement getSelectedPane() {
        if (this.tabs.getSelectedIndex() > 0 && this.tabs.getSelectedComponent() instanceof ImporterUIElement) {
            return (ImporterUIElement)this.tabs.getSelectedComponent();
        }
        return null;
    }

    ImporterUIElement getUIElement(int index) {
        return this.uiElements.get(index);
    }

    ImporterUIElement getElementToStartImportFor() {
        if (this.uiElements.size() == 0) {
            return null;
        }
        for (ImporterUIElement element : this.uiElements.values()) {
            if (element.hasStarted()) continue;
            return element;
        }
        return null;
    }

    ImporterUIElement removeImportElement(Object object) {
        Iterator<ImporterUIElement> i = this.uiElements.values().iterator();
        ImporterUIElement found = null;
        while (i.hasNext()) {
            ImporterUIElement element = i.next();
            if (element != object) continue;
            found = element;
            break;
        }
        if (found != null) {
            this.uiElements.remove(found.getID());
        }
        return found;
    }

    Collection<ImporterUIElement> getImportElements() {
        return this.uiElements.values();
    }

    boolean hasOnGoingImportFor(SecurityContext ctx) {
        Collection<ImporterUIElement> values = this.uiElements.values();
        for (ImporterUIElement elt : values) {
            ImportableObject data = elt.getData();
            List<ImportableFile> files = data.getFiles();
            if (!CollectionUtils.isNotEmpty(files) || elt.isDone()) continue;
            for (ImportableFile f : files) {
                if (f.getGroup().getId() != ctx.getGroupID()) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasFailuresToSend() {
        ImporterUIElement element = this.getSelectedPane();
        if (element == null) {
            return false;
        }
        return element.hasFailuresToSend();
    }

    void showMenu(int menuID, Component c, Point p) {
        switch (menuID) {
            case 100: {
                this.showPersonalMenu(c, p);
            }
        }
    }

    boolean isMaster() {
        return this.model.isMaster();
    }

    void appendDebugText(String text) {
        if (this.debugTextPane == null) {
            return;
        }
        StyledDocument doc = (StyledDocument)this.debugTextPane.getDocument();
        try {
            doc.insertString(doc.getLength(), text, doc.getStyle(STYLE));
            if (doc.getLength() > 2000) {
                doc.remove(0, doc.getLength() - 2000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    List<FileImportComponentI> getFilesToReimport() {
        ImporterUIElement pane = this.getSelectedPane();
        if (pane == null) {
            return null;
        }
        return pane.getFilesToReupload();
    }

    boolean hasFailuresToReupload() {
        ImporterUIElement element = this.getSelectedPane();
        if (element == null) {
            return false;
        }
        return element.hasFailuresToReupload();
    }

    @Override
    public void setOnScreen() {
        this.packWindow();
        UIUtilities.centerAndShow(this);
    }
}

