/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.importer.ImportStatusEvent;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportLocationSettings;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ObjectToCreate;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImportLocationDetails;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElement;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.LogOff;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class ImporterComponent
extends AbstractComponent
implements Importer {
    private static final String CANCEL_TEXT = "Are you sure you want to cancel all imports that have not yet started?";
    private static final String CANCEL_TITLE = "Cancel Import";
    private static final int MAX_SIZE = 4000000;
    private ImporterModel model;
    private ImporterControl controller;
    private ImporterUI view;
    private ImportDialog chooser;
    private boolean markToclose;

    private void handleCompletion(ImporterUIElement element, Object result, boolean startUpload) {
        boolean refreshTree = false;
        if (result instanceof Boolean) {
            result = null;
        }
        List<DataObject> containers = null;
        if (element != null) {
            if (element.isDone()) {
                refreshTree = element.hasToRefreshTree();
                containers = element.getExistingContainers();
                this.model.importCompleted(element.getID());
                this.view.onImportEnded(element);
            }
            if (this.markToclose) {
                this.view.setVisible(false);
            } else if (element.isUploadComplete() && (element = this.view.getElementToStartImportFor()) != null && startUpload) {
                element.setUploadStarted(true);
                this.importData(element);
            }
            this.fireStateChange();
        }
        if (!this.controller.isMaster()) {
            EventBus bus = ImporterAgent.getRegistry().getEventBus();
            ImportStatusEvent e = new ImportStatusEvent(this.hasOnGoingImport(), containers, result);
            e.setToRefresh(refreshTree);
            bus.post(e);
        }
        if (!this.hasOnGoingImport() && this.chooser.reloadHierarchies() && !this.markToclose) {
            Class<ProjectData> rootType = ProjectData.class;
            if (this.chooser != null && this.chooser.getType() == 1) {
                rootType = ScreenData.class;
            }
            this.model.fireContainerLoading(rootType, true, false, null);
            this.fireStateChange();
        }
    }

    private void importData(ImporterUIElement element) {
        if (element == null) {
            return;
        }
        this.view.setSelectedPane(element, true);
        this.model.fireImportData(element.getData(), element.getID());
    }

    ImporterComponent(ImporterModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ImporterControl(this);
        this.view = new ImporterUI();
        this.markToclose = false;
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    boolean hasOnGoingImport(SecurityContext ctx) {
        if (this.model.getState() != 3) {
            return this.view.hasOnGoingImportFor(ctx);
        }
        return false;
    }

    void resetGroup(long groupID) {
        this.model.setGroupId(groupID);
    }

    void onGroupSwitched(boolean success) {
        if (!this.model.isMaster()) {
            return;
        }
        if (!success) {
            return;
        }
        ExperimenterData exp = ImporterAgent.getUserDetails();
        GroupData group = exp.getDefaultGroup();
        long oldGroup = this.model.getGroupId();
        this.model.setGroupId(group.getId());
        ImportLocationDetails details = new ImportLocationDetails(this.chooser.getType());
        this.refreshContainers(details);
        this.firePropertyChange("changedGroup", oldGroup, this.model.getGroupId());
    }

    void shutDown() {
        this.view.setVisible(false);
        this.discard();
        this.model.setState(1);
    }

    void setDisplayMode(int displayMode) {
    }

    void onReconnected() {
        ExperimenterData exp = ImporterAgent.getUserDetails();
        GroupData group = exp.getDefaultGroup();
        long oldGroup = -1L;
        if (this.model.getExperimenterId() == exp.getId() && group.getId() == this.model.getGroupId()) {
            return;
        }
        this.view.reset();
        this.model.setGroupId(group.getId());
        ImportLocationDetails info = new ImportLocationDetails(this.chooser.getType());
        this.refreshContainers(info);
        this.firePropertyChange("changedGroup", oldGroup, this.model.getGroupId());
    }

    private Collection<GroupData> loadGroups() {
        Collection set = ImporterAgent.getAvailableUserGroups();
        if (set == null || set.size() <= 1) {
            return null;
        }
        ViewerSorter sorter = new ViewerSorter();
        List sortedGroups = sorter.sort(set);
        return sortedGroups;
    }

    private void activate(int type, TreeImageDisplay selectedContainer, Collection<TreeImageDisplay> objects, long userId, boolean display) {
        if (this.model.getState() == 3) {
            return;
        }
        boolean reactivate = this.chooser != null;
        this.model.setImportFor(userId);
        if (this.chooser == null) {
            this.chooser = new ImportDialog(this.view, this.model.getSupportedFormats(), selectedContainer, objects, type, this.controller.getAction(ImporterControl.CANCEL_BUTTON), this);
            this.chooser.addPropertyChangeListener(this.controller);
            this.view.addComponent(this.chooser);
        } else {
            this.chooser.reset(selectedContainer, objects, type, this.model.getGroupId(), this.model.getImportFor());
            this.chooser.requestFocusInWindow();
            this.view.selectChooser();
        }
        this.chooser.setSelectedGroup(this.getSelectedGroup());
        if (this.model.isMaster() || CollectionUtils.isEmpty(objects) || !reactivate) {
            this.refreshContainers(new ImportLocationDetails(type));
        }
        this.model.fireDiskSpaceLoading();
        if (display) {
            this.view.setOnScreen();
            this.view.toFront();
        }
    }

    @Override
    public void activate(int type, TreeImageDisplay selectedContainer, Collection<TreeImageDisplay> objects, long userId) {
        this.activate(type, selectedContainer, objects, userId, true);
    }

    @Override
    public JFrame getView() {
        return this.view;
    }

    @Override
    public void discard() {
        if (this.model.getState() != 4 && this.model.getState() != 3) {
            this.view.close();
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void importData(ImportableObject data) {
        if (this.model.getState() == 3) {
            return;
        }
        if (data == null || CollectionUtils.isEmpty(data.getFiles())) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "No Files to import.");
            return;
        }
        this.view.showRefreshMessage(this.chooser.isRefreshLocation());
        if (data.hasNewTags()) {
            this.model.setTags(null);
        }
        ImporterUIElement element = this.view.addImporterElement(data);
        Collection<ImporterUIElement> list = this.view.getImportElements();
        Iterator<ImporterUIElement> i = list.iterator();
        boolean canImport = true;
        while (i.hasNext()) {
            ImporterUIElement e = i.next();
            if (!e.hasStarted() || e.isUploadComplete()) continue;
            canImport = false;
            break;
        }
        if (!canImport) {
            return;
        }
        this.importData(element);
        if (!this.controller.isMaster()) {
            EventBus bus = ImporterAgent.getRegistry().getEventBus();
            ImportStatusEvent event = new ImportStatusEvent(this.hasOnGoingImport(), null, null);
            bus.post(event);
        }
    }

    @Override
    public void uploadComplete(ImportableFile f, Object result, int index) {
        if (this.model.getState() == 3) {
            return;
        }
        ImporterUIElement element = this.view.getUIElement(index);
        if (element != null) {
            Object formattedResult = element.uploadComplete(f, result);
            this.handleCompletion(element, formattedResult, true);
        }
    }

    @Override
    public void setExistingTags(Collection tags) {
        if (this.model.getState() == 3) {
            return;
        }
        this.model.setTags(tags);
        if (this.chooser != null) {
            this.chooser.setTags(tags);
        }
    }

    @Override
    public void loadExistingTags() {
        if (this.model.getState() == 3) {
            return;
        }
        Collection tags = this.model.getTags();
        if (tags != null) {
            this.setExistingTags(tags);
        } else {
            this.model.fireTagsLoading();
        }
    }

    @Override
    public void submitFiles() {
        this.controller.submitFiles(null);
    }

    @Override
    public void removeImportElement(Object object) {
        if (this.model.getState() == 3 || object == null) {
            return;
        }
        ImporterUIElement element = this.view.removeImportElement(object);
        if (element != null) {
            element.cancelLoading();
            this.model.cancel(element.getID());
            this.fireStateChange();
        }
    }

    @Override
    public void cancel() {
        if (this.model.getState() != 3) {
            this.model.cancel();
        }
    }

    @Override
    public void cancelImport(int id) {
    }

    @Override
    public boolean hasFailuresToSend() {
        if (this.model.getState() == 3 || this.model.getState() == 4) {
            return false;
        }
        return this.view.hasFailuresToSend();
    }

    @Override
    public boolean hasFailuresToReupload() {
        if (this.model.getState() == 3) {
            return false;
        }
        return this.view.hasFailuresToReupload();
    }

    @Override
    public void setDiskSpace(DiskQuota quota) {
        if (quota == null) {
            return;
        }
        if (this.model.getState() == 3) {
            return;
        }
        if (this.chooser != null && this.chooser.isVisible()) {
            this.chooser.setDiskSpace(quota);
        }
    }

    @Override
    public void close() {
        if (this.model.isMaster()) {
            EventBus bus = ImporterAgent.getRegistry().getEventBus();
            bus.post(new ExitApplication());
            return;
        }
        this.view.setVisible(false);
    }

    @Override
    public void retryUpload(FileImportComponentI fc) {
        List<FileImportComponentI> l;
        if (this.model.getState() == 3) {
            return;
        }
        ImporterUIElement element = this.view.getSelectedPane();
        if (element == null) {
            return;
        }
        if (fc != null) {
            l = new ArrayList<FileImportComponentI>(1);
            l.add(fc);
        } else {
            l = element.getFilesToReupload();
        }
        if (CollectionUtils.isEmpty(l)) {
            return;
        }
        Iterator<FileImportComponentI> i = l.iterator();
        ImportableObject object = element.getData();
        ArrayList<ImportableFile> list = new ArrayList<ImportableFile>();
        while (i.hasNext()) {
            fc = i.next();
            fc.setReimported(true);
            list.add(fc.getImportableFile());
        }
        object.reUpload(list);
        this.importData(object);
    }

    @Override
    public boolean isLastImport() {
        ImporterUIElement element = this.view.getSelectedPane();
        if (element == null) {
            return false;
        }
        return element.isLastImport();
    }

    @Override
    public boolean hasOnGoingImport() {
        if (this.model.getState() != 3) {
            Collection<ImporterUIElement> list = this.view.getImportElements();
            if (list == null || list.size() == 0) {
                return false;
            }
            for (ImporterUIElement element : list) {
                if (element.isDone()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void refreshContainers(ImportLocationDetails details) {
        if (details == null) {
            return;
        }
        switch (this.model.getState()) {
            case 3: {
                return;
            }
        }
        this.view.showRefreshMessage(false);
        Class<ProjectData> rootType = ProjectData.class;
        if (details.getDataType() == 1L) {
            rootType = ScreenData.class;
        }
        this.model.fireContainerLoading(rootType, false, false, details.getUser());
    }

    @Override
    public void setContainers(Collection result, boolean refreshImport, boolean changeGroup, int type, long userID) {
        switch (this.model.getState()) {
            case 3: {
                return;
            }
        }
        this.model.setState(2);
        if (this.chooser == null) {
            return;
        }
        Set<TreeImageDisplay> nodes = TreeViewerTranslator.transformHierarchy(result);
        this.chooser.reset(nodes, type, this.model.getGroupId(), userID);
        if (refreshImport) {
            Collection<ImporterUIElement> l = this.view.getImportElements();
            for (ImporterUIElement element : l) {
                if (element.isDone()) continue;
                element.resetContainers(result);
            }
        }
    }

    @Override
    public void cancelAllImports() {
        if (this.model.getState() != 3) {
            Collection<ImporterUIElement> list = this.view.getImportElements();
            ArrayList<ImporterUIElement> toImport = new ArrayList<ImporterUIElement>();
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            for (ImporterUIElement element : list) {
                toImport.add(element);
            }
            if (toImport.size() > 0) {
                Iterator<ImporterUIElement> i = toImport.iterator();
                while (i.hasNext()) {
                    i.next().cancelLoading();
                }
            }
        }
    }

    @Override
    public void moveToFront() {
        if (this.model.getState() == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (!this.view.isVisible()) {
            this.view.setVisible(true);
        }
        this.view.toFront();
    }

    @Override
    public void onDataObjectSaved(DataObject d, DataObject parent) {
        if (this.chooser == null) {
            return;
        }
        this.chooser.onDataObjectSaved(d, parent);
    }

    @Override
    public void createDataObject(ObjectToCreate data) {
        if (data == null) {
            throw new IllegalArgumentException("No object to create.");
        }
        this.model.fireDataCreation(data);
        this.fireStateChange();
    }

    @Override
    public GroupData getSelectedGroup() {
        Collection<GroupData> m = this.loadGroups();
        if (m == null) {
            ExperimenterData exp = ImporterAgent.getUserDetails();
            return exp.getDefaultGroup();
        }
        long id = this.model.getGroupId();
        for (GroupData group : m) {
            if (group.getId() != id) continue;
            return group;
        }
        ExperimenterData exp = ImporterAgent.getUserDetails();
        return exp.getDefaultGroup();
    }

    @Override
    public void showMenu(int menuId, Component source, Point point) {
        if (this.model.getState() == 3) {
            return;
        }
        this.view.showMenu(menuId, source, point);
    }

    @Override
    public void setUserGroup(GroupData group) {
        switch (this.model.getState()) {
            case 3: {
                return;
            }
        }
        if (group == null) {
            return;
        }
        long oldId = this.model.getGroupId();
        if (group.getId() == oldId) {
            return;
        }
        this.model.setGroupId(group.getId());
        this.chooser.setSelectedGroup(this.getSelectedGroup());
        this.view.showRefreshMessage(false);
        Class<ProjectData> rootType = ProjectData.class;
        if (this.chooser.getType() == 1) {
            rootType = ScreenData.class;
        }
        this.model.fireContainerLoading(rootType, false, true, null);
        this.firePropertyChange("changedGroup", oldId, group.getId());
    }

    @Override
    public void setImportLogFile(Collection<FileAnnotationData> collection, long fileSetID, int index) {
        if (this.model.getState() == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Collection<ImporterUIElement> list = this.view.getImportElements();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (ImporterUIElement element : list) {
            if (element.getID() != index) continue;
            element.setImportLogFile(collection, index);
            break;
        }
    }

    @Override
    public void logOff() {
        if (this.model.getState() == 4) {
            return;
        }
        Registry reg = ImporterAgent.getRegistry();
        reg.getEventBus().post(new LogOff());
    }

    @Override
    public boolean isMaster() {
        return this.model.isMaster();
    }

    @Override
    public int getDisplayMode() {
        return this.model.getDisplayMode();
    }

    @Override
    public boolean hasOnGoingUpload() {
        if (this.model.getState() != 3) {
            Collection<ImporterUIElement> list = this.view.getImportElements();
            if (list == null || list.size() == 0) {
                return false;
            }
            for (ImporterUIElement element : list) {
                if (element.isUploadComplete()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onImportComplete(FileImportComponentI component) {
        if (component == null || this.model.getState() == 3) {
            return;
        }
        ImporterUIElement element = this.view.getUIElement(component.getIndex());
        if (element == null) {
            return;
        }
        Object result = component.getImportResult();
        if (result instanceof Exception) {
            if (component.getFile().isFile()) {
                ImportErrorObject r = new ImportErrorObject(component.getFile().getTrueFile(), (Exception)result, component.getGroupID());
                element.setImportResult(component, result);
                this.handleCompletion(element, r, !component.hasParent());
            }
            return;
        }
        element.setImportResult(component, result);
        this.handleCompletion(element, result, !component.hasParent());
        Collection pixels = (Collection)result;
        if (CollectionUtils.isEmpty((Collection)pixels)) {
            return;
        }
        List<Object> l = new ArrayList<DataObject>();
        Iterator i = pixels.iterator();
        Class<ThumbnailData> klass = ThumbnailData.class;
        if (component.isHCS()) {
            klass = PlateData.class;
        }
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        while (i.hasNext()) {
            PixelsData pxd = (PixelsData)i.next();
            ids.add(pxd.getImage());
            pxd.getImage().getId();
            if (pxd.getSizeX() * pxd.getSizeY() >= 4000000) continue;
            l.add((DataObject)pxd);
        }
        this.model.saveROI(component, ids);
        if (l.size() > 0 && !PlateData.class.equals(klass)) {
            if (l.size() > 3) {
                l = l.subList(0, 3);
            }
            this.model.fireImportResultLoading(l, klass, component, component.getImportableFile().getUser());
        }
    }

    @Override
    public void onUploadComplete(FileImportComponentI component) {
        if (this.model.getState() == 3) {
            return;
        }
        if (component == null || this.model.getState() == 3) {
            return;
        }
        ImporterUIElement element = this.view.getUIElement(component.getIndex());
        if (element == null) {
            return;
        }
        Object result = component.getImportResult();
        Object formattedResult = element.uploadComplete(component, result);
        if (!this.controller.isMaster()) {
            EventBus bus = ImporterAgent.getRegistry().getEventBus();
            ImportStatusEvent e = new ImportStatusEvent(this.hasOnGoingImport(), null, formattedResult);
            bus.post(e);
        }
    }

    @Override
    public void setImportResult(Object result, Object component) {
        if (component == null || this.model.getState() == 3) {
            return;
        }
        FileImportComponentI c = (FileImportComponentI)component;
        ImporterUIElement element = this.view.getUIElement(c.getIndex());
        if (element == null) {
            return;
        }
        c.setStatus(result);
    }

    @Override
    public long getImportFor() {
        return this.model.getImportFor();
    }

    @Override
    public boolean canImportAs() {
        return this.model.canImportAs();
    }

    @Override
    public Collection<GroupData> getAvailableGroups() {
        return this.model.getAvailableGroups();
    }

    @Override
    public boolean isSystemGroup(long groupID, String key) {
        return this.model.isSystemGroup(groupID, key);
    }

    @Override
    public void importResults(ResultsObject object, boolean importImage) {
        if (object == null) {
            return;
        }
        if (importImage) {
            this.activate(0, null, null, this.getImportFor(), false);
            this.model.setResultsObject(object);
            List<Object> files = object.getRefObjects();
            ImportLocationSettings settings = this.chooser.createLocationDialog();
            if (settings != null) {
                this.view.setOnScreen();
                this.view.toFront();
                this.chooser.addImageJFiles(files, settings);
                this.chooser.importFiles();
            }
        }
    }
}

