/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import omero.gateway.model.ExperimenterData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ActivatedUserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.MoveToAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

class PopupMenu
extends JPopupMenu {
    private JMenuItem view;
    private JMenuItem cutElement;
    private JMenuItem copyElement;
    private JMenuItem pasteElement;
    private JMenuItem removeElement;
    private JMenuItem pasteRndSettings;
    private JMenuItem resetRndSettings;
    private JMenuItem copyRndSettings;
    private JMenuItem setOwnerRndSettings;
    private JMenuItem tagElement;
    private JMenu openWithMenu;
    private JMenuItem resetPassword;
    private JMenuItem download;
    private JCheckBoxMenuItem activatedUser;
    private DataBrowserControl controller;
    private DataBrowserModel model;

    private JMenu createMoveToMenu() {
        List<MoveToAction> actions = this.controller.getMoveAction();
        if (CollectionUtils.isEmpty(actions)) {
            return null;
        }
        JMenu menu = new JMenu("Move to");
        Iterator<MoveToAction> i = actions.iterator();
        while (i.hasNext()) {
            menu.add(new JMenuItem(i.next()));
        }
        return menu;
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.resetPassword = new JMenuItem(this.controller.getAction(DataBrowserControl.RESET_PASSWORD));
        ActivatedUserAction a = (ActivatedUserAction)this.controller.getAction(DataBrowserControl.USER_ACTIVATED);
        this.activatedUser = new JCheckBoxMenuItem();
        ImageDisplay node = this.model.getBrowser().getLastSelectedDisplay();
        boolean value = false;
        if (node != null) {
            Object o = node.getHierarchyObject();
            if (o instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)o;
                ExperimenterData loggedIn = this.model.getCurrentUser();
                value = exp.getId() == loggedIn.getId();
                this.activatedUser.setSelected(exp.isActive());
                if (exp.isActive()) {
                    this.activatedUser.setIcon(ActivatedUserAction.ACTIVATED_ICON);
                } else {
                    this.activatedUser.setIcon(ActivatedUserAction.NOT_ACTIVATED_ICON);
                }
                this.activatedUser.setEnabled(!value && !this.model.isSystemUser(exp.getId()));
            }
            if (!value) {
                this.activatedUser.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        PopupMenu.this.controller.activateUser();
                    }
                });
            }
        } else {
            this.activatedUser.setEnabled(false);
        }
        this.activatedUser.setAction(a);
        this.tagElement = new JMenuItem(this.controller.getAction(DataBrowserControl.TAG));
        this.view = new JMenuItem(this.controller.getAction(DataBrowserControl.VIEW));
        this.download = new JMenuItem(this.controller.getAction(DataBrowserControl.DOWNLOAD));
        this.copyElement = new JMenuItem(this.controller.getAction(DataBrowserControl.COPY_OBJECT));
        this.cutElement = new JMenuItem(this.controller.getAction(DataBrowserControl.CUT_OBJECT));
        this.pasteElement = new JMenuItem(this.controller.getAction(DataBrowserControl.PASTE_OBJECT));
        this.removeElement = new JMenuItem(this.controller.getAction(DataBrowserControl.REMOVE_OBJECT));
        this.pasteRndSettings = new JMenuItem(this.controller.getAction(DataBrowserControl.PASTE_RND_SETTINGS));
        this.resetRndSettings = new JMenuItem(this.controller.getAction(DataBrowserControl.RESET_RND_SETTINGS));
        this.copyRndSettings = new JMenuItem(this.controller.getAction(DataBrowserControl.COPY_RND_SETTINGS));
        this.setOwnerRndSettings = new JMenuItem(this.controller.getAction(DataBrowserControl.SET_OWNER_RND_SETTINGS));
        this.openWithMenu = new JMenu("Open with");
        this.openWithMenu.setIcon(icons.getIcon(26));
        if (this.model.getType() == 3) {
            this.copyElement.setEnabled(false);
            this.pasteElement.setEnabled(false);
            this.cutElement.setEnabled(false);
        }
    }

    private JMenu buildEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.add(this.cutElement);
        menu.add(this.copyElement);
        menu.add(this.pasteElement);
        return menu;
    }

    private JMenu buildRenderingSettingsMenu() {
        JMenu menu = new JMenu("Rendering Settings");
        menu.add(this.copyRndSettings);
        menu.add(this.pasteRndSettings);
        menu.add(this.resetRndSettings);
        menu.add(this.setOwnerRndSettings);
        return menu;
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        if (this.model.getType() == 8) {
            this.add(this.resetPassword);
            this.add(this.activatedUser);
            this.add(this.buildEditMenu());
            this.add(this.removeElement);
        } else {
            String text = "View";
            switch (DataBrowserAgent.runAsPlugin()) {
                case 1: 
                case 3: {
                    JMenu menu = new JMenu(text);
                    menu.setIcon(this.view.getIcon());
                    menu.add(this.view);
                    menu.add(this.controller.getAction(DataBrowserControl.VIEW_IN_IJ));
                    this.add(menu);
                    break;
                }
                case 2: {
                    JMenu menu = new JMenu(text);
                    menu.setIcon(this.view.getIcon());
                    menu.add(this.view);
                    menu.add(this.controller.getAction(DataBrowserControl.VIEW_IN_KNIME));
                    this.add(menu);
                    break;
                }
                default: {
                    this.add(this.view);
                }
            }
            this.add(this.openWithMenu);
            this.add(this.download);
            this.add(new JSeparator(0));
            this.add(this.buildEditMenu());
            this.add(this.removeElement);
            JMenu m = this.createMoveToMenu();
            if (m != null) {
                this.add(m);
            }
            this.add(new JSeparator(0));
            this.add(this.tagElement);
            this.add(new JSeparator(0));
            this.add(this.buildRenderingSettingsMenu());
        }
    }

    PopupMenu(DataBrowserControl controller, DataBrowserModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void populateOpenWith() {
        this.openWithMenu.removeAll();
        List<ViewOtherAction> actions = this.controller.getApplicationActions();
        if (!CollectionUtils.isEmpty(actions)) {
            Iterator<ViewOtherAction> i = actions.iterator();
            while (i.hasNext()) {
                this.openWithMenu.add(new JMenuItem(i.next()));
            }
            this.openWithMenu.add(new JSeparator());
        }
        this.openWithMenu.add(new JMenuItem(this.controller.getAction(DataBrowserControl.OPEN_WITH)));
    }
}

