/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ActivatedUserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DownloadAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ManageObjectAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.MoveToAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.PasswordResetAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.SaveAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.SendFeedbackAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.TaggingAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewInPluginAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailManager;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.util.ui.PlateGridObject;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;

class DataBrowserControl
implements PropertyChangeListener {
    static final Integer VIEW = 0;
    static final Integer COPY_OBJECT = 1;
    static final Integer PASTE_OBJECT = 2;
    static final Integer REMOVE_OBJECT = 3;
    static final Integer CUT_OBJECT = 4;
    static final Integer PASTE_RND_SETTINGS = 5;
    static final Integer COPY_RND_SETTINGS = 6;
    static final Integer RESET_RND_SETTINGS = 7;
    static final Integer SET_MIN_MAX_SETTINGS = 8;
    static final Integer REFRESH = 9;
    static final Integer SAVE_AS = 10;
    static final Integer TAG = 11;
    static final Integer OPEN_WITH = 14;
    static final Integer SET_OWNER_RND_SETTINGS = 15;
    static final Integer SEND_FEEDBACK = 16;
    static final Integer VIEW_IN_IJ = 17;
    static final Integer VIEW_IN_KNIME = 18;
    static final Integer RESET_PASSWORD = 19;
    static final Integer USER_ACTIVATED = 20;
    static final Integer DOWNLOAD = 21;
    private DataBrowser model;
    private DataBrowserUI view;
    private Map<Integer, Action> actionsMap;
    private List<MoveToAction> moveActions;

    private void createActions() {
        this.actionsMap.put(VIEW_IN_KNIME, new ViewInPluginAction(this.model, 2));
        this.actionsMap.put(VIEW_IN_IJ, new ViewInPluginAction(this.model, 1));
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new ManageObjectAction(this.model, 0));
        this.actionsMap.put(PASTE_OBJECT, new ManageObjectAction(this.model, 1));
        this.actionsMap.put(REMOVE_OBJECT, new ManageObjectAction(this.model, 2));
        this.actionsMap.put(CUT_OBJECT, new ManageObjectAction(this.model, 3));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(SET_MIN_MAX_SETTINGS, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SAVE_AS, new SaveAction(this.model));
        this.actionsMap.put(TAG, new TaggingAction(this.model));
        this.actionsMap.put(OPEN_WITH, new ViewOtherAction(this.model, null));
        this.actionsMap.put(SEND_FEEDBACK, new SendFeedbackAction(this.model));
        this.actionsMap.put(USER_ACTIVATED, new ActivatedUserAction(this.model));
        this.actionsMap.put(RESET_PASSWORD, new PasswordResetAction(this.model));
        this.actionsMap.put(DOWNLOAD, new DownloadAction(this.model));
    }

    private void filterNodes(SearchObject filter) {
        if (filter == null) {
            return;
        }
        List<String> values = filter.getResult();
        switch (filter.getIndex()) {
            case 2: {
                this.view.setFilterLabel("Name");
                if (!CollectionUtils.isEmpty(values)) {
                    this.model.filterByFullText(values);
                    break;
                }
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 0: {
                this.view.setFilterLabel("Tags");
                if (!CollectionUtils.isEmpty(values)) {
                    this.model.filterByTags(values);
                    break;
                }
                this.showAll();
                break;
            }
            case 1: {
                this.view.setFilterLabel("Comments");
                if (!CollectionUtils.isEmpty(values)) {
                    this.model.filterByComments(values);
                    break;
                }
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 3: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(1);
                break;
            }
            case 4: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(2);
                break;
            }
            case 5: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(3);
                break;
            }
            case 6: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(4);
                break;
            }
            case 7: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(5);
                break;
            }
            case 8: {
                this.view.setFilterLabel("Unrated");
                this.model.filterByRate(0);
                break;
            }
            case 9: {
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 12: {
                this.view.setFilterLabel("Tagged");
                this.model.filterByTagged(true);
                break;
            }
            case 10: {
                this.view.setFilterLabel("Untagged");
                this.model.filterByTagged(false);
                break;
            }
            case 13: {
                this.view.setFilterLabel("Commented");
                this.model.filterByCommented(true);
                break;
            }
            case 11: {
                this.view.setFilterLabel("Uncommented");
                this.model.filterByCommented(false);
                break;
            }
            case 14: {
                this.view.setFilterLabel("Has ROIs");
                this.model.filterByROIs(true);
                break;
            }
            case 15: {
                this.view.setFilterLabel("No ROIs");
                this.model.filterByROIs(false);
            }
        }
    }

    private void showAll() {
        this.view.setFilterLabel("");
        this.model.showAll();
    }

    DataBrowserControl() {
    }

    void initialize(DataBrowser model, DataBrowserUI view) {
        if (view == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    List<MoveToAction> getMoveAction() {
        Browser browser = this.model.getBrowser();
        Collection<DataObject> selection = null;
        ArrayList<Long> owners = new ArrayList<Long>();
        if (browser != null) {
            selection = browser.getSelectedDataObjects();
            if (selection == null) {
                return null;
            }
            int count = 0;
            for (DataObject o : selection) {
                if (!(o instanceof DataObject) || o instanceof GroupData || o instanceof ExperimenterData || o instanceof PlateAcquisitionData || o instanceof WellSampleData || !this.model.canChgrp(o)) continue;
                DataObject data = o;
                if (!owners.contains(data.getOwner().getId())) {
                    owners.add(data.getOwner().getId());
                }
                ++count;
            }
            if (count != selection.size()) {
                return null;
            }
            if (owners.size() > 1) {
                return null;
            }
        }
        long userID = DataBrowserAgent.getUserDetails().getId();
        long ownerID = -1L;
        if (owners.size() > 0) {
            ownerID = (Long)owners.get(0);
        }
        List<GroupData> l = null;
        if (ownerID == userID) {
            l = DataBrowserAgent.getAvailableUserGroups();
        } else if (DataBrowserAgent.isAdministrator()) {
            SecurityContext ctx = DataBrowserAgent.getAdminContext();
            try {
                l = DataBrowserAgent.getRegistry().getAdminService().loadGroupsForExperimenter(ctx, ownerID);
            }
            catch (Exception e) {
                DataBrowserAgent.getRegistry().getLogger().error((Object)this, "cannot retrieve user's groups");
            }
        }
        if (l == null) {
            return null;
        }
        ViewerSorter sorter = new ViewerSorter();
        List values = sorter.sort(l);
        if (this.moveActions == null) {
            this.moveActions = new ArrayList<MoveToAction>(l.size());
        }
        this.moveActions.clear();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (browser != null && selection != null) {
            for (DataObject data : selection) {
                if (ids.contains(data.getGroupId())) continue;
                ids.add(data.getGroupId());
            }
        }
        for (GroupData group : values) {
            if (ids.contains(group.getGroupId())) continue;
            this.moveActions.add(new MoveToAction(this.model, group));
        }
        return this.moveActions;
    }

    void viewField(int field) {
        this.model.viewField(field);
    }

    void createReport(String name) {
        this.model.createReport(name);
    }

    void loadExistingDatasets() {
        this.model.loadExistingDatasets();
    }

    List<ViewOtherAction> getApplicationActions() {
        List<ApplicationData> applications = this.view.getApplications();
        if (CollectionUtils.isEmpty(applications)) {
            return null;
        }
        Iterator<ApplicationData> i = applications.iterator();
        ArrayList<ViewOtherAction> actions = new ArrayList<ViewOtherAction>();
        while (i.hasNext()) {
            actions.add(new ViewOtherAction(this.model, i.next()));
        }
        return actions;
    }

    void viewDisplay(ImageDisplay node) {
        this.model.viewDisplay(node, false);
    }

    void activateUser() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        Collection<DataObject> nodes = browser.getSelectedDataObjects();
        if (nodes == null || nodes.size() > 1) {
            return;
        }
        DataObject n = nodes.iterator().next();
        if (n instanceof ExperimenterData) {
            this.model.activateUser((ExperimenterData)n);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ImageDisplay node;
        Object ho;
        String name = evt.getPropertyName();
        if ("selectedDataBrowserNodeDisplay".equals(name)) {
            ImageDisplay node2 = (ImageDisplay)evt.getNewValue();
            if (node2 == null) {
                return;
            }
            this.model.setSelectedDisplay(node2);
        } else if ("selectedDataBrowserNodesDisplay".equals(name)) {
            List nodes = (List)evt.getNewValue();
            this.model.setSelectedDisplays(nodes);
        } else if ("unselectedDataBrowserNodeDisplay".equals(name)) {
            ImageDisplay node3 = (ImageDisplay)evt.getNewValue();
            if (node3 == null) {
                return;
            }
            this.model.setUnselectedDisplay(node3);
        } else if ("filterData".equals(name)) {
            this.filterNodes((SearchObject)evt.getNewValue());
        } else if ("displayAllNodes".equals(name)) {
            this.showAll();
        } else if ("filter".equals(name) || "filterTags".equals(name)) {
            FilterContext filter = (FilterContext)evt.getNewValue();
            this.model.filterByContext(filter);
        } else if ("loadTag".equals(name) || "tagLoading".equals(name)) {
            this.model.loadExistingTags();
        } else if ("rollOver".equals(name)) {
            if (this.view.isRollOver()) {
                RollOverNode n = (RollOverNode)evt.getNewValue();
                if (n != null && n.getNode() != null) {
                    ImageNode node4 = n.getNode();
                    Thumbnail prv = node4.getThumbnail();
                    BufferedImage full = prv.getFullScaleThumb();
                    if (prv.getScalingFactor() == 2.5) {
                        full = prv.getZoomedFullScaleThumb();
                    }
                    RollOverThumbnailManager.rollOverDisplay(full, node4.getBounds(), n.getLocationOnScreen(), node4.toString());
                } else {
                    RollOverThumbnailManager.stopOverDisplay();
                }
            }
        } else if ("closeSlideView".equals(name)) {
            this.view.slideShowView(false);
        } else if ("createNoParent".equals(name) || "create".equals(name)) {
            DataObject object = (DataObject)evt.getNewValue();
            this.model.createDataObject(object);
        } else if ("tableNodesSelection".equals(name) || "selected".equals(name)) {
            List selected = (List)evt.getNewValue();
            this.model.setTableNodesSelected(selected);
        } else if ("tableSelectionMenu".equals(name) || "showPopup".equals(name)) {
            Point location = (Point)evt.getNewValue();
            if (location != null) {
                this.view.showPopup(location);
            }
        } else if ("popupPoint".equals(name)) {
            Point p = (Point)evt.getNewValue();
            if (p != null) {
                this.view.showPopup(p);
            }
        } else if ("tableSelectionView".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            if (b.booleanValue()) {
                this.view.viewSelectedNode();
            }
        } else if ("tableSelectionRollOver".equals(name)) {
            RollOverNode node5 = (RollOverNode)evt.getNewValue();
            this.model.getBrowser().setRollOverNode(node5);
        } else if ("cellSelection".equals(name)) {
            CellDisplay cell = (CellDisplay)evt.getNewValue();
            this.model.setSelectedCell(cell);
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                if (!DatasetData.class.equals((Object)type)) continue;
                this.model.addToDatasets((Collection)entry.getValue());
            }
        } else if ("wellFields".equals(name)) {
            PlateGridObject p = (PlateGridObject)evt.getNewValue();
            if (p == null) {
                return;
            }
            this.model.viewFieldsFor(p.getRow(), p.getColumn(), p.isMultipleSelection());
        } else if ("viewDisplay".equals(name)) {
            this.viewDisplay((ImageDisplay)evt.getNewValue());
        } else if ("mainViewDisplay".equals(name) && (ho = (node = (ImageDisplay)evt.getNewValue()).getHierarchyObject()) instanceof ImageData) {
            this.model.viewDisplay(node, true);
        }
    }
}

