/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageObjectAction
extends DataBrowserAction
implements PropertyChangeListener {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int REMOVE = 2;
    public static final int CUT = 3;
    private static final String NAME_COPY_LINK = "Copy Link";
    private static final String DESCRIPTION_COPY_LINK = "Copy link(s) to the selected element(s) into the clipboard.";
    private static final String NAME_COPY = "Copy";
    private static final String DESCRIPTION_COPY = "Copy the selected element(s) into the clipboard.";
    private static final String NAME_PASTE_LINK = "Paste Link";
    private static final String DESCRIPTION_PASTE_LINK = "Paste link(s) from the clipboard.";
    private static final String NAME_PASTE = "Paste";
    private static final String DESCRIPTION_PASTE = "Paste element(s) from the clipboard.";
    private static final String NAME_REMOVE = "Delete";
    private static final String DESCRIPTION_REMOVE = "Delete the selected elements.";
    private static final String NAME_CUT_LINK = "Cut Link";
    private static final String DESCRIPTION_CUT_LINK = "Cut the selected link(s).";
    private static final String NAME_CUT = "Cut";
    private static final String DESCRIPTION_CUT = "Cut the selected element(s).";
    private static final String[] KEYS = new String[]{"system", "guest"};
    private int index;
    private IconManager icons;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_COPY_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(27));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_PASTE_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(28));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_REMOVE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_REMOVE));
                this.putValue("SmallIcon", this.icons.getIcon(29));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_CUT_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(31));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    @Override
    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    private void adaptActionNameDescription(int browserType) {
        if (browserType == 8) {
            switch (this.index) {
                case 3: {
                    this.putValue("Name", NAME_CUT);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                    break;
                }
                case 0: {
                    this.putValue("Name", NAME_COPY);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                    break;
                }
                case 1: {
                    this.putValue("Name", NAME_PASTE);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                }
            }
        } else {
            switch (this.index) {
                case 3: {
                    this.putValue("Name", NAME_CUT_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT_LINK));
                    break;
                }
                case 0: {
                    this.putValue("Name", NAME_COPY_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY_LINK));
                    break;
                }
                case 1: {
                    this.putValue("Name", NAME_PASTE_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE_LINK));
                }
            }
        }
    }

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        this.adaptActionNameDescription(this.model.getType());
        Object ho = node.getHierarchyObject();
        Class klass = this.model.hasDataToCopy();
        Collection<DataObject> selected = browser.getSelectedDataObjects();
        int count = 0;
        switch (this.index) {
            case 0: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    Iterator<DataObject> i = selected.iterator();
                    while (i.hasNext()) {
                        if (!this.model.canLink(i.next())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.size());
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    this.setEnabled(this.model.getType() == 8);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 1: {
                if (klass == null) {
                    this.setEnabled(false);
                    return;
                }
                if (ho instanceof ProjectData) {
                    if (DatasetData.class.equals((Object)klass)) {
                        Iterator<DataObject> i = selected.iterator();
                        while (i.hasNext()) {
                            if (!this.model.canLink(i.next())) continue;
                            ++count;
                        }
                        this.setEnabled(count == selected.size());
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof ScreenData) {
                    if (PlateData.class.equals((Object)klass)) {
                        Iterator<DataObject> i = selected.iterator();
                        while (i.hasNext()) {
                            if (!this.model.canLink(i.next())) continue;
                            ++count;
                        }
                        this.setEnabled(count == selected.size());
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof DatasetData) {
                    if (ImageData.class.equals((Object)klass)) {
                        Iterator<DataObject> i = selected.iterator();
                        while (i.hasNext()) {
                            if (!this.model.canLink(i.next())) continue;
                            ++count;
                        }
                        this.setEnabled(count == selected.size());
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 2: {
                if (ho instanceof ExperimenterData) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ImageData || ho instanceof ScreenData) {
                    Iterator<DataObject> i = selected.iterator();
                    while (i.hasNext()) {
                        if (!this.model.canDelete(i.next())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.size());
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 3: {
                Object parent = this.model.getParentOfNodes();
                if (ho instanceof DatasetData && parent instanceof ProjectData || ho instanceof ImageData && (parent instanceof DatasetData || parent instanceof TagAnnotationData) || ho instanceof PlateData && parent instanceof ScreenData) {
                    Iterator<DataObject> i = selected.iterator();
                    while (i.hasNext()) {
                        if (!this.model.canLink(i.next())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.size());
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    this.setEnabled(false);
                    if (this.model.getType() != 8 || !(parent instanceof GroupData)) break;
                    GroupData g = (GroupData)parent;
                    Boolean b = null;
                    for (int j = 0; j < KEYS.length; ++j) {
                        if (!this.model.isSystemGroup(g.getId(), KEYS[j])) continue;
                        ExperimenterData user = this.model.getCurrentUser();
                        ExperimenterData exp = (ExperimenterData)ho;
                        b = exp.getId() != user.getId() && !this.model.isSystemUser(exp.getId(), KEYS[j]);
                        break;
                    }
                    if (b != null) {
                        this.setEnabled(b);
                        break;
                    }
                    this.setEnabled(true);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    private void handlePropertyChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    public ManageObjectAction(DataBrowser model, int index) {
        super(model);
        this.setEnabled(false);
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("copyRndSettings".equals(name) || "itemsToCopy".equals(name) || "selectionUpdated".equals(name)) {
                    ManageObjectAction.this.handlePropertyChange();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copy();
                break;
            }
            case 1: {
                this.model.paste();
                break;
            }
            case 2: {
                this.model.remove();
                break;
            }
            case 3: {
                this.model.cut();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Browser browser;
        String name = evt.getPropertyName();
        if (("copyRndSettings".equals(name) || "itemsToCopy".equals(name) || "selectionUpdated".equals(name) || "selectedDataBrowserNodeDisplay".equals(name) || "selectedDataBrowserNodesDisplay".equals(name)) && (browser = this.model.getBrowser()) != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }
}

