/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import omero.gateway.model.DataObject;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.events.hiviewer.DownloadEvent;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.PojosUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class DownloadAction
extends DataBrowserAction {
    private static final String NAME = "Download...";
    private static final String DESCRIPTION = "Download the selected files.";

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        Collection<DataObject> list = this.model.getBrowser().getSelectedDataObjects();
        boolean enabled = false;
        if (CollectionUtils.isNotEmpty(list)) {
            for (DataObject d : list) {
                if (!PojosUtil.isDownloadable(d)) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public DownloadAction(DataBrowser model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(63));
        this.putValue("Name", NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImageDisplay node = this.model.getBrowser().getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        final ArrayList<DataObject> selection = new ArrayList<DataObject>();
        selection.add((DataObject)node.getHierarchyObject());
        JFrame f = DataBrowserAgent.getRegistry().getTaskBar().getFrame();
        int type = 2;
        FileChooser chooser = new FileChooser(f, type, "Download", "Select where to download the file(s).");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(64));
        chooser.setApproveButtonText("Download");
        chooser.setCheckOverride(true);
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                FileChooser src = (FileChooser)evt.getSource();
                if ("approveSelection".equals(name)) {
                    String path = (String)evt.getNewValue();
                    EventBus bus = DataBrowserAgent.getRegistry().getEventBus();
                    bus.post(new DownloadEvent(new File(path), src.isOverride(), selection));
                }
            }
        });
        chooser.centerDialog();
    }
}

