/*****************************************************************************
* (c) Copyright 2012-2013 F.Hoffmann-La Roche AG                             *
* Contact: bioinfoc@bioinfoc.ch, Detlef.Wolf@Roche.com.                      *
*                                                                            *
* This file is part of BIOINFO-C. BIOINFO-C is free software: you can        *
* redistribute it and/or modify it under the terms of the GNU Lesser         *
* General Public License as published by the Free Software Foundation,       *
* either version 3 of the License, or (at your option) any later version.    *
*                                                                            *
* BIOINFO-C is distributed in the hope that it will be useful, but           *
* WITHOUT ANY WARRANTY; without even the implied warranty of                 *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
* Lesser General Public License for more details. You should have            *
* received a copy of the GNU Lesser General Public License along with        *
* BIOINFO-C. If not, see <http://www.gnu.org/licenses/>.                     *
*****************************************************************************/
/** @file eval.h
    @brief Module that evaluates mathematical expressions.
    It handles unary + and -, binary +, -, *, / and ^,
    functions sin, cos, tan, log, exp and ln.
    It handles decisions such as a>1 ? b : c.
    It substitutes variable names by the assigned value.
    It knows constants pi and e.
    Usage: eval_assignEvaluate ("set a=1; a+(a+2)");
           eval_evaluate ("(-4)^2");
    Module prefix eval_
*/
#ifndef EVAL_H
#define EVAL_H

#ifdef __cplusplus
extern "C" {
#endif

extern char *eval_evaluate (char *s);
extern void eval_setVariable (char *name,char *val);
extern char *eval_assignEvaluate (char *s);
extern void eval_setDebug (int mode);

#ifdef __cplusplus
}
#endif

#endif
