/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.cml;

import nu.xom.Attribute;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.libio.md.ChargeGroup;
import org.openscience.cdk.libio.md.MDMolecule;
import org.openscience.cdk.libio.md.Residue;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomArray;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLScalar;

public class MDMoleculeCustomizer
implements ICMLCustomizer {
    @Override
    public void customize(IBond bond, Object nodeToAdd) throws Exception {
    }

    @Override
    public void customize(IAtom atom, Object nodeToAdd) throws Exception {
    }

    @Override
    public void customize(IAtomContainer molecule, Object nodeToAdd) throws Exception {
        if (!(nodeToAdd instanceof CMLMolecule)) {
            throw new CDKException("NodeToAdd must be of type nu.xom.Element!");
        }
        CMLMolecule molToCustomize = (CMLMolecule)nodeToAdd;
        if (molecule instanceof MDMolecule) {
            CMLAtom cmlAtom;
            int i;
            CMLAtomArray ar;
            int number;
            MDMolecule mdmol = (MDMolecule)molecule;
            molToCustomize.setConvention("md:mdMolecule");
            molToCustomize.addNamespaceDeclaration("md", "http://www.bioclipse.net/mdmolecule/");
            if (mdmol.getResidues().size() > 0) {
                for (Residue residue : mdmol.getResidues()) {
                    number = residue.getNumber();
                    CMLMolecule resMol = new CMLMolecule();
                    resMol.setDictRef("md:residue");
                    resMol.setTitle(residue.getName());
                    CMLScalar residueNumber = new CMLScalar(number);
                    residueNumber.addAttribute(new Attribute("dictRef", "md:resNumber"));
                    resMol.addScalar(residueNumber);
                    String rprefix = "r" + number;
                    ar = new CMLAtomArray();
                    for (i = 0; i < residue.getAtomCount(); ++i) {
                        cmlAtom = new CMLAtom();
                        cmlAtom.setRef(residue.getAtom(i).getID());
                        cmlAtom.setId(rprefix + "_" + residue.getAtom(i).getID());
                        ar.addAtom(cmlAtom);
                    }
                    resMol.addAtomArray(ar);
                    molToCustomize.appendChild(resMol);
                }
            }
            if (mdmol.getChargeGroups().size() > 0) {
                for (ChargeGroup chargeGroup : mdmol.getChargeGroups()) {
                    number = chargeGroup.getNumber();
                    CMLMolecule cgMol = new CMLMolecule();
                    cgMol.setDictRef("md:chargeGroup");
                    CMLScalar cgNo = new CMLScalar(number);
                    cgNo.addAttribute(new Attribute("dictRef", "md:cgNumber"));
                    cgMol.appendChild(cgNo);
                    String cprefix = "cg" + number;
                    ar = new CMLAtomArray();
                    for (i = 0; i < chargeGroup.getAtomCount(); ++i) {
                        cmlAtom = new CMLAtom();
                        cmlAtom.setRef(chargeGroup.getAtom(i).getID());
                        cmlAtom.setId(cprefix + "_" + chargeGroup.getAtom(i).getID());
                        if (chargeGroup.getAtom(i).equals(chargeGroup.getSwitchingAtom())) {
                            CMLScalar scalar = new CMLScalar();
                            scalar.setDictRef("md:switchingAtom");
                            cmlAtom.addScalar(scalar);
                        }
                        ar.addAtom(cmlAtom);
                    }
                    cgMol.addAtomArray(ar);
                    molToCustomize.appendChild(cgMol);
                }
            }
        }
    }
}

