/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.StringTokenizer;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class HINFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new HINFormat();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "HyperChem HIN";
    }

    @Override
    public String getMIMEType() {
        return "chemical/x-hin";
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"hin"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.HINReader";
    }

    @Override
    public String getWriterClassName() {
        return "org.openscience.cdk.io.HINWriter";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        StringTokenizer tokenizer;
        return line.startsWith("atom ") && (line.endsWith(" s") || line.endsWith(" d") || line.endsWith(" t") || line.endsWith(" a")) && (tokenizer = new StringTokenizer(line, " ")).countTokens() % 2 == 0;
    }

    @Override
    public boolean isXMLBased() {
        return false;
    }

    @Override
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 0x200;
    }

    @Override
    public int getRequiredDataFeatures() {
        return 26;
    }
}

