(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    102230,       2959]
NotebookOptionsPosition[     99047,       2873]
NotebookOutlinePosition[     99584,       2894]
CellTagsIndexPosition[     99541,       2891]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherPairState", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"state", ",", "2"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"state", "-", "1"}], ",", 
     RowBox[{"state", "+", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant2", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"state", " ", "-", " ", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"state", "+", "1"}], ",", " ", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant4", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"state", " ", "\[GreaterEqual]", " ", "5"}], ",", " ", "5", ",", 
     " ", "1"}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"allPermutations", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutations"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Four", "-", 
    RowBox[{"way", " ", "states"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"permutations", " ", "=", " ", 
     RowBox[{"GroupElements", "[", 
      RowBox[{"PermutationGroup", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", " ", "4"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{"(*", "Symmetries", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"standardiseUsingPermutation", "[", 
     RowBox[{"{", 
      RowBox[{"unique_", ",", " ", "standardised_", ",", " ", "remaining_"}], 
      "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"current", ",", "positions", ",", "permutationsOfCurrent"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"current", " ", "=", " ", 
        RowBox[{"First", "[", "remaining", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permutationsOfCurrent", " ", "=", " ", 
        RowBox[{"allPermutations", "[", "current", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"positions", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"unique", ",", "#1"}], "]"}], "&"}], "/@", 
         "permutationsOfCurrent"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Plus", "@@", 
           RowBox[{"(", 
            RowBox[{"Flatten", "[", "positions", "]"}], ")"}]}], " ", 
          "\[Equal]", " ", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Append", "[", 
            RowBox[{"unique", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"unique", ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", 
             RowBox[{"unique", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Flatten", "[", "positions", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
           " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{
      RowBox[{"Nest", "[", 
       RowBox[{"standardiseUsingPermutation", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", " ", 
          RowBox[{"{", "}"}], ",", " ", "states"}], "}"}], ",", 
        RowBox[{"Length", "[", "states", "]"}]}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"statesWithCounts", "=", 
    RowBox[{"Tally", "[", "states", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "statesWithCounts", "]"}], "\[IndentingNewLine]", 
   RowBox[{"states", " ", "=", " ", 
    RowBox[{"First", " ", "/@", "statesWithCounts"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilMatrixFunction", "[", 
   RowBox[{"from_", ",", " ", "to_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "twoRecomb", ",", " ", "twoNonRecomb", ",", " ", "oneEach", ",", " ", 
      "twoRecombMatches", ",", " ", "twoNonRecombMatches", ",", " ", 
      "oneEachMatches", ",", " ", "permutationsOfTo"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOfTo", " ", "=", " ", 
      RowBox[{"allPermutations", "[", "to", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoNonRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"oneEach", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"twoNonRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoNonRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@",
          "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"oneEachMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"oneEach", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"twoRecombMatches", " ", 
       FractionBox[
        SuperscriptBox["r", "2"], "4"]}], " ", "+", " ", 
      RowBox[{"twoNonRecombMatches", " ", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "2"], "4"]}], " ", "+", " ", 
      RowBox[{"oneEachMatches", " ", "r", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "4"]}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rilMatrix", " ", "=", " ", 
   RowBox[{
    RowBox[{"Outer", "[", 
     RowBox[{
     "rilMatrixFunction", ",", " ", "states", ",", " ", "states", ",", "1"}], 
     "]"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"rilMatrix", ",", " ", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"states", ",", " ", "states"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "These", " ", "should", " ", "all", " ", "sum", " ", "to", " ", "1"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", "rilMatrix"}], " ", "//",
   "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "eigen", " ", "decomposition", " ", "works"}], 
   ",", " ", 
   RowBox[{
   "difference", " ", "should", " ", "be", " ", "a", " ", "zero", " ", 
    "matrix"}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"decomposed", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"decomposed", " ", "-", " ", "rilMatrix"}], "//", 
  "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Use", " ", "eigen", " ", "decomposition", " ", "to", " ", "take", " ", 
   "power"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"power", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ",", "d"}], 
     "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "the", " ", "limit", " ", "looks", " ", "right",
     " ", "in", " ", "the", " ", "case", " ", "of", " ", "infinite", " ", 
    "selfing"}], ",", " ", 
   RowBox[{"no", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilLimit", " ", "=", " ", 
   RowBox[{"Limit", "[", 
    RowBox[{"power", ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
       RowBox[{"r", " ", "<", " ", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"haplotypeProbability", "[", 
   RowBox[{"state1_", ",", "state2_"}], "]"}], " ", ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"startRelevant2", "[", "state1", "]"}], " ", "\[NotEqual]", " ", 
     RowBox[{"startRelevant2", "[", "state2", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Different", " ", "halves"}], "*)"}], "\[IndentingNewLine]", "0",
     ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"The", " ", "same", " ", "pair"}], ",", " ", 
      RowBox[{
      "so", " ", "they", " ", "could", " ", "be", " ", "the", " ", "same"}]}],
      "*)"}], "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"state1", " ", "\[Equal]", " ", "state2"}], ",", 
      FractionBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "2"], ",", 
      FractionBox["r", "2"]}], "]"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"state", ",", " ", "count"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"state", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"count", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "\[NotEqual]", " ", 
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "\[NotEqual]", " ", 
            RowBox[{"startRelevant2", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}]}]}], ",", "0", ",", 
          RowBox[{
           FractionBox["count", "2"], " ", 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}], 
     "&"}], "/@", "statesWithCounts"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", "initialProbabilities"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{"infiniteSelfing", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"initialProbabilities", " ", ".", " ", "rilLimit"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
       "statesWithCounts"}], ")"}]}], " ", "//", "FullSimplify"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"Pick", "[", 
  RowBox[{"states", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", " ", "=!=", " ", "0"}], ")"}], "&"}], "/@", 
    "infiniteSelfing"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Probabilities", " ", "for", " ", "a", " ", "finite", " ", "number", " ", 
    "of", " ", "generations", " ", "of", " ", "selfing"}], ",", " ", 
   RowBox[{
    RowBox[{"no", " ", 
     RowBox[{"intercossing", ".", " ", "This"}], " ", "can", " ", "be", " ", 
     "worked", " ", "out", " ", "for", " ", "the", " ", "4"}], "-", 
    RowBox[{
    "way", " ", "design", " ", "just", " ", "based", " ", "on", " ", "the", 
     " ", "2"}], "-", 
    RowBox[{"way", " ", "design"}]}], ",", " ", 
   RowBox[{
   "and", " ", "it", " ", "should", " ", "match", " ", "the", " ", 
    "eigenvalue", " ", "calculation", " ", "above"}]}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fromPaper2way", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}], ")"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "+", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      FractionBox["r", 
       RowBox[{"1", "+", 
        RowBox[{"2", "r"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "-", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox["r", "2"]}]}], ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "+", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"fromPaper2way", "*", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "4", ",", "1", ",", "1"}], "}"}]}], ")"}]}],
   " ", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"permutationsF2", " ", "=", " ", 
   RowBox[{"GroupElements", "[", 
    RowBox[{"PermutationGroup", "[", 
     RowBox[{"{", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"allPermutationsF2", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutationsF2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected4wayFiniteSelfingMatrixFunction", " ", "=", " ", 
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "toStates", ",", " ", "permutationsToStates", ",", " ", "result", ",",
          " ", "positions", ",", " ", "indices", ",", " ", "f2Permutations"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", " ", "=", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"0", ",", " ", 
           RowBox[{"Length", "[", "states", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "B", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "B", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "5", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "//", "FullSimplify"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"expected4wayFiniteSelfingMatrix", " ", "=", 
  RowBox[{
  "expected4wayFiniteSelfingMatrixFunction", "/@", "states"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", 
   "expected4wayFiniteSelfingMatrix"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected4wayFiniteSelfing", "=", 
   RowBox[{"initialProbabilities", ".", "expected4wayFiniteSelfingMatrix"}]}],
   ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "expected4wayFiniteSelfing"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Check", " ", "that", " ", "asymptotically", " ", "we", " ", "have", " ", 
   "the", " ", "right", " ", "values"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"expected4wayFiniteSelfing", ",", " ", 
    RowBox[{"d", "\[Rule]", "\[Infinity]"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", " ", 
     RowBox[{
      RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
      RowBox[{"r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
    "statesWithCounts"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Ok", ",", " ", 
    RowBox[{
    "so", " ", "we", " ", "correctly", " ", "recreated", " ", "the", " ", 
     "results", " ", "from", " ", "the", " ", 
     RowBox[{"paper", ".", " ", "But"}], " ", "now", " ", "what", " ", 
     "about", " ", "the", " ", "case", " ", "where", " ", "there", " ", "is", 
     " ", 
     RowBox[{"intercrossing", "?", "\[IndentingNewLine]", "The"}], " ", 
     "linkage", " ", "disequilibrium", " ", "coefficient", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "work", " ", 
     RowBox[{"here", ".", " ", "So"}], " ", "we", " ", "need", " ", "to", " ",
      "work", " ", "out", " ", "the", " ", "effect", " ", "on", " ", "the", 
     " ", "haplotypes", " ", "of", " ", 
     RowBox[{"intercrossing", ".", " ", "For"}], " ", "these", " ", 
     "purposes", " ", "we", " ", "need", " ", "3", " ", "states", " ", "AA"}],
     ",", " ", "AB", ",", " ", 
    RowBox[{"and", " ", 
     RowBox[{"AC", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Once", " ", "the", " ", "four", " ", "founders", " ", "are", " ", 
     "crossed"}], ",", " ", 
    RowBox[{"we", " ", "have"}], ",", " ", 
    RowBox[{"AA", " ", "=", " ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "2"], "4"]}], ",", " ", 
    RowBox[{"AB", " ", "=", " ", 
     RowBox[{"r", 
      FractionBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "4"]}]}], ",", " ", 
    RowBox[{"AC", " ", "=", " ", 
     FractionBox["r", "8"]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
    RowBox[{"r", 
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}]}], " ", "+", " ", "r"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"In", " ", "general"}], ",", " ", 
    RowBox[{
    "if", " ", "we", " ", "add", " ", "an", " ", "extra", " ", "generation", 
     " ", "of", " ", "intercrossing"}], ",", " ", 
    RowBox[{
     RowBox[{"this", " ", "becomes", " ", "\[IndentingNewLine]", "AA"}], " ", 
     "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"AA", "'"}], "*", 
        RowBox[{"AA", "'"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "3", "*", 
        RowBox[{"AA", "'"}], "*", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "2"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "2", "*", 
        RowBox[{"AB", "'"}], "*", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"], "+", 
          FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "2", "*", 
        RowBox[{"AB", "'"}], "*", 
        FractionBox[
         RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "4", "*", 
        RowBox[{"AC", "'"}], "*", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
          FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "4", "*", 
        RowBox[{"AC", "'"}], "*", 
        FractionBox[
         RowBox[{"1", "-", "r"}], "2"]}]}], "\[IndentingNewLine]", "=", " ", 
      RowBox[{
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AA", "'"}], " ", "+", " ", 
         RowBox[{"3", 
          RowBox[{"AA", "'"}], "*", 
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", 
             RowBox[{"AB", "'"}]}], "+", 
            RowBox[{"4", "*", 
             RowBox[{"AC", "'"}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
            FractionBox["r", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", 
             RowBox[{"AB", "'"}]}], "+", 
            RowBox[{"4", "*", 
             RowBox[{"AC", "'"}]}]}], ")"}], "*", 
          FractionBox[
           RowBox[{"1", "-", "r"}], "2"]}]}]}]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AB", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", 
       RowBox[{"AB", "'"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "3", "*", 
       RowBox[{"AB", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", 
         FractionBox["r", "2"]}], ")"}]}], "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "4", "*", 
       RowBox[{"AC", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}]}], "\[IndentingNewLine]", "=", " ", 
     RowBox[{
      RowBox[{"AB", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"4", 
            RowBox[{"AC", "'"}]}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], "+", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"AB", "'"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"3", "*", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"4", 
            RowBox[{"AC", "'"}]}]}], ")"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AC", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AB", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], "+", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AB", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"AC", "'"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], "+", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "5", "*", 
       RowBox[{"AC", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}]}], "\[IndentingNewLine]", "=", 
     RowBox[{
      RowBox[{"AC", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], "+", 
           RowBox[{"2", 
            RowBox[{"AB", "'"}]}], "+", 
           RowBox[{"2", 
            RowBox[{"AC", "'"}]}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"2", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"5", 
            RowBox[{"AC", "'"}]}]}], ")"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"AC", "'"}]}], ")"}]}]}]}], "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"AA_", ",", " ", "AB_", ",", " ", "AC_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"AA", 
      RowBox[{"(", 
       RowBox[{"AA", " ", "+", " ", 
        RowBox[{"6", "AA", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "AB"}], " ", "+", " ", 
           RowBox[{"8", "AC"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "AB"}], " ", "+", " ", 
           RowBox[{"8", " ", "AC"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], " ", "+", " ", 
     RowBox[{"2", "*", "AB", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"8", "*", "AB", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"8", "*", "AC", "*", "AC", " ", 
      FractionBox["r", "2"]}]}], ",", 
    RowBox[{
     RowBox[{"AB", 
      RowBox[{"(", 
       RowBox[{"AB", " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "AA"}], "+", " ", 
           RowBox[{"8", " ", "AC"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "AA"}], " ", "+", " ", 
           RowBox[{"6", " ", "AB"}], " ", "+", " ", 
           RowBox[{"8", " ", "AC"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], "+", " ", 
     RowBox[{"8", " ", "AC", "*", "AC", "*", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"8", "AA", " ", "*", "AC", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"2", "*", "AA", "*", "AA", " ", 
      FractionBox["r", "2"]}]}], ",", " ", 
    RowBox[{
     RowBox[{"AC", 
      RowBox[{"(", 
       RowBox[{"AC", " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "AA"}], " ", "+", " ", 
           RowBox[{"4", "AB"}], " ", "+", 
           RowBox[{"4", " ", "AC"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "AA"}], " ", "+", " ", 
           RowBox[{"4", " ", "AB"}], " ", "+", " ", 
           RowBox[{"10", " ", "AC"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], " ", "+", " ", 
     RowBox[{"2", "AB", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"4", "*", "AA", "*", "AB", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"2", "AA", "*", "AA", " ", 
      FractionBox["r", "2"]}], " ", "+", 
     RowBox[{"2", "*", "AC", "*", "AC", "*", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"4", "*", "AC", "*", 
      RowBox[{"(", 
       RowBox[{"AA", "+", "AB"}], ")"}], "*", 
      FractionBox["r", "2"]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"r_", ",", " ", "n_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "4"], 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "n"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], "2"], "-", " ", 
         FractionBox["1", "4"]}], ")"}]}], " ", "+", " ", 
      FractionBox["1", "4"]}], ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "n"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", 
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}]}], " ", "-", 
         FractionBox["1", "4"]}], ")"}]}], "+", 
      FractionBox["1", "4"]}], ",", " ", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], "n"], 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           FractionBox["1", "2"]}], " ", ")"}]}]}], ")"}]}]}], 
    "}"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"r", ",", " ", "5"}], "]"}], " ", "-", " ", 
   RowBox[{"f", "@@", 
    RowBox[{"(", 
     RowBox[{"f", "@@", 
      RowBox[{"(", 
       RowBox[{"f", " ", "@@", 
        RowBox[{"(", 
         RowBox[{"f", " ", "@@", 
          RowBox[{"(", 
           RowBox[{"f", "[", 
            RowBox[{
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "r"}], ")"}], "2"], "4"], ",", " ", 
             FractionBox[
              RowBox[{"r", 
               RowBox[{"(", 
                RowBox[{"1", "-", "r"}], ")"}]}], "4"], ",", " ", 
             FractionBox["r", "8"]}], "]"}], ")"}]}], ")"}]}], ")"}]}], 
     ")"}]}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"r", ",", " ", "4"}], "]"}], " ", "-", " ", 
   RowBox[{"f", "@@", 
    RowBox[{"(", 
     RowBox[{"f", " ", "@@", 
      RowBox[{"(", 
       RowBox[{"f", " ", "@@", 
        RowBox[{"(", 
         RowBox[{"f", "[", 
          RowBox[{
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], "2"], "4"], ",", " ", 
           FractionBox[
            RowBox[{"r", 
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}]}], "4"], ",", " ", 
           FractionBox["r", "8"]}], "]"}], ")"}]}], ")"}]}], ")"}]}]}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"haplotypeProbFunc", "[", 
   RowBox[{"first_", ",", " ", "second_", ",", " ", "nIntercrossing_"}], 
   "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "afterIntercrossingAA", ",", " ", "afterIntercrossingAB", ",", " ", 
      "afterIntercrossingAC"}], "}"}], ",", "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "afterIntercrossingAA", ",", " ", "afterIntercrossingAB", ",", " ", 
        "afterIntercrossingAC"}], "}"}], "=", " ", 
      RowBox[{"g", "[", 
       RowBox[{"r", ",", " ", "nIntercrossing"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"first", " ", "\[Equal]", " ", "second"}], ",", " ", 
       "afterIntercrossingAA", ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"startRelevant2", "[", "first", "]"}], " ", "\[Equal]", " ", 
          RowBox[{"startRelevant2", "[", "second", "]"}]}], ",", " ", 
         "afterIntercrossingAB", ",", " ", "afterIntercrossingAC"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProb", "[", 
   RowBox[{"r_", ",", " ", "nIntercrossing_"}], "]"}], " ", ":=", " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"haplotypeProbFunc", "[", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", "nIntercrossing"}], 
         "]"}], "*", 
        RowBox[{"haplotypeProbFunc", "[", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", "nIntercrossing"}], 
         "]"}]}], ")"}], "&"}], " ", "/@", " ", "states"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}],
     ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"initialProb", "[", 
   RowBox[{"r_", ",", " ", "0"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ",
      "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", 
     " ", "0", ",", "0", ",", " ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "2"], "8"], ",", " ", 
     FractionBox[
      RowBox[{"r", 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}]}], "8"], ",", " ", 
     FractionBox[
      SuperscriptBox["r", "2"], "8"], ",", " ", "0", ",", " ", "0", ",", " ", 
     "0"}], "}"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}],
     ")"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"combinedProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"initialProb", "[", 
       RowBox[{"r", ",", " ", "nIntercrossing"}], "]"}], ".", "power"}], 
     ")"}], "//", "FullSimplify"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"selfingLimit", " ", "=", " ", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"combinedProbabilities", ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}], 
   ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Divide", " ", "by", " ", "the", " ", "numbers", " ", "of", " ", 
    "states"}], ",", " ", 
   RowBox[{"because", " ", 
    RowBox[{"they", "'"}], "ve", " ", "been", " ", "aggregated"}]}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"noIntecrossingLimit", " ", "=", " ", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"initialProb", "[", 
         RowBox[{"r", ",", " ", "0"}], "]"}], ".", "power"}], ")"}], "//", 
      "FullSimplify"}], ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"%", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}], 
   ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Rewrite", " ", "the", " ", "formula", " ", "into", " ", "something", " ", 
   "computable", " ", "more", " ", 
   RowBox[{"efficiently", ".", " ", "The"}], " ", "must", " ", "general", " ",
    "case", " ", "first"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"combinedProbabilities", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], 
         RowBox[{"-", "1"}]], " ", "\[Rule]", " ", "onePlus2RInverse"}], ",", 
       " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "nIntercrossing"], " ", "\[Rule]", 
        " ", "powOneMinusR1"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], 
         RowBox[{"2", " ", "nIntercrossing"}]], " ", "\[Rule]", " ", 
        "powOneMinusR2"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], 
         RowBox[{"1", "+", "nIntercrossing"}]], "\[Rule]", " ", 
        RowBox[{"powOneMinusR1", " ", "oneMinusR"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], " ", "\[Rule]", " ", "oneMinusR"}], 
       ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
        "powOneMinus2R1"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], 
         RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
        RowBox[{"powOneMinus2R1", " ", "oneMinus2R"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "r"}]}], ")"}], "\[Rule]", " ", "onePlus2R"}], 
       ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
         "d"], " ", "\[Rule]", " ", "quadraticPower1"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
         "2"], "\[Rule]", " ", "quadraticSquared"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
        "\[Rule]", " ", "quadratic"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "2"], "\[Rule]", " ", 
        "oneMinus2RSquared"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "4"], "\[Rule]", " ", 
        "oneMinus2RPow4"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "r"}]}], ")"}], " ", "\[Rule]", " ", 
        RowBox[{"-", "oneMinus2R"}]}]}], "}"}]}], ")"}], "/.", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "4"], "+", 
         RowBox[{"powOneMinusR1", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["3", "4"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}]}]}],
         ")"}], "2"], "\[Rule]", " ", "complex2"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "4"], "+", 
        RowBox[{"powOneMinusR1", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["3", "4"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}]}]}], 
       ")"}], "\[Rule]", " ", "complex1"}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"powOneMinusR1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}], "2"], "\[Rule]", " ",
       "complex3"}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}]}], ")"}], "2"], 
      "\[Rule]", " ", "complex4"}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"powOneMinusR1", " ", "quadratic"}]}], ")"}], "2"], 
      "\[Rule]", " ", "complex5"}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "4"], "-", 
         FractionBox[
          RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}], "4"]}], ")"}], 
       "2"], "\[Rule]", " ", "complex6"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", "r"}]}], ")"}], "\[Rule]", " ", "twoRMinus3"}], ",",
      " ", 
     RowBox[{
      SuperscriptBox["oneMinus2R", "3"], "\[Rule]", " ", "oneMinus2RCubed"}], 
     ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"oneMinus2R", " ", "powOneMinusR1"}]}], ")"}], "2"], 
      "\[Rule]", " ", "complex7"}], ",", " ", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", "pow21"}], ",", " ", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "4"}], "-", "d"}]], " ", "\[Rule]", " ", "pow22"}], ",", 
     " ", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", "pow23"}], " ", ",", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "6"}], "-", "d"}]], "\[Rule]", " ", "pow24"}], ",", " ", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", "pow25"}], ",", " ", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"1", "+", "d"}]], " ", "\[Rule]", " ", "pow26"}]}], "}"}]}], "//",
   "InputForm"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Now", " ", "the", " ", "case", " ", "with", " ", "no", " ", 
   RowBox[{"intercrossing", "."}]}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rewritten", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"expected4wayFiniteSelfing", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "statesWithCounts"}],
          ")"}]}], ")"}], "//", "FullSimplify"}], ")"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], "2"], "\[Rule]", " ", 
       "oneMinusRSquared"}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "r"}]}], ")"}], "\[Rule]", " ", "onePlus2R"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
       "powOneMinus2R"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], "d"],
        "\[Rule]", " ", "powD1"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], "4"], "\[Rule]", " ", 
       "oneMinusRPow4"}], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], "3"], "\[Rule]", " ", 
       RowBox[{"-", "oneMinusRCubed"}]}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", "\[Rule]", " ", 
       RowBox[{"-", "oneMinusR"}]}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"-", "d"}]], " ", "\[Rule]", " ", 
       RowBox[{"1", "/", "pow2"}]}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{"2", " ", "pow2"}]]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"1", "-", "d"}]], "\[Rule]", " ", 
       FractionBox["2", "pow2"]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "3"], "pow2"}]]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "4"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "4"], "pow2"}]]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "5"], "pow2"}]]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "6"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "6"], "pow2"}]]}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "7"], "pow2"}]]}], ",", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{
         RowBox[{"-", "8"}], "-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["2", "8"], "pow2"}]]}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
       RowBox[{"2", " ", "pow2"}]}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"2", "+", "d"}]], "\[Rule]", " ", 
       RowBox[{"4", " ", "pow2"}]}], ",", " ", 
      RowBox[{
       SuperscriptBox["r", "2"], "\[Rule]", " ", "rSquared"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"InputForm", "[", "rewritten", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Produces", " ", "the", " ", "table", " ", "probabilityData"}], 
   "<", "4", ">", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"::", "intermediateAllelesMask"}], "[", "]"}], "[", "4", "]"}], 
    " ", "in", " ", 
    RowBox[{"probabilities8", ".", "hpp"}]}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"#1", ",", " ", 
     RowBox[{"#1", "+", "3"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", " ", "15", ",", " ", "4"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Produces", " ", "the", " ", "table", " ", "probabilityData"}], 
   "<", "8", ">", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"::", "intermediateProbabilitiesMask"}], "[", "]"}], "[", "16", 
     "]"}], " ", "in", " ", 
    RowBox[{"probabilities8", ".", "hpp"}]}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pairs", " ", "=", " ", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", "4"}], "]"}], ",", " ", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Outer", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"state", ",", " ", "permutedState", ",", " ", "allPositions"}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"state", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permutedState", " ", "=", " ", 
        RowBox[{"allPermutations", "[", "state", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"allPositions", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"states", ",", " ", "#1"}], "]"}], "&"}], "/@", 
         "permutedState"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Flatten", "[", "allPositions", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}]}], " ", 
     "\[IndentingNewLine]", "]"}], "&"}], ",", " ", "pairs", ",", " ", 
   "pairs", ",", " ", "1"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "We", " ", "need", " ", "to", " ", "divide", " ", "by", " ", "the", " ", 
   "counts", " ", "in", " ", "the", " ", "implementation"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "-", "1"}], ",", " ", 
      RowBox[{
       RowBox[{"statesWithCounts", "[", 
        RowBox[{"[", "#1", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ")"}], "&"}], "/@", " ", 
  RowBox[{"Range", "[", 
   RowBox[{"1", ",", " ", 
    RowBox[{"Length", "[", "states", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"contributionsToMarkerValue", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"combinedProbabilities", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "4"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expected4wayFiniteSelfing", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "4"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", " ", 
    "uninformative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "0"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", 
    " ", "uninformative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "1"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
            " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData["statesWithCounts"], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Single", " ", "locus", " ", "homozygote", " ", "probability"}], 
   ",", " ", 
   RowBox[{"with", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "5", "]"}], "]"}], "*", 
    RowBox[{"4", "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "6", "]"}], "]"}], "*", 
    RowBox[{"2", "/", "8"}]}], "+", 
   RowBox[{
    RowBox[{"combinedProbabilities", "[", 
     RowBox[{"[", "7", "]"}], "]"}], "*", 
    RowBox[{"2", "/", "16"}]}]}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], " ", "or", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "with", " ",
    "intercrossing"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "8", "]"}], "]"}], "/", "4"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "7", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"8", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "9", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "10", "]"}], "]"}], "/", "4"}]}], " ", "+", " ", 
   RowBox[{"8", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "11", "]"}], "]"}], "/", "32"}]}], " ", "+", 
   RowBox[{"4", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "12", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], " ", "or", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "with", " ",
    "intercrossing"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "5", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "9", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "11", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "13", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "14", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "15", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "16", "]"}], "]"}], "/", "8"}]}], " ", "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "17", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"combinedProbabilities", "[", 
      RowBox[{"[", "18", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Single", " ", "locus", " ", "homozygote", " ", "probability"}], 
   ",", " ", 
   RowBox[{"without", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"expected4wayFiniteSelfing", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"expected4wayFiniteSelfing", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "/", "4"}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "5", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "6", "]"}], "]"}], "/", "8"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "7", "]"}], "]"}], "/", "16"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], " ", "or", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "has", " ", 
   "probability", " ", "0", " ", "without", " ", "intercrossing"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "8", "]"}], "]"}], "/", "4"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "7", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "9", "]"}], "]"}], "/", "32"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "10", "]"}], "]"}], "/", "4"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "11", "]"}], "]"}], "/", "32"}]}], " ", "+", 
   RowBox[{"4", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "12", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "3"}], "}"}], " ", "or", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "1"}], "}"}], " ", "hetrozygote", " ", "has", 
     " ", "non"}], "-", 
    RowBox[{"zero", " ", "probability"}]}], ",", " ", 
   RowBox[{"without", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "5", "]"}], "]"}], "/", "32"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "13", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "14", "]"}], "]"}], "/", "16"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "15", "]"}], "]"}], "/", "8"}]}], " ", "+", " ", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "16", "]"}], "]"}], "/", "8"}]}], " ", "+", 
   RowBox[{"4", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "17", "]"}], "]"}], "/", "16"}]}], "+", 
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"expected4wayFiniteSelfing", "[", 
      RowBox[{"[", "18", "]"}], "]"}], "/", "8"}]}]}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["2", 
       RowBox[{"-", "d"}]]}], ")"}], "*", "4"}], " ", "+", " ", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "2"}], "-", "d"}]], "*", "4"}]}], "//", 
  "FullSimplify"}]], "Input"]
},
WindowSize->{831, 670},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.8}},
TrackCellChangeTimes->False,
FrontEndVersion->"10.1 for Microsoft Windows (64-bit) (March 23, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 883, 25, 72, "Input"],
Cell[1444, 47, 2294, 61, 152, "Input"],
Cell[3741, 110, 4200, 108, 432, "Input"],
Cell[7944, 220, 8776, 228, 546, "Input"],
Cell[16723, 450, 458, 12, 52, "Input"],
Cell[17184, 464, 134, 4, 31, "Input"],
Cell[17321, 470, 172, 6, 31, "Input"],
Cell[17496, 478, 264, 8, 31, "Input"],
Cell[17763, 488, 561, 15, 72, "Input"],
Cell[18327, 505, 147, 4, 31, "Input"],
Cell[18477, 511, 512, 14, 72, "Input"],
Cell[18992, 527, 295, 7, 52, "Input"],
Cell[19290, 536, 398, 10, 31, "Input"],
Cell[19691, 548, 3552, 88, 403, "Input"],
Cell[23246, 638, 115, 3, 31, "Input"],
Cell[23364, 643, 647, 20, 72, "Input"],
Cell[24014, 665, 704, 16, 72, "Input"],
Cell[24721, 683, 3684, 113, 158, "Input"],
Cell[28408, 798, 2613, 71, 172, "Input"],
Cell[31024, 871, 12917, 325, 1103, "Input"],
Cell[43944, 1198, 154, 3, 31, "Input"],
Cell[44101, 1203, 194, 6, 31, "Input"],
Cell[44298, 1211, 167, 4, 31, "Input"],
Cell[44468, 1217, 115, 3, 31, "Input"],
Cell[44586, 1222, 176, 4, 31, "Input"],
Cell[44765, 1228, 545, 16, 52, "Input"],
Cell[45313, 1246, 1880, 47, 162, "Input"],
Cell[47196, 1295, 7619, 233, 257, "Input"],
Cell[54818, 1530, 3457, 98, 204, "Input"],
Cell[58278, 1630, 1259, 44, 46, "Input"],
Cell[59540, 1676, 787, 24, 53, "Input"],
Cell[60330, 1702, 700, 22, 53, "Input"],
Cell[61033, 1726, 3099, 87, 351, "Input"],
Cell[64135, 1815, 282, 8, 31, "Input"],
Cell[64420, 1825, 381, 9, 52, "Input"],
Cell[64804, 1836, 200, 7, 31, "Input"],
Cell[65007, 1845, 266, 8, 31, "Input"],
Cell[65276, 1855, 551, 15, 72, "Input"],
Cell[65830, 1872, 200, 7, 31, "Input"],
Cell[66033, 1881, 279, 6, 52, "Input"],
Cell[66315, 1889, 6494, 196, 376, "Input"],
Cell[72812, 2087, 161, 3, 31, "Input"],
Cell[72976, 2092, 4049, 125, 206, "Input"],
Cell[77028, 2219, 340, 10, 52, "Input"],
Cell[77371, 2231, 236, 7, 31, "Input"],
Cell[77610, 2240, 348, 10, 52, "Input"],
Cell[77961, 2252, 1590, 43, 152, "Input"],
Cell[79554, 2297, 195, 4, 31, "Input"],
Cell[79752, 2303, 420, 13, 31, "Input"],
Cell[80175, 2318, 5579, 140, 532, "Input"],
Cell[85757, 2460, 1118, 32, 72, "Input"],
Cell[86878, 2494, 1043, 30, 72, "Input"],
Cell[87924, 2526, 1039, 30, 72, "Input"],
Cell[88966, 2558, 1114, 32, 72, "Input"],
Cell[90083, 2592, 42, 0, 31, "Input"],
Cell[90128, 2594, 194, 5, 31, "Input"],
Cell[90325, 2601, 1017, 28, 92, "Input"],
Cell[91345, 2631, 247, 7, 31, "Input"],
Cell[91595, 2640, 1063, 31, 92, "Input"],
Cell[92661, 2673, 247, 7, 31, "Input"],
Cell[92911, 2682, 1495, 43, 132, "Input"],
Cell[94409, 2727, 197, 5, 31, "Input"],
Cell[94609, 2734, 1054, 29, 92, "Input"],
Cell[95666, 2765, 295, 8, 31, "Input"],
Cell[95964, 2775, 1091, 31, 92, "Input"],
Cell[97058, 2808, 385, 11, 52, "Input"],
Cell[97446, 2821, 1240, 35, 112, "Input"],
Cell[98689, 2858, 354, 13, 46, "Input"]
}
]
*)

(* End of internal cache information *)
