/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import java.util.ArrayList;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Difuso;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Individuo;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Regla;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.myDataset;
import org.core.Fichero;

public class BaseR {
    ArrayList<Regla> baseReglas;
    BaseD baseDatos;
    myDataset train;
    int n_variables;
    int n_etiquetas;
    double[] GradoEmp;
    Difuso[] Consecuentes;

    public boolean BETTER(int a, int b) {
        return a > b;
    }

    public BaseR() {
    }

    public BaseR(BaseD baseDatos, myDataset train) {
        this.baseReglas = new ArrayList();
        this.baseDatos = baseDatos;
        this.train = train;
        this.n_variables = baseDatos.numVariables();
        this.n_etiquetas = baseDatos.n_etiquetas;
        this.generaReglas();
    }

    private void generaReglas() {
        int[] regla = new int[this.n_variables - 1];
        this.RecorreAntecedentes(regla, 0);
        this.GradoEmp = new double[this.baseReglas.size()];
        this.Consecuentes = new Difuso[this.baseReglas.size()];
        for (int i = 0; i < this.Consecuentes.length; ++i) {
            this.Consecuentes[i] = new Difuso();
        }
    }

    void RecorreAntecedentes(int[] Regla_act, int pos) {
        if (pos == this.n_variables - 1) {
            this.crearRegla(Regla_act);
        } else {
            Regla_act[pos] = 0;
            while (Regla_act[pos] < this.n_etiquetas) {
                this.RecorreAntecedentes(Regla_act, pos + 1);
                int n = pos;
                Regla_act[n] = Regla_act[n] + 1;
            }
        }
    }

    void crearRegla(int[] antecedente) {
        Regla r = new Regla(this.baseDatos);
        r.asignaAntecedente(antecedente);
        this.baseReglas.add(r);
    }

    public String printString() {
        String cadena = "";
        cadena = cadena + "Number of rules: " + this.baseReglas.size() + "\n\n";
        for (int i = 0; i < this.baseReglas.size(); ++i) {
            int j;
            Regla r = this.baseReglas.get(i);
            for (j = 0; j < this.n_variables - 1; ++j) {
                cadena = cadena + this.baseDatos.baseDatos[j][r.antecedente[j]].nombre + ": \t" + this.baseDatos.baseDatos[j][r.antecedente[j]].x0 + "\t" + this.baseDatos.baseDatos[j][r.antecedente[j]].x1 + "\t" + this.baseDatos.baseDatos[j][r.antecedente[j]].x3 + "\n";
            }
            cadena = cadena + "Output: " + this.baseDatos.baseDatos[this.n_variables - 1][r.consecuente].nombre + ": \t" + this.baseDatos.baseDatos[j][r.consecuente].x0 + "\t" + this.baseDatos.baseDatos[j][r.consecuente].x1 + "\t" + this.baseDatos.baseDatos[j][r.consecuente].x3 + "\n\n";
        }
        return cadena;
    }

    public void escribeFichero(String filename) {
        String cadenaSalida = new String("");
        cadenaSalida = this.printString();
        Fichero.escribeFichero(filename, cadenaSalida);
    }

    public int size() {
        return this.baseReglas.size();
    }

    public int numEtiquetas() {
        return this.n_etiquetas;
    }

    public Regla dameRegla(int pos) {
        return this.baseReglas.get(pos);
    }

    public void ajusta(Individuo ind) {
        int[] cromosoma1 = ind.cromosoma1;
        double[] cromosoma2 = ind.cromosoma2;
        for (int i = 0; i < cromosoma1.length; ++i) {
            this.baseReglas.get((int)i).consecuente = cromosoma1[i];
        }
        this.baseDatos.ajusta(cromosoma2);
    }

    public void Min(double[] entradas) {
        for (int b = 0; b < this.baseReglas.size(); ++b) {
            this.GradoEmp[b] = this.baseReglas.get(b).compatibilidadMinimo(entradas);
        }
    }

    public void T_Min() {
        for (int b = 0; b < this.baseReglas.size(); ++b) {
            Regla r = this.baseReglas.get(b);
            Difuso d = this.baseDatos.baseDatos[this.n_variables - 1][r.consecuente];
            if (this.GradoEmp[b] != 0.0) {
                if (this.GradoEmp[b] == 1.0) {
                    this.Consecuentes[b].x0 = d.x0;
                    this.Consecuentes[b].x1 = d.x1;
                    this.Consecuentes[b].x2 = d.x2;
                    this.Consecuentes[b].x3 = d.x3;
                } else {
                    this.Consecuentes[b].x0 = d.x0;
                    this.Consecuentes[b].x1 = d.x0 + (d.x1 - d.x0) * this.GradoEmp[b];
                    this.Consecuentes[b].x2 = d.x3 + (d.x2 - d.x3) * this.GradoEmp[b];
                    this.Consecuentes[b].x3 = d.x3;
                }
            }
            this.Consecuentes[b].y = this.GradoEmp[b];
        }
    }

    public double AreaTrapecioX(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (2.0 * x1 * x1 * x1 - 3.0 * x0 * x1 * x1 + x0 * x0 * x0) / (6.0 * (x1 - x0)) : 0.0;
        double centro = (x2 * x2 - x1 * x1) / 2.0;
        double der = x3 != x2 ? (2.0 * x2 * x2 * x2 - 3.0 * x3 * x2 * x2 + x3 * x3 * x3) / (6.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double AreaTrapecio(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (x1 * x1 - 2.0 * x0 * x1 + x0 * x0) / (2.0 * (x1 - x0)) : 0.0;
        double centro = x2 - x1;
        double der = x3 != x2 ? (x3 * x3 - 2.0 * x3 * x2 + x2 * x2) / (2.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double WECOA() {
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < this.baseReglas.size(); ++i) {
            if (this.Consecuentes[i].y == 0.0) continue;
            num += this.GradoEmp[i] * (this.AreaTrapecioX(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y) / this.AreaTrapecio(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y));
            den += this.GradoEmp[i];
        }
        if (den != 0.0) {
            return num / den;
        }
        return 0.0;
    }

    public double FLC(double[] Entrada) {
        this.Min(Entrada);
        this.T_Min();
        return this.WECOA();
    }
}

