/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Intervals;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.myDataset;

public class DataB {
    int n_variables;
    int partitions;
    int[] nIntervals;
    Intervals[][] dataBase;

    public DataB() {
    }

    public DataB(int nIntervals, myDataset train) {
        double[][] ranks = train.getRanks();
        this.n_variables = train.getnVars();
        this.nIntervals = new int[this.n_variables];
        this.dataBase = new Intervals[this.n_variables][];
        for (int i = 0; i < this.n_variables; ++i) {
            double value;
            int j;
            double rank = Math.abs(ranks[i][1] - ranks[i][0]);
            this.nIntervals[i] = train.isNominal(i) ? (int)rank + 1 : nIntervals;
            this.dataBase[i] = new Intervals[this.nIntervals[i]];
            if (train.isNominal(i)) {
                for (j = 0; j < this.nIntervals[i]; ++j) {
                    this.dataBase[i][j] = new Intervals();
                    this.dataBase[i][j].x0 = this.dataBase[i][j].x1 = (value = ranks[i][0] + (double)j);
                }
                continue;
            }
            double mark = rank / (double)this.nIntervals[i];
            for (j = 0; j < this.nIntervals[i]; ++j) {
                this.dataBase[i][j] = new Intervals();
                value = ranks[i][0] + mark * (double)j;
                this.dataBase[i][j].x0 = this.setValue(value, ranks[i][0]);
                value = ranks[i][0] + mark * (double)(j + 1);
                this.dataBase[i][j].x1 = this.setValue(value, ranks[i][1]);
            }
        }
    }

    public int numVariables() {
        return this.n_variables;
    }

    public int numIntervals(int variable) {
        return this.nIntervals[variable];
    }

    public int[] getnIntervals() {
        return this.nIntervals;
    }

    public Intervals getInterval(int variable, int inter) {
        return this.dataBase[variable][inter];
    }

    public boolean isCovered(int variable, int interval, double value) {
        return this.dataBase[variable][interval].isCovered(value);
    }

    private double setValue(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }
}

